/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.platform.convert.ooomanager;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import org.apache.commons.io.FileUtils;
import org.apache.commons.lang.ArrayUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.artofsolving.jodconverter.OfficeDocumentConverter;
import org.artofsolving.jodconverter.office.DefaultOfficeManagerConfiguration;
import org.artofsolving.jodconverter.office.OfficeConnectionProtocol;
import org.artofsolving.jodconverter.office.OfficeException;
import org.artofsolving.jodconverter.office.OfficeManager;
import org.artofsolving.jodconverter.office.OfficeTask;
import org.nuxeo.ecm.platform.convert.ooomanager.ConfigBuilderHelper;
import org.nuxeo.ecm.platform.convert.ooomanager.OOoManagerDescriptor;
import org.nuxeo.ecm.platform.convert.ooomanager.OOoManagerService;
import org.nuxeo.runtime.api.Framework;
import org.nuxeo.runtime.model.ComponentContext;
import org.nuxeo.runtime.model.ComponentInstance;
import org.nuxeo.runtime.model.DefaultComponent;

@Deprecated
public class OOoManagerComponent
extends DefaultComponent
implements OOoManagerService {
    protected static final Log log = LogFactory.getLog(OOoManagerComponent.class);
    private static final String CONNECTION_PROTOCOL_PROPERTY_KEY = "jod.connection.protocol";
    private static final String MAX_TASKS_PER_PROCESS_PROPERTY_KEY = "jod.max.tasks.per.process";
    private static final String OFFICE_HOME_PROPERTY_KEY = "jod.office.home";
    private static final String TASK_EXECUTION_TIMEOUT_PROPERTY_KEY = "jod.task.execution.timeout";
    private static final String TASK_QUEUE_TIMEOUT_PROPERTY_KEY = "jod.task.queue.timeout";
    private static final String TEMPLATE_PROFILE_DIR_PROPERTY_KEY = "jod.template.profile.dir";
    private static final String OFFICE_PIPES_PROPERTY_KEY = "jod.office.pipes";
    private static final String OFFICE_PORTS_PROPERTY_KEY = "jod.office.ports";
    protected static final String CONFIG_EP = "oooManagerConfig";
    private static OfficeManager officeManager;
    protected OOoManagerDescriptor descriptor = new OOoManagerDescriptor();
    protected boolean started = false;
    protected boolean starting = false;
    protected boolean shutingdown = false;

    public OOoManagerDescriptor getDescriptor() {
        return this.descriptor;
    }

    public void registerContribution(Object contribution, String extensionPoint, ComponentInstance contributor) {
        if (CONFIG_EP.equals(extensionPoint)) {
            OOoManagerDescriptor desc;
            this.descriptor = desc = (OOoManagerDescriptor)contribution;
        }
    }

    public void deactivate(ComponentContext context) {
        this.stopOOoManager();
    }

    @Override
    public OfficeDocumentConverter getDocumentConverter() {
        if (this.isOOoManagerStarted()) {
            return new OfficeDocumentConverter(officeManager);
        }
        log.error((Object)"OfficeManager is not started.");
        return null;
    }

    public void executeTask(OfficeTask task) {
        if (this.isOOoManagerStarted()) {
            officeManager.execute(task);
        } else {
            log.error((Object)"OfficeManager is not started.");
        }
    }

    @Override
    public void stopOOoManager() {
        if (this.isOOoManagerStarted() && !this.shutingdown) {
            this.shutingdown = true;
            officeManager.stop();
            this.started = false;
            this.shutingdown = false;
            log.debug((Object)"Stopping ooo manager.");
        } else {
            log.debug((Object)"OOoManager already stopped..");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void startOOoManager() throws IOException {
        DefaultOfficeManagerConfiguration configuration = new DefaultOfficeManagerConfiguration();
        if (!this.descriptor.isEnabled()) {
            return;
        }
        this.starting = true;
        try {
            String templateProfileDir;
            String taskQueueTimeoutProperty;
            String taskExecutionTimeoutProperty;
            String officeHome;
            String maxTasksPerProcessProperty;
            String connectionProtocol = Framework.getProperty((String)CONNECTION_PROTOCOL_PROPERTY_KEY);
            if (connectionProtocol != null && !"".equals(connectionProtocol)) {
                if (OfficeConnectionProtocol.PIPE.toString().equals(connectionProtocol)) {
                    ConfigBuilderHelper.hackClassLoader();
                    configuration.setConnectionProtocol(OfficeConnectionProtocol.PIPE);
                } else if (OfficeConnectionProtocol.SOCKET.toString().equals(connectionProtocol)) {
                    configuration.setConnectionProtocol(OfficeConnectionProtocol.SOCKET);
                }
            }
            if ((maxTasksPerProcessProperty = Framework.getProperty((String)MAX_TASKS_PER_PROCESS_PROPERTY_KEY)) != null && !"".equals(maxTasksPerProcessProperty)) {
                Integer maxTasksPerProcess = Integer.valueOf(maxTasksPerProcessProperty);
                configuration.setMaxTasksPerProcess(maxTasksPerProcess.intValue());
            }
            if ((officeHome = Framework.getProperty((String)OFFICE_HOME_PROPERTY_KEY)) != null && !"".equals(officeHome)) {
                configuration.setOfficeHome(officeHome);
            }
            if ((taskExecutionTimeoutProperty = Framework.getProperty((String)TASK_EXECUTION_TIMEOUT_PROPERTY_KEY)) != null && !"".equals(taskExecutionTimeoutProperty)) {
                Long taskExecutionTimeout = Long.valueOf(taskExecutionTimeoutProperty);
                configuration.setTaskExecutionTimeout(taskExecutionTimeout.longValue());
            }
            if ((taskQueueTimeoutProperty = Framework.getProperty((String)TASK_QUEUE_TIMEOUT_PROPERTY_KEY)) != null && !"".equals(taskQueueTimeoutProperty)) {
                Long taskQueueTimeout = Long.valueOf(taskQueueTimeoutProperty);
                configuration.setTaskQueueTimeout(taskQueueTimeout.longValue());
            }
            if ((templateProfileDir = Framework.getProperty((String)TEMPLATE_PROFILE_DIR_PROPERTY_KEY)) != null && !"".equals(templateProfileDir)) {
                File templateDirectory = new File(templateProfileDir);
                if (!templateDirectory.exists()) {
                    try {
                        FileUtils.forceMkdir((File)templateDirectory);
                    }
                    catch (IOException e) {
                        throw new RuntimeException("I/O Error: could not create JOD templateDirectory");
                    }
                }
                configuration.setTemplateProfileDir(templateDirectory);
            }
            String pipeNamesProperty = Framework.getProperty((String)OFFICE_PIPES_PROPERTY_KEY);
            String[] pipeNames = null;
            if (pipeNamesProperty != null) {
                String[] unvalidatedPipeNames = pipeNamesProperty.split(",\\s*");
                ArrayList<String> validatedPipeNames = new ArrayList<String>();
                for (int i = 0; i < unvalidatedPipeNames.length; ++i) {
                    String tmpPipeName = unvalidatedPipeNames[i].trim();
                    if (tmpPipeName.length() <= 0) continue;
                    validatedPipeNames.add(tmpPipeName);
                }
                pipeNames = validatedPipeNames.toArray(new String[0]);
            } else {
                pipeNames = this.descriptor.getPipeNames();
            }
            if (pipeNames != null && pipeNames.length != 0) {
                configuration.setPipeNames(pipeNames);
            }
            String portNumbersProperty = Framework.getProperty((String)OFFICE_PORTS_PROPERTY_KEY);
            int[] portNumbers = null;
            if (portNumbersProperty != null) {
                String[] portStrings = portNumbersProperty.split(",\\s*");
                ArrayList<Integer> portList = new ArrayList<Integer>();
                for (int i = 0; i < portStrings.length; ++i) {
                    try {
                        portList.add(Integer.parseInt(portStrings[i].trim()));
                        continue;
                    }
                    catch (NumberFormatException e) {
                        log.error((Object)("Ignoring malformed port number: " + portStrings[i]));
                    }
                }
                portNumbers = ArrayUtils.toPrimitive((Integer[])portList.toArray(new Integer[0]));
            } else {
                portNumbers = this.descriptor.getPortNumbers();
            }
            if (portNumbers != null && portNumbers.length != 0) {
                configuration.setPortNumbers(portNumbers);
            }
            try {
                officeManager = configuration.buildOfficeManager();
                officeManager.start();
                this.started = true;
                log.debug((Object)"Starting ooo manager.");
            }
            catch (IllegalStateException | OfficeException e) {
                this.started = false;
                Throwable t = this.unwrapException(e);
                log.warn((Object)("OpenOffice was not found, JOD Converter won't be available: " + t.getMessage()));
            }
        }
        finally {
            this.starting = false;
        }
    }

    public Throwable unwrapException(Throwable t) {
        Throwable cause = t.getCause();
        return cause == null ? t : this.unwrapException(cause);
    }

    public void applicationStarted(ComponentContext context) {
        log.info((Object)"Starting OOo manager");
        Runnable oooStarter = new Runnable(){

            @Override
            public void run() {
                try {
                    OOoManagerComponent.this.startOOoManager();
                }
                catch (IOException e) {
                    log.error((Object)"Could not start OOoManager.", (Throwable)e);
                }
            }
        };
        Thread oooStarterThread = new Thread(oooStarter);
        oooStarterThread.setDaemon(true);
        oooStarterThread.start();
        log.info((Object)"Started OOo Manager");
    }

    @Override
    public boolean isOOoManagerStarted() {
        if (this.shutingdown) {
            return false;
        }
        if (!this.starting) {
            return this.started;
        }
        for (int i = 0; i < 200; ++i) {
            if (this.starting) {
                try {
                    Thread.sleep(300L);
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
            }
            if (this.starting) continue;
            return this.started;
        }
        log.error((Object)"Timeout on waiting for officeManager to start");
        return this.started;
    }

    public OfficeManager getOfficeManager() {
        return officeManager;
    }
}

