/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.core.storage;

import java.io.IOException;
import java.util.LinkedList;
import java.util.List;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuxeo.ecm.core.api.Blob;
import org.nuxeo.ecm.core.api.DocumentLocation;
import org.nuxeo.ecm.core.api.DocumentModel;
import org.nuxeo.ecm.core.api.DocumentRef;
import org.nuxeo.ecm.core.api.IdRef;
import org.nuxeo.ecm.core.api.blobholder.BlobHolder;
import org.nuxeo.ecm.core.api.blobholder.SimpleBlobHolder;
import org.nuxeo.ecm.core.api.impl.DocumentLocationImpl;
import org.nuxeo.ecm.core.api.impl.blob.StringBlob;
import org.nuxeo.ecm.core.convert.api.ConversionException;
import org.nuxeo.ecm.core.convert.api.ConversionService;
import org.nuxeo.ecm.core.storage.FulltextConfiguration;
import org.nuxeo.ecm.core.storage.FulltextParser;
import org.nuxeo.ecm.core.storage.FulltextUpdaterWork;
import org.nuxeo.ecm.core.utils.BlobsExtractor;
import org.nuxeo.ecm.core.work.AbstractWork;
import org.nuxeo.ecm.core.work.api.Work;
import org.nuxeo.ecm.core.work.api.WorkManager;
import org.nuxeo.runtime.api.Framework;

public abstract class FulltextExtractorWork
extends AbstractWork {
    private static final long serialVersionUID = 1L;
    private static final Log log = LogFactory.getLog(FulltextExtractorWork.class);
    protected static final String ANY2TEXT = "any2text";
    protected static final String CATEGORY = "fulltextExtractor";
    protected static final String TITLE = "fulltextExtractor";
    protected final boolean excludeProxies;
    protected transient FulltextConfiguration fulltextConfiguration;
    protected transient FulltextParser fulltextParser;

    public FulltextExtractorWork(String repositoryName, String docId, String id, boolean excludeProxies) {
        super(id);
        this.setDocument(repositoryName, docId);
        this.excludeProxies = excludeProxies;
    }

    public String getCategory() {
        return "fulltextExtractor";
    }

    public String getTitle() {
        return "fulltextExtractor";
    }

    public int getRetryCount() {
        return 1;
    }

    public void work() {
        this.openSystemSession();
        if (this.session.getPrincipal() == null) {
            return;
        }
        this.initFulltextConfigurationAndParser();
        this.setStatus("Extracting");
        this.setProgress(Work.Progress.PROGRESS_0_PC);
        this.extractBinaryText();
        this.setProgress(Work.Progress.PROGRESS_100_PC);
        this.setStatus("Done");
    }

    public abstract void initFulltextConfigurationAndParser();

    protected void extractBinaryText() {
        IdRef docRef = new IdRef(this.docId);
        if (!this.session.exists((DocumentRef)docRef)) {
            return;
        }
        DocumentModel doc = this.session.getDocument((DocumentRef)docRef);
        if (this.excludeProxies && doc.isProxy()) {
            return;
        }
        if (!this.fulltextConfiguration.isFulltextIndexable(doc.getType())) {
            return;
        }
        BlobsExtractor extractor = new BlobsExtractor();
        DocumentLocationImpl docLocation = new DocumentLocationImpl(doc);
        LinkedList<FulltextUpdaterWork.IndexAndText> indexesAndText = new LinkedList<FulltextUpdaterWork.IndexAndText>();
        for (String indexName : this.fulltextConfiguration.indexNames) {
            if (!this.fulltextConfiguration.indexesAllBinary.contains(indexName) && this.fulltextConfiguration.propPathsByIndexBinary.get(indexName) == null) continue;
            extractor.setExtractorProperties(this.fulltextConfiguration.propPathsByIndexBinary.get(indexName), this.fulltextConfiguration.propPathsExcludedByIndexBinary.get(indexName), this.fulltextConfiguration.indexesAllBinary.contains(indexName));
            List blobs = extractor.getBlobs(doc);
            StringBlob stringBlob = this.blobsToStringBlob(blobs, this.docId);
            String text = this.fulltextParser.parse(stringBlob.getString(), null, stringBlob.getMimeType(), (DocumentLocation)docLocation);
            int fullTextFieldSizeLimit = this.fulltextConfiguration.fulltextFieldSizeLimit;
            if (fullTextFieldSizeLimit != 0 && text.length() > fullTextFieldSizeLimit) {
                if (log.isDebugEnabled()) {
                    log.debug((Object)String.format("Fulltext extract of length: %s for indexName: %s of document: %s truncated to length: %s", text.length(), indexName, this.docId, fullTextFieldSizeLimit));
                }
                text = text.substring(0, fullTextFieldSizeLimit);
            }
            indexesAndText.add(new FulltextUpdaterWork.IndexAndText(indexName, text));
        }
        if (!indexesAndText.isEmpty()) {
            FulltextUpdaterWork work = new FulltextUpdaterWork(this.repositoryName, this.docId, false, true, indexesAndText);
            if (!this.fulltextConfiguration.fulltextSearchDisabled) {
                WorkManager workManager = (WorkManager)Framework.getLocalService(WorkManager.class);
                workManager.schedule((Work)work, true);
            } else {
                work.updateWithSession(this.session);
            }
        }
    }

    public void cleanUp(boolean ok, Exception e) {
        super.cleanUp(ok, e);
        this.fulltextConfiguration = null;
        this.fulltextParser = null;
    }

    protected StringBlob blobsToStringBlob(List<Blob> blobs, String docId) {
        String mimeType = null;
        LinkedList<String> strings = new LinkedList<String>();
        for (Blob blob : blobs) {
            try {
                String string;
                SimpleBlobHolder bh = new SimpleBlobHolder(blob);
                BlobHolder result = this.convert((BlobHolder)bh);
                if (result == null || (blob = result.getBlob()) == null) continue;
                if (StringUtils.isEmpty(mimeType) && StringUtils.isNotEmpty((String)blob.getMimeType())) {
                    mimeType = blob.getMimeType();
                }
                if ((string = new String(blob.getByteArray(), "UTF-8")).indexOf(0) >= 0) {
                    string = string.replace("\u0000", " ");
                }
                strings.add(string);
            }
            catch (IOException | ConversionException e) {
                String msg = "Could not extract fulltext of file '" + blob.getFilename() + "' for document: " + docId + ": " + e;
                log.warn((Object)msg);
                log.debug((Object)msg, e);
            }
        }
        return new StringBlob(StringUtils.join(strings, (String)" "), mimeType);
    }

    protected BlobHolder convert(BlobHolder blobHolder) throws ConversionException {
        ConversionService conversionService = (ConversionService)Framework.getLocalService(ConversionService.class);
        if (conversionService == null) {
            log.debug((Object)"No ConversionService available");
            return null;
        }
        return conversionService.convert(ANY2TEXT, blobHolder, null);
    }
}

