/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.core.api.blobholder;

import java.io.Serializable;
import java.util.Calendar;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.nuxeo.ecm.core.api.Blob;
import org.nuxeo.ecm.core.api.DocumentModel;
import org.nuxeo.ecm.core.api.blobholder.AbstractBlobHolder;
import org.nuxeo.ecm.core.utils.BlobsExtractor;

public class DocumentBlobHolder
extends AbstractBlobHolder {
    protected final DocumentModel doc;
    protected final String xPath;
    protected List<Blob> blobList = null;

    public DocumentBlobHolder(DocumentModel doc, String xPath) {
        this.doc = doc;
        this.xPath = xPath;
    }

    @Override
    protected String getBasePath() {
        return this.doc.getPathAsString();
    }

    @Override
    public Blob getBlob() {
        return (Blob)((Object)this.doc.getPropertyValue(this.xPath));
    }

    @Override
    public void setBlob(Blob blob) {
        this.doc.getProperty(this.xPath).setValue(blob);
    }

    @Override
    public Calendar getModificationDate() {
        return (Calendar)this.doc.getProperty("dublincore", "modified");
    }

    @Override
    public String getHash() {
        String h;
        Blob blob = this.getBlob();
        if (blob != null && (h = blob.getDigest()) != null) {
            return h;
        }
        return this.doc.getId() + this.xPath + String.valueOf(this.getModificationDate());
    }

    @Override
    public Serializable getProperty(String name) {
        return null;
    }

    @Override
    public Map<String, Serializable> getProperties() {
        return null;
    }

    @Override
    public List<Blob> getBlobs() {
        if (this.blobList == null) {
            List<Blob> blobs = new BlobsExtractor().getBlobs(this.doc);
            Blob main = this.getBlob();
            if (main != null) {
                Iterator<Blob> bi = blobs.iterator();
                while (bi.hasNext()) {
                    Blob blob = bi.next();
                    if (blob.getDigest() != null) {
                        if (!blob.getDigest().equals(main.getDigest())) continue;
                        bi.remove();
                        break;
                    }
                    if (blob.getFilename() == null || !blob.getFilename().equals(main.getFilename())) continue;
                    bi.remove();
                    break;
                }
                blobs.add(0, main);
            }
            this.blobList = blobs;
        }
        return this.blobList;
    }

    public String getXpath() {
        return this.xPath;
    }

    public DocumentModel getDocument() {
        return this.doc;
    }
}

