/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.core.api.model.impl;

import java.io.Serializable;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import org.nuxeo.ecm.core.api.PropertyException;
import org.nuxeo.ecm.core.api.model.InvalidPropertyValueException;
import org.nuxeo.ecm.core.api.model.Property;
import org.nuxeo.ecm.core.api.model.PropertyConversionException;
import org.nuxeo.ecm.core.api.model.PropertyNotFoundException;
import org.nuxeo.ecm.core.api.model.PropertyVisitor;
import org.nuxeo.ecm.core.api.model.ReadOnlyPropertyException;
import org.nuxeo.ecm.core.api.model.impl.AbstractProperty;
import org.nuxeo.ecm.core.api.model.impl.DirtyPropertyIterator;
import org.nuxeo.ecm.core.schema.types.ComplexType;
import org.nuxeo.ecm.core.schema.types.Field;

public abstract class ComplexProperty
extends AbstractProperty
implements Map<String, Property> {
    private static final long serialVersionUID = 1L;
    protected Map<String, Property> children = new HashMap<String, Property>();

    protected ComplexProperty(Property parent) {
        super(parent);
    }

    protected ComplexProperty(Property parent, int flags) {
        super(parent, flags);
    }

    protected Property internalGetChild(Field field) {
        return null;
    }

    public abstract ComplexType getType();

    @Override
    public boolean isNormalized(Object value) {
        return value == null || value instanceof Map;
    }

    @Override
    public Serializable normalize(Object value) throws PropertyConversionException {
        if (this.isNormalized(value)) {
            return (Serializable)value;
        }
        throw new PropertyConversionException(value.getClass(), Map.class, this.getXPath());
    }

    @Override
    public Property get(int index) {
        throw new UnsupportedOperationException("accessing children by index is not allowed for complex properties");
    }

    public final Property getNonPhantomChild(Field field) {
        String name = field.getName().getPrefixedName();
        Property property = this.children.get(name);
        if (property == null) {
            property = this.internalGetChild(field);
            if (property == null) {
                return null;
            }
            this.children.put(name, property);
        }
        return property;
    }

    public final Property getChild(Field field) {
        Property property = this.getNonPhantomChild(field);
        if (property == null) {
            property = this.getRoot().createProperty(this, field, 16);
            this.children.put(property.getName(), property);
        }
        return property;
    }

    public final Collection<Property> getNonPhantomChildren() {
        ComplexType type = this.getType();
        if (this.children.size() < type.getFieldsCount()) {
            for (Field field : type.getFields()) {
                this.getNonPhantomChild(field);
            }
        }
        return Collections.unmodifiableCollection(this.children.values());
    }

    @Override
    public Collection<Property> getChildren() {
        ComplexType type = this.getType();
        if (this.children.size() < type.getFieldsCount()) {
            for (Field field : type.getFields()) {
                this.getChild(field);
            }
        }
        return Collections.unmodifiableCollection(this.children.values());
    }

    @Override
    public Property get(String name) throws PropertyNotFoundException {
        Field field = this.getType().getField(name);
        if (field == null) {
            return null;
        }
        return this.getChild(field);
    }

    @Override
    public Serializable internalGetValue() throws PropertyException {
        HashMap<String, Serializable> map = new HashMap<String, Serializable>();
        for (Property property : this.getChildren()) {
            map.put(property.getName(), property.getValue());
        }
        return map;
    }

    @Override
    public Serializable getValueForWrite() throws PropertyException {
        if (this.isPhantom() || this.isRemoved()) {
            return this.getDefaultValue();
        }
        HashMap<String, Serializable> map = new HashMap<String, Serializable>();
        for (Property property : this.getChildren()) {
            map.put(property.getName(), property.getValueForWrite());
        }
        return map;
    }

    @Override
    public void init(Serializable value) throws PropertyException {
        if (value == null) {
            return;
        }
        Map map = (Map)((Object)value);
        for (Map.Entry entry : map.entrySet()) {
            Property property = this.get((String)entry.getKey());
            property.init((Serializable)entry.getValue());
        }
        this.removePhantomFlag();
    }

    @Override
    protected Serializable getDefaultValue() {
        return new HashMap();
    }

    @Override
    public void setValue(Object value) throws PropertyException {
        if (!this.isContainer()) {
            super.setValue(value);
            return;
        }
        if (this.isReadOnly()) {
            throw new ReadOnlyPropertyException(this.getXPath());
        }
        if (value == null) {
            this.remove();
            for (Property child : this.children.values()) {
                child.remove();
            }
            return;
        }
        if (!(value instanceof Map)) {
            throw new InvalidPropertyValueException(this.getXPath());
        }
        Map map = (Map)value;
        for (Map.Entry entry : map.entrySet()) {
            Property property = this.get((String)entry.getKey());
            if (property.isPhantom() && this.isNew()) {
                property.setForceDirty(true);
            }
            property.setValue(entry.getValue());
        }
    }

    @Override
    public Property addValue(Object value) {
        throw new UnsupportedOperationException("add(value) operation not supported on map properties");
    }

    @Override
    public Property addValue(int index, Object value) {
        throw new UnsupportedOperationException("add(value, index) operation not supported on map properties");
    }

    @Override
    public Property addEmpty() {
        throw new UnsupportedOperationException("add() operation not supported on map properties");
    }

    public void visitChildren(PropertyVisitor visitor, Object arg) throws PropertyException {
        boolean includePhantoms = visitor.acceptPhantoms();
        if (includePhantoms) {
            for (Property property : this.getChildren()) {
                property.accept(visitor, arg);
            }
        } else {
            for (Field field : this.getType().getFields()) {
                Property property = this.getNonPhantomChild(field);
                if (property == null || property.isPhantom()) continue;
                property.accept(visitor, arg);
            }
        }
    }

    @Override
    public boolean isSameAs(Property property) throws PropertyException {
        if (!(property instanceof ComplexProperty)) {
            return false;
        }
        ComplexProperty cp = (ComplexProperty)property;
        if (this.isContainer()) {
            if (!cp.isContainer()) {
                return false;
            }
            Collection<Property> c1 = this.getNonPhantomChildren();
            Collection<Property> c2 = cp.getNonPhantomChildren();
            if (c1.size() != c2.size()) {
                return false;
            }
            for (Property p : c1) {
                Property child = cp.getNonPhantomChild(p.getField());
                if (child == null) {
                    return false;
                }
                if (p.isSameAs(child)) continue;
                return false;
            }
        }
        return true;
    }

    @Override
    public Iterator<Property> getDirtyChildren() {
        if (!this.isContainer()) {
            throw new UnsupportedOperationException("Cannot iterate over children of scalar properties");
        }
        return new DirtyPropertyIterator(this.children.values().iterator());
    }

    @Override
    public void clear() {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean containsKey(Object key) {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean containsValue(Object value) {
        throw new UnsupportedOperationException();
    }

    @Override
    public Set<Map.Entry<String, Property>> entrySet() {
        return this.children.entrySet();
    }

    @Override
    public Property get(Object key) {
        return this.children.get(key);
    }

    @Override
    public boolean isEmpty() {
        return this.children.isEmpty();
    }

    @Override
    public Set<String> keySet() {
        return this.children.keySet();
    }

    @Override
    public Property put(String key, Property value) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void putAll(Map<? extends String, ? extends Property> t) {
        throw new UnsupportedOperationException();
    }

    @Override
    public Property remove(Object key) {
        throw new UnsupportedOperationException();
    }

    @Override
    public Collection<Property> values() {
        return this.children.values();
    }

    @Override
    public void clearDirtyFlags() {
        super.clearDirtyFlags();
        for (Property child : this.children.values()) {
            if (child.isRemoved() || child.isPhantom()) continue;
            child.clearDirtyFlags();
        }
    }
}

