/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.connect.connector.http.proxy;

import java.io.IOException;
import java.io.InputStreamReader;
import java.io.Reader;
import java.io.StringReader;
import java.net.InetAddress;
import java.net.URL;
import java.net.UnknownHostException;
import javax.script.Invocable;
import javax.script.ScriptEngine;
import javax.script.ScriptEngineManager;
import javax.script.ScriptException;
import javax.script.SimpleBindings;
import javax.script.SimpleScriptContext;
import org.apache.commons.httpclient.HttpClient;
import org.apache.commons.httpclient.HttpMethod;
import org.apache.commons.httpclient.methods.GetMethod;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuxeo.connect.NuxeoConnectClient;
import org.nuxeo.connect.connector.http.ConnectUrlConfig;
import org.nuxeo.connect.connector.http.proxy.ProxyPacResolver;
import org.nuxeo.connect.connector.http.proxy.SimpleStringCache;

public class NashornProxyPacResolver
extends ProxyPacResolver {
    private static final Log log = LogFactory.getLog(NashornProxyPacResolver.class);
    protected static final String PAC_FUNCTIONS_FILE = "proxy_pac_functions.js";
    protected static final String EXEC_PAC_FUNC = "FindProxyForURL";
    protected SimpleStringCache fileCache = new SimpleStringCache(5);

    @Override
    public String[] findPacProxies(String url) {
        ScriptEngine engine = new ScriptEngineManager().getEngineByName("nashorn");
        SimpleScriptContext context = new SimpleScriptContext();
        engine.setContext(context);
        SimpleBindings bindings = new SimpleBindings();
        context.setBindings(bindings, 100);
        try {
            engine.eval("var NashornProxyPacResolver = Java.type('" + this.getClass().getName() + "');" + "var dnsResolve = NashornProxyPacResolver.dnsResolve;" + "var myIpAddress = NashornProxyPacResolver.myIpAddress");
            engine.eval(this.getFileReader(PAC_FUNCTIONS_FILE));
            engine.eval(this.getRemotePacBodyReader());
            String proxies = (String)((Invocable)((Object)engine)).invokeFunction(EXEC_PAC_FUNC, url, NashornProxyPacResolver.getHost(url));
            return proxies.split(";");
        }
        catch (IOException | NoSuchMethodException | ScriptException e) {
            log.warn((Object)e, (Throwable)e);
            return null;
        }
    }

    protected Reader getFileReader(String filename) throws IOException {
        URL resource = this.getClass().getClassLoader().getResource(filename);
        if (resource == null) {
            throw new IOException("Unable to find file: " + filename);
        }
        return new InputStreamReader(resource.openStream());
    }

    protected Reader getRemotePacBodyReader() throws IOException {
        if (NuxeoConnectClient.isTestModeSet()) {
            return this.getFileReader(System.getProperty("nuxeo.test.pac.fake.remote.file"));
        }
        if (this.fileCache.getValue() == null) {
            HttpClient client = new HttpClient();
            GetMethod method = new GetMethod(ConnectUrlConfig.getProxyPacUrl());
            int status = client.executeMethod((HttpMethod)method);
            if (status == 200) {
                this.fileCache.saveValue(method.getResponseBodyAsString());
            } else {
                throw new IOException("Unable to get pac file");
            }
        }
        return new StringReader(this.fileCache.getValue());
    }

    public static String dnsResolve(String host) {
        try {
            return InetAddress.getByName(host).getHostAddress();
        }
        catch (UnknownHostException e) {
            return "";
        }
    }

    public static String myIpAddress() {
        try {
            return InetAddress.getLocalHost().getHostAddress();
        }
        catch (UnknownHostException e) {
            return "127.0.0.1";
        }
    }
}

