/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.connect.packages;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuxeo.connect.NuxeoConnectClient;
import org.nuxeo.connect.connector.ConnectServerError;
import org.nuxeo.connect.data.DownloadablePackage;
import org.nuxeo.connect.data.DownloadingPackage;
import org.nuxeo.connect.downloads.ConnectDownloadManager;
import org.nuxeo.connect.packages.DownloadingPackageSource;
import org.nuxeo.connect.packages.LocalPackageSource;
import org.nuxeo.connect.packages.PackageComparator;
import org.nuxeo.connect.packages.PackageManager;
import org.nuxeo.connect.packages.PackageSource;
import org.nuxeo.connect.packages.RemotePackageSource;
import org.nuxeo.connect.packages.dependencies.CUDFHelper;
import org.nuxeo.connect.packages.dependencies.DependencyException;
import org.nuxeo.connect.packages.dependencies.DependencyResolution;
import org.nuxeo.connect.packages.dependencies.DependencyResolver;
import org.nuxeo.connect.packages.dependencies.LegacyDependencyResolver;
import org.nuxeo.connect.packages.dependencies.P2CUDFDependencyResolver;
import org.nuxeo.connect.packages.dependencies.TargetPlatformFilterHelper;
import org.nuxeo.connect.registration.ConnectRegistrationService;
import org.nuxeo.connect.update.LocalPackage;
import org.nuxeo.connect.update.Package;
import org.nuxeo.connect.update.PackageDependency;
import org.nuxeo.connect.update.PackageException;
import org.nuxeo.connect.update.PackageType;
import org.nuxeo.connect.update.PackageUpdateService;
import org.nuxeo.connect.update.PackageVisibility;
import org.nuxeo.connect.update.Version;
import org.nuxeo.connect.update.VersionRange;
import org.nuxeo.connect.update.task.Task;

public class PackageManagerImpl
implements PackageManager {
    protected static final Log log = LogFactory.getLog(PackageManagerImpl.class);
    protected List<PackageSource> localSources = new ArrayList<PackageSource>();
    protected List<PackageSource> remoteSources = new ArrayList<PackageSource>();
    protected List<String> sourcesNames = new ArrayList<String>();
    @Deprecated
    protected Map<String, DownloadablePackage> cachedPackageList = null;
    protected DependencyResolver resolver;

    @Override
    public List<PackageSource> getAllSources() {
        ArrayList<PackageSource> allSources = new ArrayList<PackageSource>();
        allSources.addAll(this.remoteSources);
        allSources.addAll(this.localSources);
        return allSources;
    }

    public PackageManagerImpl() {
        this.registerSource(new RemotePackageSource(), false);
        this.registerSource(new DownloadingPackageSource(), true);
        this.registerSource(new LocalPackageSource(), true);
        this.setResolver("p2cudf");
    }

    @Override
    public void setResolver(String resolverType) {
        if ("p2cudf".equals(resolverType)) {
            this.resolver = new P2CUDFDependencyResolver(this);
        } else if ("legacy".equals(resolverType)) {
            this.resolver = new LegacyDependencyResolver(this);
        } else {
            log.warn((Object)("Resolver " + resolverType + "is not supported - fallback on default resolver " + "p2cudf"));
            this.resolver = new P2CUDFDependencyResolver(this);
        }
    }

    public void resetSources() {
        this.localSources.clear();
        this.remoteSources.clear();
        this.sourcesNames.clear();
        if (this.cachedPackageList != null) {
            this.cachedPackageList.clear();
        }
    }

    protected List<DownloadablePackage> doMergePackages(List<PackageSource> sources, PackageType type, String targetPlatform) {
        List<DownloadablePackage> allPackages = this.getAllPackages(sources, type, targetPlatform);
        HashMap packagesByIdAndTargetPlatform = new HashMap();
        for (DownloadablePackage pkg : allPackages) {
            String[] targetPlatforms;
            String[] stringArray;
            if (targetPlatform != null) {
                String[] stringArray2 = new String[1];
                stringArray = stringArray2;
                stringArray2[0] = targetPlatform;
            } else {
                stringArray = targetPlatforms = pkg.getTargetPlatforms();
            }
            if (targetPlatforms == null) {
                targetPlatforms = new String[]{null};
            }
            for (String tp : targetPlatforms) {
                String key;
                HashMap<String, DownloadablePackage> packagesById = (HashMap<String, DownloadablePackage>)packagesByIdAndTargetPlatform.get(tp);
                if (packagesById == null) {
                    packagesById = new HashMap<String, DownloadablePackage>();
                    packagesByIdAndTargetPlatform.put(tp, packagesById);
                }
                if (packagesById.containsKey(key = pkg.getId())) {
                    if (!pkg.getVersion().greaterThan(((DownloadablePackage)packagesById.get(key)).getVersion())) continue;
                    packagesById.put(key, pkg);
                    continue;
                }
                packagesById.put(key, pkg);
            }
        }
        ArrayList<DownloadablePackage> result = new ArrayList<DownloadablePackage>();
        for (Map packagesById : packagesByIdAndTargetPlatform.values()) {
            for (DownloadablePackage pkg : packagesById.values()) {
                if (result.contains(pkg)) continue;
                result.add(pkg);
            }
        }
        Collections.sort(result, new PackageComparator());
        return result;
    }

    protected List<DownloadablePackage> getAllPackages(List<PackageSource> sources, PackageType type) {
        return this.getAllPackages(sources, type, null);
    }

    protected List<DownloadablePackage> getAllPackages(List<PackageSource> sources, PackageType type, String targetPlatform) {
        Map<String, DownloadablePackage> packagesById = this.getAllPackagesByID(sources, type, targetPlatform);
        return new ArrayList<DownloadablePackage>(packagesById.values());
    }

    protected Map<String, DownloadablePackage> getAllPackagesByID(List<PackageSource> sources, PackageType type) {
        return this.getAllPackagesByID(sources, type, null);
    }

    protected Map<String, DownloadablePackage> getAllPackagesByID(List<PackageSource> sources, PackageType type, String targetPlatform) {
        HashMap<String, DownloadablePackage> packagesById = new HashMap<String, DownloadablePackage>();
        for (PackageSource source : sources) {
            List<DownloadablePackage> packages = null;
            packages = type == null ? source.listPackages() : source.listPackages(type);
            for (DownloadablePackage pkg : packages) {
                if (!TargetPlatformFilterHelper.isCompatibleWithTargetPlatform(pkg, targetPlatform)) continue;
                packagesById.put(pkg.getId(), pkg);
            }
        }
        return packagesById;
    }

    @Override
    public Map<String, DownloadablePackage> getAllPackagesByID() {
        return this.getAllPackagesByID(this.getAllSources(), null);
    }

    @Override
    public Map<String, List<DownloadablePackage>> getAllPackagesByName() {
        return this.getAllPackagesByName(this.getAllSources(), null);
    }

    protected Map<String, List<DownloadablePackage>> getAllPackagesByName(List<PackageSource> sources, PackageType type) {
        HashMap<String, List<DownloadablePackage>> packagesByName = new HashMap<String, List<DownloadablePackage>>();
        for (PackageSource source : sources) {
            List<DownloadablePackage> packages = null;
            packages = type == null ? source.listPackages() : source.listPackages(type);
            for (DownloadablePackage pkg : packages) {
                List<DownloadablePackage> pkgsForName;
                if (!packagesByName.containsKey(pkg.getName())) {
                    pkgsForName = new ArrayList();
                    packagesByName.put(pkg.getName(), pkgsForName);
                } else {
                    pkgsForName = (List)packagesByName.get(pkg.getName());
                }
                pkgsForName.add(pkg);
            }
        }
        return packagesByName;
    }

    @Override
    public List<DownloadablePackage> findRemotePackages(String packageName) {
        ArrayList<DownloadablePackage> pkgs = new ArrayList<DownloadablePackage>();
        for (PackageSource source : this.remoteSources) {
            pkgs.addAll(source.listPackagesByName(packageName));
        }
        return pkgs;
    }

    @Override
    public List<DownloadablePackage> findLocalPackages(String packageName) {
        ArrayList<DownloadablePackage> pkgs = new ArrayList<DownloadablePackage>();
        for (PackageSource source : this.localSources) {
            for (DownloadablePackage pkg : source.listPackages()) {
                if (!pkg.getName().equals(packageName)) continue;
                pkgs.add(pkg);
            }
        }
        return pkgs;
    }

    @Override
    public List<Version> findLocalPackageVersions(String packageName) {
        ArrayList<Version> versions = new ArrayList<Version>();
        for (PackageSource source : this.localSources) {
            for (DownloadablePackage pkg : source.listPackages()) {
                if (!pkg.getName().equals(packageName)) continue;
                versions.add(pkg.getVersion());
            }
        }
        return versions;
    }

    @Override
    public List<Version> findLocalPackageInstalledVersions(String packageName) {
        ArrayList<Version> versions = new ArrayList<Version>();
        for (PackageSource source : this.localSources) {
            for (DownloadablePackage pkg : source.listPackages()) {
                if (!pkg.getName().equals(packageName) || !pkg.getPackageState().isInstalled()) continue;
                versions.add(pkg.getVersion());
            }
        }
        return versions;
    }

    @Override
    public DownloadablePackage findPackageById(String packageId) {
        DownloadablePackage pkg = this.findPackageById(packageId, this.localSources);
        if (pkg == null) {
            pkg = this.findPackageById(packageId, this.remoteSources);
        }
        return pkg;
    }

    @Override
    public DownloadablePackage findRemotePackageById(String packageId) {
        return this.findPackageById(packageId, this.remoteSources);
    }

    @Override
    public DownloadablePackage findLocalPackageById(String packageId) {
        return this.findPackageById(packageId, this.localSources);
    }

    protected DownloadablePackage findPackageById(String packageId, List<PackageSource> sources) {
        for (PackageSource source : sources) {
            DownloadablePackage pkg = source.getPackageById(packageId);
            if (pkg == null) continue;
            return pkg;
        }
        return null;
    }

    @Override
    public List<Version> getPreferedVersions(String pkgName) {
        ArrayList<Version> versions = new ArrayList<Version>();
        ArrayList<Version> installedVersions = new ArrayList<Version>();
        ArrayList<Version> localVersions = new ArrayList<Version>();
        ArrayList<Version> remoteVersions = new ArrayList<Version>();
        for (PackageSource source : this.localSources) {
            for (DownloadablePackage downloadablePackage : source.listPackagesByName(pkgName)) {
                if (downloadablePackage.getPackageState().isInstalled()) {
                    installedVersions.add(downloadablePackage.getVersion());
                    continue;
                }
                localVersions.add(downloadablePackage.getVersion());
            }
        }
        for (PackageSource source : this.remoteSources) {
            for (DownloadablePackage downloadablePackage : source.listPackagesByName(pkgName)) {
                remoteVersions.add(downloadablePackage.getVersion());
            }
        }
        Collections.sort(localVersions);
        Collections.sort(remoteVersions);
        versions.addAll(installedVersions);
        versions.addAll(localVersions);
        versions.addAll(remoteVersions);
        return versions;
    }

    @Override
    public List<Version> getAvailableVersion(String pkgName, VersionRange range, String targetPlatform) {
        ArrayList<Version> versions = new ArrayList<Version>();
        for (PackageSource source : this.getAllSources()) {
            for (DownloadablePackage downloadablePackage : source.listPackagesByName(pkgName)) {
                if (!range.matchVersion(downloadablePackage.getVersion()) || !TargetPlatformFilterHelper.isCompatibleWithTargetPlatform(downloadablePackage, targetPlatform) || versions.contains(downloadablePackage.getVersion())) continue;
                versions.add(downloadablePackage.getVersion());
            }
        }
        return versions;
    }

    @Override
    public List<DownloadablePackage> listPackages() {
        return this.listPackages(null, null);
    }

    @Override
    public List<DownloadablePackage> listPackages(String targetPlatform) {
        return this.listPackages(null, targetPlatform);
    }

    @Override
    public List<DownloadablePackage> listPackages(PackageType type) {
        return this.listPackages(type, null);
    }

    @Override
    public List<DownloadablePackage> listPackages(PackageType pkgType, String targetPlatform) {
        return this.doMergePackages(this.getAllSources(), pkgType, targetPlatform);
    }

    @Override
    public List<DownloadablePackage> searchPackages(String searchExpr) {
        return null;
    }

    @Override
    public void registerSource(PackageSource source, boolean local) {
        String name = source.getName();
        if (!this.sourcesNames.contains(name)) {
            if (local) {
                this.localSources.add(source);
            } else {
                this.remoteSources.add(source);
            }
        } else {
            log.warn((Object)("Already registered a package source named " + name));
        }
    }

    @Override
    public List<DownloadablePackage> listInstalledPackages() {
        ArrayList<DownloadablePackage> res = new ArrayList<DownloadablePackage>();
        for (PackageSource source : this.localSources) {
            for (DownloadablePackage pkg : source.listPackages()) {
                if (!pkg.getPackageState().isInstalled()) continue;
                res.add(pkg);
            }
        }
        Collections.sort(res, new PackageComparator());
        return res;
    }

    @Override
    public List<String> listInstalledPackagesNames(PackageType pkgType) {
        List<DownloadablePackage> installedPackages = this.listInstalledPackages();
        List<String> installedPackagesNames = installedPackages.stream().filter(pkg -> pkgType == null || pkg.getType() == pkgType).map(Package::getName).collect(Collectors.toList());
        return installedPackagesNames;
    }

    @Override
    public List<String> listHotfixesNames(String targetPlatform, boolean allowSNAPSHOT) {
        List<DownloadablePackage> hotFixes = this.listPackages(PackageType.HOT_FIX, targetPlatform);
        List<String> hotFixesNames = hotFixes.stream().filter(pkg -> allowSNAPSHOT || !pkg.getVersion().isSnapshot()).map(Package::getName).distinct().collect(Collectors.toList());
        return hotFixesNames;
    }

    @Override
    public List<DownloadablePackage> listRemotePackages() {
        return this.listRemotePackages(null, null);
    }

    @Override
    public List<DownloadablePackage> listRemotePackages(PackageType pkgType) {
        return this.listRemotePackages(pkgType, null);
    }

    @Override
    public List<DownloadablePackage> listRemotePackages(PackageType pkgType, String targetPlatform) {
        return this.doMergePackages(this.remoteSources, pkgType, targetPlatform);
    }

    @Override
    public List<DownloadablePackage> listLocalPackages() {
        return this.listLocalPackages(null);
    }

    @Override
    public List<DownloadablePackage> listLocalPackages(PackageType type) {
        ArrayList<DownloadablePackage> result = new ArrayList<DownloadablePackage>();
        ArrayList<String> pkgIds = new ArrayList<String>();
        for (PackageSource source : this.localSources) {
            List<DownloadablePackage> pkgs = source.listPackages(type);
            for (DownloadablePackage pkg : pkgs) {
                if (pkgIds.contains(pkg.getId())) continue;
                pkgIds.add(pkg.getId());
                result.add(pkg);
            }
        }
        Collections.sort(result, new PackageComparator());
        return result;
    }

    @Override
    public List<DownloadablePackage> listUpdatePackages() {
        return this.listUpdatePackages(null, null);
    }

    @Override
    public List<DownloadablePackage> listUpdatePackages(PackageType type) {
        return this.listUpdatePackages(type, null);
    }

    @Override
    public List<DownloadablePackage> listUpdatePackages(String targetPlatform) {
        return this.listUpdatePackages(null, targetPlatform);
    }

    @Override
    public List<DownloadablePackage> listUpdatePackages(PackageType type, String targetPlatform) {
        List<String> installedPackagesNames = this.listInstalledPackagesNames(type);
        List<String> hotfixesNames = null;
        if (type == null || type == PackageType.HOT_FIX) {
            hotfixesNames = this.listHotfixesNames(targetPlatform, CUDFHelper.defaultAllowSNAPSHOT);
            hotfixesNames.removeAll(installedPackagesNames);
        }
        DependencyResolution resolution = this.resolveDependencies(hotfixesNames, null, installedPackagesNames, targetPlatform, CUDFHelper.defaultAllowSNAPSHOT);
        List<String> toUpdateIds = resolution.getOrderedPackageIdsToInstall();
        List<DownloadablePackage> toUpdate = toUpdateIds.stream().map(this::getPackage).collect(Collectors.toList());
        return toUpdate;
    }

    @Override
    public List<DownloadablePackage> listPrivatePackages(PackageType pkgType, String targetPlatform) {
        List<DownloadablePackage> allPackages = this.getAllPackages(this.getAllSources(), pkgType, targetPlatform);
        Collections.sort(allPackages, new PackageComparator());
        ArrayList<DownloadablePackage> allPrivatePackages = new ArrayList<DownloadablePackage>();
        for (DownloadablePackage downloadablePackage : allPackages) {
            if (downloadablePackage.getVisibility() != PackageVisibility.PRIVATE) continue;
            allPrivatePackages.add(downloadablePackage);
        }
        return allPrivatePackages;
    }

    @Override
    public List<DownloadablePackage> listPrivatePackages(String targetPlatform) {
        return this.listPrivatePackages(null, targetPlatform);
    }

    @Override
    public DownloadingPackage download(String packageId) throws ConnectServerError {
        ConnectRegistrationService crs = NuxeoConnectClient.getConnectRegistrationService();
        return crs.getConnector().getDownload(packageId);
    }

    @Override
    public List<DownloadingPackage> download(List<String> packageIds) throws ConnectServerError {
        ArrayList<DownloadingPackage> downloadings = new ArrayList<DownloadingPackage>();
        for (String packageId : packageIds) {
            DownloadingPackage download = this.download(packageId);
            if (download != null) {
                downloadings.add(download);
                continue;
            }
            log.error((Object)("Download failed for " + packageId));
        }
        return downloadings;
    }

    @Override
    public void install(String packageId, Map<String, String> params) throws PackageException {
        PackageUpdateService pus = NuxeoConnectClient.getPackageUpdateService();
        LocalPackage pkg = pus.getPackage(packageId);
        Task installationTask = pkg.getInstallTask();
        installationTask.validate();
        installationTask.run(params);
    }

    @Override
    public void install(List<String> packageIds, Map<String, String> params) throws PackageException {
        for (String packageId : packageIds) {
            this.install(packageId, params);
        }
    }

    @Deprecated
    protected void invalidateCache() {
        this.cachedPackageList = null;
    }

    @Deprecated
    protected Map<String, DownloadablePackage> getCachedPackageList() {
        if (this.cachedPackageList == null) {
            this.cachedPackageList = new HashMap<String, DownloadablePackage>();
        }
        for (DownloadablePackage pkg : this.listPackages()) {
            this.cachedPackageList.put(pkg.getId(), pkg);
        }
        return this.cachedPackageList;
    }

    protected DownloadablePackage getPkgInList(List<DownloadablePackage> pkgs, String pkgId) {
        for (DownloadablePackage pkg : pkgs) {
            if (!pkgId.equals(pkg.getId())) continue;
            return pkg;
        }
        return null;
    }

    @Override
    public DownloadablePackage getLocalPackage(String pkgId) {
        List<DownloadablePackage> pkgs = this.listLocalPackages();
        return this.getPkgInList(pkgs, pkgId);
    }

    @Override
    public DownloadablePackage getRemotePackage(String pkgId) {
        List<DownloadablePackage> pkgs = this.listRemotePackages();
        return this.getPkgInList(pkgs, pkgId);
    }

    @Override
    public DownloadablePackage getPackage(String pkgId) {
        List<DownloadablePackage> pkgs = this.listAllPackages();
        DownloadablePackage pkg = this.getPkgInList(pkgs, pkgId);
        if (pkg == null) {
            List<DownloadablePackage> studioPkgs = this.listAllStudioRemotePackages();
            pkg = this.getPkgInList(studioPkgs, pkgId);
        }
        return pkg;
    }

    @Override
    @Deprecated
    public List<DownloadablePackage> listRemoteOrLocalPackages() {
        return this.listRemoteOrLocalPackages(null, null);
    }

    @Override
    @Deprecated
    public List<DownloadablePackage> listRemoteOrLocalPackages(PackageType pkgType) {
        return this.listRemoteOrLocalPackages(pkgType, null);
    }

    @Override
    public List<DownloadablePackage> listRemoteOrLocalPackages(String targetPlatform) {
        return this.listRemoteOrLocalPackages(null, targetPlatform);
    }

    @Override
    public List<DownloadablePackage> listRemoteOrLocalPackages(PackageType pkgType, String targetPlatform) {
        ArrayList<DownloadablePackage> result = new ArrayList<DownloadablePackage>();
        List<DownloadablePackage> all = this.listPackages(pkgType, targetPlatform);
        List<DownloadablePackage> remotes = this.listRemotePackages(pkgType, targetPlatform);
        block0: for (DownloadablePackage pkg : all) {
            for (DownloadablePackage remote : remotes) {
                if (!remote.getId().equals(pkg.getId())) continue;
                result.add(pkg);
                continue block0;
            }
        }
        return result;
    }

    @Override
    public List<DownloadablePackage> listAllStudioRemoteOrLocalPackages() {
        List<DownloadablePackage> remote = this.listRemoteAssociatedStudioPackages();
        List<DownloadablePackage> local = this.listLocalPackages(PackageType.STUDIO);
        ArrayList<DownloadablePackage> result = new ArrayList<DownloadablePackage>();
        result.addAll(local);
        block0: for (DownloadablePackage rpkg : remote) {
            for (DownloadablePackage lpkg : local) {
                if (!lpkg.getId().equals(rpkg.getId())) continue;
                continue block0;
            }
            result.add(rpkg);
        }
        Collections.sort(result, new PackageComparator());
        return result;
    }

    @Override
    @Deprecated
    public List<DownloadablePackage> listOnlyRemotePackages() {
        return this.listOnlyRemotePackages(null, null);
    }

    @Override
    @Deprecated
    public List<DownloadablePackage> listOnlyRemotePackages(PackageType pkgType) {
        return this.listOnlyRemotePackages(pkgType, null);
    }

    @Override
    public List<DownloadablePackage> listOnlyRemotePackages(String targetPlatform) {
        return this.listOnlyRemotePackages(null, targetPlatform);
    }

    @Override
    public List<DownloadablePackage> listOnlyRemotePackages(PackageType pkgType, String targetPlatform) {
        List<DownloadablePackage> result = this.listRemotePackages(pkgType, targetPlatform);
        List<DownloadablePackage> local = this.listLocalPackages(pkgType);
        block0: for (DownloadablePackage pkg : local) {
            for (DownloadablePackage remote : result) {
                if (!remote.getName().equals(pkg.getName())) continue;
                result.remove(remote);
                continue block0;
            }
        }
        return result;
    }

    @Override
    public List<DownloadablePackage> listAllStudioRemotePackages() {
        return this.listRemotePackages(PackageType.STUDIO);
    }

    @Override
    public List<DownloadablePackage> listRemoteAssociatedStudioPackages() {
        ArrayList<DownloadablePackage> result = new ArrayList<DownloadablePackage>();
        ArrayList<String> pkgIds = new ArrayList<String>();
        for (PackageSource source : this.remoteSources) {
            List<DownloadablePackage> pkgs = source.listStudioPackages();
            for (DownloadablePackage pkg : pkgs) {
                if (pkgIds.contains(pkg.getId())) continue;
                pkgIds.add(pkg.getId());
                result.add(pkg);
            }
        }
        return result;
    }

    @Override
    public void flushCache() {
        for (PackageSource source : this.getAllSources()) {
            source.flushCache();
        }
    }

    @Override
    @Deprecated
    public DependencyResolution resolveDependencies(String pkgId, String targetPlatform) {
        try {
            DependencyResolution resolution = this.resolver.resolve(pkgId, targetPlatform);
            log.debug((Object)this.beforeAfterResolutionToString(resolution));
            return resolution;
        }
        catch (DependencyException e) {
            return new DependencyResolution(e);
        }
    }

    public String beforeAfterResolutionToString(DependencyResolution resolution) {
        StringBuilder sb = new StringBuilder();
        sb.append("\nBefore: " + this.listInstalledPackages());
        ArrayList<String> after = new ArrayList<String>();
        after.addAll(resolution.getUnchangedPackageIds());
        after.addAll(resolution.getInstallPackageIds());
        Collections.sort(after);
        sb.append("\nAfter:  " + after);
        return sb.toString();
    }

    @Override
    public DependencyResolution resolveDependencies(List<String> pkgInstall, List<String> pkgRemove, List<String> pkgUpgrade, String targetPlatform) {
        return this.resolveDependencies(pkgInstall, pkgRemove, pkgUpgrade, targetPlatform, CUDFHelper.defaultAllowSNAPSHOT, true);
    }

    @Override
    public DependencyResolution resolveDependencies(List<String> pkgInstall, List<String> pkgRemove, List<String> pkgUpgrade, String targetPlatform, boolean allowSNAPSHOT) {
        return this.resolveDependencies(pkgInstall, pkgRemove, pkgUpgrade, targetPlatform, allowSNAPSHOT, true);
    }

    @Override
    public DependencyResolution resolveDependencies(List<String> pkgInstall, List<String> pkgRemove, List<String> pkgUpgrade, String targetPlatform, boolean allowSNAPSHOT, boolean doKeep) {
        return this.resolveDependencies(pkgInstall, pkgRemove, pkgUpgrade, targetPlatform, allowSNAPSHOT, doKeep, false);
    }

    @Override
    public DependencyResolution resolveDependencies(List<String> pkgInstall, List<String> pkgRemove, List<String> pkgUpgrade, String targetPlatform, boolean allowSNAPSHOT, boolean doKeep, boolean isSubResolution) {
        try {
            DependencyResolution resolution = this.resolver.resolve(pkgInstall, pkgRemove, pkgUpgrade, targetPlatform, allowSNAPSHOT, doKeep, isSubResolution);
            log.debug((Object)this.beforeAfterResolutionToString(resolution));
            return resolution;
        }
        catch (DependencyException e) {
            return new DependencyResolution(e);
        }
    }

    @Override
    public List<DownloadablePackage> getUninstallDependencies(Package pkg, String targetPlatform) {
        ArrayList<DownloadablePackage> packagesToUninstall = new ArrayList<DownloadablePackage>();
        ArrayList<String> removes = new ArrayList<String>();
        removes.add(pkg.getName());
        DependencyResolution resolution = this.resolveDependencies(null, removes, null, targetPlatform);
        if (!resolution.isFailed() && !resolution.isEmpty()) {
            List<String> idsToRemove = resolution.getOrderedPackageIdsToRemove();
            idsToRemove.remove(pkg.getId());
            for (String pkgIdToRemove : idsToRemove) {
                DownloadablePackage localPackage = this.findPackageById(pkgIdToRemove, this.localSources);
                if (localPackage != null) {
                    packagesToUninstall.add(localPackage);
                    continue;
                }
                log.error((Object)("Missing local package to remove: " + pkgIdToRemove));
            }
        }
        return packagesToUninstall;
    }

    @Override
    @Deprecated
    public List<DownloadablePackage> getUninstallDependencies(Package pkg) {
        ArrayList<String> pkgNamesToRemove = new ArrayList<String>();
        List<DownloadablePackage> installedPackages = this.listInstalledPackages();
        int nbImpactedPackages = 0;
        pkgNamesToRemove.add(pkg.getName());
        while (pkgNamesToRemove.size() > nbImpactedPackages) {
            nbImpactedPackages = pkgNamesToRemove.size();
            block1: for (DownloadablePackage p : installedPackages) {
                if (pkgNamesToRemove.contains(p.getName())) continue;
                for (PackageDependency dep : p.getDependencies()) {
                    if (!pkgNamesToRemove.contains(dep.getName())) continue;
                    pkgNamesToRemove.add(p.getName());
                    continue block1;
                }
            }
        }
        pkgNamesToRemove.remove(pkg.getName());
        ArrayList<DownloadablePackage> packagesToUninstall = new ArrayList<DownloadablePackage>();
        for (String pkgName : pkgNamesToRemove) {
            for (Version v : this.findLocalPackageInstalledVersions(pkgName)) {
                DownloadablePackage p = this.getLocalPackage(pkgName + "-" + v.toString());
                packagesToUninstall.add(p);
            }
        }
        return packagesToUninstall;
    }

    @Override
    public List<DownloadablePackage> listAllPackages() {
        return this.getAllPackages(this.getAllSources(), null);
    }

    @Override
    public boolean isInstalled(Package pkg) {
        return this.isInstalled(pkg.getId());
    }

    @Override
    public boolean isInstalled(String pkgId) {
        DownloadablePackage pkg = this.getLocalPackage(pkgId);
        return pkg != null && pkg.getPackageState().isInstalled();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void order(DependencyResolution res) throws DependencyException {
        Map<String, DownloadablePackage> allPackagesByID = this.getAllPackagesByID();
        DependencyResolution dependencyResolution = res;
        synchronized (dependencyResolution) {
            if (!res.isSorted()) {
                res.sort(this);
            }
            List<String> installOrder = res.getOrderedPackageIdsToInstall();
            List<String> removeOrder = res.getOrderedPackageIdsToRemove();
            this.orderByDependencies(allPackagesByID, installOrder, removeOrder, false);
            this.orderByDependencies(allPackagesByID, removeOrder, removeOrder, true);
            Collections.reverse(removeOrder);
        }
    }

    private void orderByDependencies(Map<String, DownloadablePackage> allPackagesByID, List<String> listToOrder, List<String> orderedRemoveList, boolean isRemoveList) throws DependencyException {
        DownloadablePackage pkg;
        Map<String, DownloadablePackage> orderedMap = Collections.synchronizedMap(new LinkedHashMap());
        boolean hasChanged = true;
        HashSet<String> missingDeps = new HashSet<String>();
        HashMap<String, Set> optionalMissingDeps = new HashMap<String, Set>();
        while (!listToOrder.isEmpty() && hasChanged) {
            hasChanged = false;
            for (String string : listToOrder) {
                pkg = allPackagesByID.get(string);
                if (pkg.getDependencies().length == 0 && pkg.getOptionalDependencies().length == 0) {
                    orderedMap.put(string, pkg);
                    hasChanged = true;
                    continue;
                }
                boolean allSatisfied = true;
                ArrayList<PackageDependency> allDependencies = new ArrayList<PackageDependency>();
                CollectionUtils.addAll(allDependencies, (Object[])pkg.getDependencies());
                List<PackageDependency> optionalDependencies = Arrays.asList(pkg.getOptionalDependencies());
                allDependencies.addAll(optionalDependencies);
                for (PackageDependency pkgDep : allDependencies) {
                    boolean isOptionalPkgDep = optionalDependencies.contains(pkgDep);
                    boolean satisfied = false;
                    for (Package orderedPkg : orderedMap.values()) {
                        if (!this.matchDependency(pkgDep, orderedPkg)) continue;
                        satisfied = true;
                        if (isOptionalPkgDep) {
                            if (optionalMissingDeps.get(string) == null) break;
                            ((Set)optionalMissingDeps.get(string)).remove(pkgDep.toString());
                            break;
                        }
                        missingDeps.remove(pkgDep.toString());
                        break;
                    }
                    if (!satisfied && !this.hasMatchInIdList(pkgDep, listToOrder)) {
                        for (Version version : this.findLocalPackageInstalledVersions(pkgDep.getName())) {
                            if (!isRemoveList && this.hasMatchInIdList(pkgDep.getName(), version, orderedRemoveList) || !pkgDep.getVersionRange().matchVersion(version)) continue;
                            satisfied = true;
                            if (isOptionalPkgDep) {
                                if (optionalMissingDeps.get(string) == null) break;
                                ((Set)optionalMissingDeps.get(string)).remove(pkgDep.toString());
                                break;
                            }
                            missingDeps.remove(pkgDep.toString());
                            break;
                        }
                        if (!satisfied && isOptionalPkgDep) {
                            satisfied = true;
                            if (!this.hasMatchInIdList(pkgDep, orderedRemoveList)) {
                                optionalMissingDeps.computeIfAbsent(string, k -> new HashSet()).add(pkgDep.toString());
                            }
                        }
                    }
                    if (satisfied) continue;
                    allSatisfied = false;
                    if (isOptionalPkgDep) {
                        optionalMissingDeps.computeIfAbsent(string, k -> new HashSet()).add(pkgDep.toString());
                        break;
                    }
                    missingDeps.add(pkgDep.toString());
                    break;
                }
                if (!allSatisfied) continue;
                orderedMap.put(string, pkg);
                orderedRemoveList.remove(pkg.getName());
                hasChanged = true;
            }
            listToOrder.removeAll(orderedMap.keySet());
        }
        if (!optionalMissingDeps.isEmpty() && !isRemoveList) {
            for (Map.Entry entry : optionalMissingDeps.entrySet()) {
                if (entry.getValue() == null || ((Set)entry.getValue()).isEmpty()) continue;
                log.info((Object)String.format("Optional dependencies %s will be ignored for '%s'.", entry.getValue(), entry.getKey()));
            }
        }
        if (!listToOrder.isEmpty()) {
            if (missingDeps.isEmpty()) {
                for (String string : listToOrder) {
                    pkg = allPackagesByID.get(string);
                    orderedMap.put(string, pkg);
                }
                listToOrder.clear();
            } else {
                throw new DependencyException(String.format("Couldn't order %s missing %s.", listToOrder, missingDeps));
            }
        }
        listToOrder.addAll(orderedMap.keySet());
    }

    private boolean hasMatchInIdList(String pkgName, Version pkgVersion, List<String> pkgIdList) {
        String pkgId = pkgName + "-" + pkgVersion;
        return pkgIdList.contains(pkgId);
    }

    private boolean hasMatchInIdList(PackageDependency pkgDep, List<String> pkgIdList) {
        for (String pkgId : pkgIdList) {
            DownloadablePackage pkg = this.getPackage(pkgId);
            if (!this.matchDependency(pkgDep, pkg)) continue;
            return true;
        }
        return false;
    }

    private boolean matchDependency(PackageDependency pkgDep, Package pkg) {
        boolean match;
        boolean bl = match = pkgDep.getName().equals(pkg.getName()) && pkgDep.getVersionRange().matchVersion(pkg.getVersion());
        if (!match && pkg.getProvides() != null) {
            for (PackageDependency provide : pkg.getProvides()) {
                if (!pkgDep.getName().equals(provide.getName()) || !pkgDep.getVersionRange().matchVersionRange(provide.getVersionRange())) continue;
                match = true;
                break;
            }
        }
        return match;
    }

    @Override
    public void cancelDownload(String pkgId) {
        ConnectDownloadManager cdm = NuxeoConnectClient.getDownloadManager();
        cdm.removeDownloadingPackage(pkgId);
    }

    @Override
    public List<? extends Package> sort(List<? extends Package> pkgs) {
        Collections.sort(pkgs, new PackageComparator());
        return pkgs;
    }

    @Override
    public String getNonCompliant(List<String> packages, String targetPlatform) throws PackageException {
        for (String pkg : packages) {
            if (this.matchesPlatform(pkg, targetPlatform)) continue;
            return pkg;
        }
        return null;
    }

    @Override
    public List<String> getNonCompliantList(List<String> packages, String targetPlatform) throws PackageException {
        ArrayList<String> nonCompliant = new ArrayList<String>();
        for (String pkg : packages) {
            if (this.matchesPlatform(pkg, targetPlatform)) continue;
            nonCompliant.add(pkg);
        }
        return nonCompliant;
    }

    @Override
    public boolean matchesPlatform(String requestPkgStr, String targetPlatform) throws PackageException {
        Map<String, DownloadablePackage> allPackagesByID = this.getAllPackagesByID();
        if (allPackagesByID.containsKey(requestPkgStr)) {
            return TargetPlatformFilterHelper.isCompatibleWithTargetPlatform(allPackagesByID.get(requestPkgStr), targetPlatform);
        }
        List<DownloadablePackage> allPackagesForName = this.getAllPackagesByName().get(requestPkgStr);
        if (allPackagesForName == null) {
            throw new PackageException("Package not found: " + requestPkgStr);
        }
        for (DownloadablePackage pkg : allPackagesForName) {
            if (!requestPkgStr.equals(pkg.getName()) || !TargetPlatformFilterHelper.isCompatibleWithTargetPlatform(pkg, targetPlatform)) continue;
            return true;
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void checkOptionalDependenciesOnInstalledPackages(DependencyResolution res) {
        List<DownloadablePackage> installedPackages = this.listInstalledPackages();
        DependencyResolution dependencyResolution = res;
        synchronized (dependencyResolution) {
            HashSet<DownloadablePackage> packagesToReinstall = new HashSet<DownloadablePackage>();
            for (DownloadablePackage installedPkg : installedPackages) {
                PackageDependency[] optionalDependencies;
                if (res.getOrderedPackageIdsToRemove().contains(installedPkg.getId())) continue;
                block4: for (PackageDependency pkgOptDep : optionalDependencies = installedPkg.getOptionalDependencies()) {
                    List<Version> installedVersions = this.findLocalPackageInstalledVersions(pkgOptDep.getName());
                    boolean hasAnInstalledMatch = false;
                    for (Version version : installedVersions) {
                        if (!pkgOptDep.getVersionRange().matchVersion(version)) continue;
                        hasAnInstalledMatch = true;
                        break;
                    }
                    if (!hasAnInstalledMatch) {
                        for (String pkgId : res.getOrderedPackageIdsToInstall()) {
                            DownloadablePackage pkgToInstall = this.getPackage(pkgId);
                            if (!this.matchDependency(pkgOptDep, pkgToInstall)) continue;
                            res.addReinstallForNewlyInstalledOptional(installedPkg.getId(), pkgToInstall.getId());
                            packagesToReinstall.add(installedPkg);
                            continue block4;
                        }
                        continue;
                    }
                    boolean hasAnUpgradingMatch = this.hasMatchInIdList(pkgOptDep, res.getOrderedPackageIdsToInstall());
                    if (hasAnUpgradingMatch) continue;
                    for (String pkgId : res.getOrderedPackageIdsToRemove()) {
                        DownloadablePackage pkgToRemove = this.getPackage(pkgId);
                        if (!this.matchDependency(pkgOptDep, pkgToRemove)) continue;
                        res.addReinstallForNewlyRemovedOptional(installedPkg.getId(), pkgToRemove.getId());
                        packagesToReinstall.add(installedPkg);
                        continue block4;
                    }
                }
            }
            for (DownloadablePackage pkg : packagesToReinstall) {
                res.getOrderedPackageIdsToInstall().add(pkg.getId());
                res.markPackageForRemoval(pkg.getName(), pkg.getVersion());
            }
        }
    }
}

