/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.connect.registration;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import org.apache.commons.httpclient.Credentials;
import org.apache.commons.httpclient.HttpClient;
import org.apache.commons.httpclient.HttpMethod;
import org.apache.commons.httpclient.NameValuePair;
import org.apache.commons.httpclient.UsernamePasswordCredentials;
import org.apache.commons.httpclient.auth.AuthScope;
import org.apache.commons.httpclient.methods.GetMethod;
import org.apache.commons.httpclient.methods.PostMethod;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;
import org.nuxeo.connect.connector.NuxeoClientInstanceType;
import org.nuxeo.connect.connector.http.ConnectUrlConfig;
import org.nuxeo.connect.connector.http.ProxyHelper;
import org.nuxeo.connect.data.AbstractJSONSerializableData;
import org.nuxeo.connect.data.ConnectProject;
import org.nuxeo.connect.identity.TechnicalInstanceIdentifier;
import org.nuxeo.connect.registration.response.TrialErrorResponse;
import org.nuxeo.connect.registration.response.TrialRegistrationResponse;

public class RegistrationHelper {
    public static final String GET_PROJECTS_SUFFIX = "getAvailableProjectsForRegistration";
    public static final String POST_REGISTER_SUFFIX = "remoteRegisterInstance";
    protected static final Log log = LogFactory.getLog(RegistrationHelper.class);
    protected static List<String> ALLOWED_TRIAL_FIELDS = Arrays.asList("termsAndConditions", "company", "password", "password_verif", "email", "login", "connectreg:projectName", "description");

    protected static String getBaseUrl() {
        return ConnectUrlConfig.getRegistrationBaseUrl();
    }

    protected static void configureHttpClient(HttpClient httpClient, String url, String login, String password) {
        httpClient.getHttpConnectionManager().getParams().setConnectionTimeout(10000);
        if (login != null) {
            httpClient.getParams().setAuthenticationPreemptive(true);
            UsernamePasswordCredentials ba = new UsernamePasswordCredentials(login, password);
            httpClient.getState().setCredentials(new AuthScope(null, -1, AuthScope.ANY_REALM), (Credentials)ba);
        }
        ProxyHelper.configureProxyIfNeeded(httpClient, url);
    }

    protected static HttpClient newHttpClient(String url, String login, String password) {
        HttpClient httpClient = new HttpClient();
        RegistrationHelper.configureHttpClient(httpClient, url, login, password);
        return httpClient;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static List<ConnectProject> getAvailableProjectsForRegistration(String login, String password) {
        String url = RegistrationHelper.getBaseUrl() + GET_PROJECTS_SUFFIX;
        HttpClient httpClient = RegistrationHelper.newHttpClient(url, login, password);
        GetMethod method = new GetMethod(url);
        ArrayList<ConnectProject> result = new ArrayList<ConnectProject>();
        try {
            int rc = httpClient.executeMethod((HttpMethod)method);
            if (rc == 200) {
                String json = method.getResponseBodyAsString();
                JSONArray array = new JSONArray(json);
                for (int i = 0; i < array.length(); ++i) {
                    JSONObject ob = (JSONObject)array.get(i);
                    result.add(AbstractJSONSerializableData.loadFromJSON(ConnectProject.class, ob));
                }
            }
        }
        catch (IOException | JSONException e) {
            log.debug((Object)e, e);
        }
        finally {
            method.releaseConnection();
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String remoteRegisterInstance(String login, String password, String prjId, NuxeoClientInstanceType type, String description) {
        String url = RegistrationHelper.getBaseUrl() + POST_REGISTER_SUFFIX;
        HttpClient httpClient = RegistrationHelper.newHttpClient(url, login, password);
        PostMethod method = new PostMethod(url);
        NameValuePair project = new NameValuePair("projectId", prjId);
        NameValuePair desc = new NameValuePair("description", description);
        NameValuePair strType = new NameValuePair("type", type.getValue());
        NameValuePair ctid = new NameValuePair("CTID", TechnicalInstanceIdentifier.instance().getCTID());
        method.setRequestBody(new NameValuePair[]{project, desc, strType, ctid});
        try {
            int rc = httpClient.executeMethod((HttpMethod)method);
            if (rc == 200) {
                String string = method.getResponseBodyAsString();
                return string;
            }
        }
        catch (IOException e) {
            log.debug((Object)e, (Throwable)e);
        }
        finally {
            method.releaseConnection();
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static TrialRegistrationResponse remoteTrialInstanceRegistration(Map<String, String> parameters) {
        String url = ConnectUrlConfig.getTrialRegistrationBaseUrl() + "submit?embedded=true";
        PostMethod method = new PostMethod(url);
        ArrayList<NameValuePair> nvp = new ArrayList<NameValuePair>();
        for (Map.Entry<String, String> entry : parameters.entrySet()) {
            if (!ALLOWED_TRIAL_FIELDS.contains(entry.getKey())) {
                log.debug((Object)("Skipped field: " + entry.getKey() + " (" + entry.getValue() + ")"));
                continue;
            }
            nvp.add(new NameValuePair(entry.getKey(), entry.getValue()));
        }
        method.setRequestBody(nvp.toArray(new NameValuePair[nvp.size()]));
        HttpClient httpClient = RegistrationHelper.newHttpClient(url, null, null);
        try {
            int rc = httpClient.executeMethod((HttpMethod)method);
            log.debug((Object)("Registration response code: " + rc));
            String body = method.getResponseBodyAsString();
            if (rc == 200) {
                TrialRegistrationResponse trialRegistrationResponse = TrialRegistrationResponse.read(body);
                return trialRegistrationResponse;
            }
            if (rc == 400) {
                TrialRegistrationResponse trialRegistrationResponse = TrialRegistrationResponse.read(body);
                return trialRegistrationResponse;
            }
            log.error((Object)("Unhandled response code: " + rc));
        }
        catch (IOException e) {
            log.debug((Object)e, (Throwable)e);
        }
        finally {
            method.releaseConnection();
        }
        return TrialErrorResponse.UNKNOWN();
    }
}

