/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.automation.core.impl;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;

public abstract class SuperKeyedRegistry<K, V> {
    private static final Object NULL = new Object();
    protected Map<K, V> registry;
    protected volatile ConcurrentMap<K, Object> lookup;
    private final Object lock = new Object();

    public SuperKeyedRegistry() {
        this.registry = new HashMap();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void put(K key, V value) {
        Object object = this.lock;
        synchronized (object) {
            this.registry.put(key, value);
            this.lookup = null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public V remove(K key) {
        V value;
        Object object = this.lock;
        synchronized (object) {
            value = this.registry.remove(key);
            this.lookup = null;
        }
        return value;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void flushCache() {
        Object object = this.lock;
        synchronized (object) {
            this.lookup = null;
        }
    }

    protected abstract boolean isRoot(K var1);

    protected abstract List<K> getSuperKeys(K var1);

    protected boolean isCachingEnabled(K key) {
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public V get(K key) {
        Object v;
        ConcurrentMap<K, Object> _lookup = this.lookup;
        if (_lookup == null) {
            Object object = this.lock;
            synchronized (object) {
                this.lookup = new ConcurrentHashMap<K, Object>(this.registry);
                _lookup = this.lookup;
            }
        }
        if ((v = _lookup.get(key)) == null && !this.isRoot(key)) {
            for (K sk : this.getSuperKeys(key)) {
                v = this.get(sk);
                if (v != null && v != NULL) {
                    if (!this.isCachingEnabled(sk)) continue;
                    _lookup.put(key, v);
                    return v;
                }
                if (!this.isCachingEnabled(sk)) continue;
                if (v != null) {
                    _lookup.put(key, v);
                    continue;
                }
                _lookup.put(key, NULL);
            }
        }
        return v == NULL ? null : (V)v;
    }
}

