/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.automation.core.impl.adapters.helper;

import org.nuxeo.ecm.automation.OperationContext;
import org.nuxeo.ecm.automation.TypeAdaptException;
import org.nuxeo.ecm.automation.core.scripting.Expression;
import org.nuxeo.ecm.automation.core.scripting.Scripting;
import org.nuxeo.ecm.core.api.DocumentModel;
import org.nuxeo.ecm.core.api.DocumentRef;
import org.nuxeo.ecm.core.api.IdRef;
import org.nuxeo.ecm.core.api.PathRef;

public class TypeAdapterHelper {
    public static DocumentRef createDocumentRef(String value) {
        return value.startsWith("/") ? new PathRef(value) : new IdRef(value);
    }

    public static Object createDocumentRefOrExpression(String value) {
        if (value.startsWith(".")) {
            return Scripting.newExpression("Document.resolvePathAsRef(\"" + value + "\")");
        }
        return value.startsWith("/") ? new PathRef(value) : new IdRef(value);
    }

    public static DocumentRef createDocumentRef(OperationContext ctx, String value) throws TypeAdaptException {
        Object obj = TypeAdapterHelper.createDocumentRefOrExpression(value);
        if (obj instanceof DocumentRef) {
            return (DocumentRef)obj;
        }
        if (obj instanceof Expression) {
            if (ctx != null) {
                obj = ((Expression)obj).eval(ctx);
            }
            if (obj instanceof DocumentModel) {
                return ((DocumentModel)obj).getRef();
            }
            if (obj instanceof DocumentRef) {
                return (DocumentRef)obj;
            }
            throw new TypeAdaptException(String.format("Cannot adapt value '%s' to a DocumentRef instance", value));
        }
        throw new RuntimeException(String.format("Unhandled value: %s", value));
    }

    public static DocumentModel createDocumentModel(OperationContext ctx, String value) throws TypeAdaptException {
        DocumentRef docRef = TypeAdapterHelper.createDocumentRef(ctx, value);
        return TypeAdapterHelper.createDocumentModel(ctx, docRef);
    }

    public static DocumentModel createDocumentModel(OperationContext ctx, DocumentRef docRef) throws TypeAdaptException {
        return ctx.getCoreSession().getDocument(docRef);
    }
}

