/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.automation.core.trace;

import java.io.BufferedWriter;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.nio.charset.Charset;
import java.util.Arrays;
import java.util.Calendar;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuxeo.ecm.automation.core.trace.Call;
import org.nuxeo.ecm.automation.core.trace.Trace;

public class TracePrinter {
    private static final Log log = LogFactory.getLog(TracePrinter.class);
    private static final String LF = System.getProperty("line.separator");
    protected final BufferedWriter writer;

    public TracePrinter(Writer writer) {
        this.writer = new BufferedWriter(writer);
    }

    public TracePrinter(OutputStream out) {
        this(new OutputStreamWriter(out));
    }

    protected void printHeading(String heading) throws IOException {
        this.writer.append(LF + LF + "****** " + heading + " ******");
    }

    protected void printCalls(List<Call> calls) throws IOException {
        String tabs = "\t";
        for (Call call : calls) {
            this.writer.append(tabs);
            this.writer.append(call.getType().getType().getName());
            this.writer.append(LF);
            tabs = tabs + "\t";
        }
    }

    public void print(Trace trace) throws IOException {
        this.printHeading("chain");
        if (trace.error != null) {
            this.writer.append(LF);
            if (trace.getParent() != null) {
                this.writer.append("Parent Chain ID: ");
                this.writer.append(trace.getParent().getChainId());
                this.writer.append(LF);
            }
            this.writer.append("Name: ");
            this.writer.append(trace.getChain().getId());
            if (trace.getChain().getAliases() != null && trace.getChain().getAliases().length > 0) {
                this.writer.append(LF);
                this.writer.append("Aliases: ");
                this.writer.append(Arrays.toString(trace.getChain().getAliases()));
            }
            this.writer.append(LF);
            this.writer.append("Exception: ");
            this.writer.append(trace.error.getClass().getSimpleName());
            this.writer.append(LF);
            this.writer.append("Caught error: ");
            this.writer.append(trace.error.getMessage());
            this.writer.append(LF);
            this.writer.append("Caused by: ");
            this.writer.append(trace.error.toString());
        } else {
            this.writer.append(LF);
            if (trace.getParent() != null) {
                this.writer.append("Parent Chain ID: ");
                this.writer.append(trace.getParent().getChainId());
                this.writer.append(LF);
            }
            this.writer.append("Name: ");
            this.writer.append(trace.getChain().getId());
            this.writer.append(LF);
            this.writer.append("Produced output type: ");
            this.writer.append(trace.output == null ? "Void" : trace.output.getClass().getSimpleName());
        }
        this.writer.append(LF);
        this.writer.append("****** Hierarchy calls ******");
        this.writer.append(LF);
        this.printCalls(trace.calls);
        this.print(trace.calls);
        this.writer.flush();
    }

    public void print(List<Call> calls) throws IOException {
        for (Call call : calls) {
            this.print(call);
        }
    }

    public void print(Call call) throws IOException {
        this.printCall(call);
    }

    public void printCall(Call call) {
        try {
            this.writer.append(LF);
            this.writer.append(LF);
            this.writer.append("****** " + call.getType().getId() + " ******");
            this.writer.append(LF);
            this.writer.append("Chain ID: ");
            this.writer.append(call.getChainId());
            if (call.getAliases() != null) {
                this.writer.append(LF);
                this.writer.append("Chain Aliases: ");
                this.writer.append(call.getAliases());
            }
            this.writer.append(LF);
            this.writer.append("Class: ");
            this.writer.append(call.getType().getType().getSimpleName());
            this.writer.append(LF);
            this.writer.append("Method: '");
            this.writer.append(call.getMethod().getMethod().getName());
            this.writer.append("' | Input Type: ");
            this.writer.append(call.getMethod().getConsume().getName());
            this.writer.append(" | Output Type: ");
            this.writer.append(call.getMethod().getProduce().getName());
            this.writer.append(LF);
            this.writer.append("Input: ");
            this.writer.append(call.getInput() == null ? "null" : call.getInput().toString());
            if (!call.getParameters().isEmpty()) {
                this.writer.append(LF);
                this.writer.append("Parameters ");
                for (String parameter : call.getParameters().keySet()) {
                    this.writer.append(" | ");
                    this.writer.append("Name: ");
                    this.writer.append(parameter);
                    this.writer.append(", Value: ");
                    Object value = call.getParameters().get(parameter);
                    if (value instanceof Call.ExpressionParameter) {
                        value = String.format("Expr:(id=%s | value=%s)", ((Call.ExpressionParameter)call.getParameters().get(parameter)).getParameterId(), ((Call.ExpressionParameter)call.getParameters().get(parameter)).getParameterValue());
                    }
                    this.writer.append(value.toString());
                }
            }
            if (!call.getVariables().isEmpty()) {
                this.writer.append(LF);
                this.writer.append("Context Variables");
                for (String keyVariable : call.getVariables().keySet()) {
                    this.writer.append(" | ");
                    this.writer.append("Key: ");
                    this.writer.append(keyVariable);
                    this.writer.append(", Value: ");
                    Object variable = call.getVariables().get(keyVariable);
                    if (variable instanceof Calendar) {
                        this.writer.append(((Calendar)variable).getTime().toString());
                        continue;
                    }
                    this.writer.append(variable == null ? "null" : variable.toString());
                }
            }
            if (!call.getNested().isEmpty()) {
                this.writer.append(LF);
                this.printHeading("start sub chain");
                for (Trace trace : call.getNested()) {
                    this.print(trace);
                }
                this.writer.append(LF);
                this.printHeading("end sub chain");
            }
        }
        catch (IOException e) {
            log.error((Object)"Nuxeo TracePrinter cannot write traces output", (Throwable)e);
        }
    }

    public void litePrint(Trace trace) throws IOException {
        this.printHeading("chain");
        this.writer.append(LF);
        if (trace.getParent() != null) {
            this.writer.append("Parent Chain ID: ");
            this.writer.append(trace.getParent().getChainId());
            this.writer.append(LF);
        }
        this.writer.append("Name: ");
        this.writer.append(trace.getChain().getId());
        if (trace.getChain().getAliases() != null && trace.getChain().getAliases().length > 0) {
            this.writer.append(LF);
            this.writer.append("Aliases: ");
            this.writer.append(Arrays.toString(trace.getChain().getAliases()));
        }
        if (trace.error != null) {
            this.writer.append(LF);
            this.writer.append("Exception: ");
            this.writer.append(trace.error.getClass().getSimpleName());
            this.writer.append(LF);
            this.writer.append("Caught error: ");
            this.writer.append(trace.error.getMessage());
            this.writer.append(LF);
            this.writer.append("Caused by: ");
            this.writer.append(trace.error.toString());
        }
        this.writer.append(LF);
        this.writer.append("****** Hierarchy calls ******");
        this.litePrintCall(trace.calls);
        this.writer.flush();
    }

    public void litePrintCall(List<Call> calls) throws IOException {
        this.writer.append(LF);
        try {
            this.printCalls(calls);
            for (Call call : calls) {
                if (call.getNested().isEmpty()) continue;
                this.writer.append(LF);
                this.printHeading("start sub chain");
                for (Trace trace : call.getNested()) {
                    this.litePrint(trace);
                }
                this.writer.append(LF);
                this.printHeading("end sub chain");
            }
        }
        catch (IOException e) {
            log.error((Object)"Nuxeo TracePrinter cannot write traces output", (Throwable)e);
        }
    }

    public static String print(Trace trace, boolean liteprint) {
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        TracePrinter printer = new TracePrinter(out);
        try {
            if (liteprint) {
                printer.litePrint(trace);
            } else {
                printer.print(trace);
            }
        }
        catch (IOException cause) {
            return "Cannot print automation trace of " + trace.chain.getId();
        }
        return new String(out.toByteArray(), Charset.forName("UTF-8"));
    }
}

