/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.core.convert.service;

import java.io.File;
import java.io.IOException;
import java.io.Serializable;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.io.FilenameUtils;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuxeo.common.utils.FileUtils;
import org.nuxeo.ecm.core.api.Blob;
import org.nuxeo.ecm.core.api.blobholder.BlobHolder;
import org.nuxeo.ecm.core.api.blobholder.SimpleBlobHolder;
import org.nuxeo.ecm.core.api.impl.blob.StringBlob;
import org.nuxeo.ecm.core.convert.api.ConversionException;
import org.nuxeo.ecm.core.convert.api.ConversionService;
import org.nuxeo.ecm.core.convert.api.ConversionStatus;
import org.nuxeo.ecm.core.convert.api.ConverterCheckResult;
import org.nuxeo.ecm.core.convert.api.ConverterNotAvailable;
import org.nuxeo.ecm.core.convert.api.ConverterNotRegistered;
import org.nuxeo.ecm.core.convert.cache.CacheKeyGenerator;
import org.nuxeo.ecm.core.convert.cache.ConversionCacheHolder;
import org.nuxeo.ecm.core.convert.cache.GCTask;
import org.nuxeo.ecm.core.convert.extension.ChainedConverter;
import org.nuxeo.ecm.core.convert.extension.Converter;
import org.nuxeo.ecm.core.convert.extension.ConverterDescriptor;
import org.nuxeo.ecm.core.convert.extension.ExternalConverter;
import org.nuxeo.ecm.core.convert.extension.GlobalConfigDescriptor;
import org.nuxeo.ecm.core.convert.service.ConversionWork;
import org.nuxeo.ecm.core.convert.service.MimeTypeTranslationHelper;
import org.nuxeo.ecm.core.io.download.DownloadService;
import org.nuxeo.ecm.core.transientstore.work.TransientStoreWork;
import org.nuxeo.ecm.core.work.api.Work;
import org.nuxeo.ecm.core.work.api.WorkManager;
import org.nuxeo.ecm.platform.mimetype.interfaces.MimetypeEntry;
import org.nuxeo.ecm.platform.mimetype.interfaces.MimetypeRegistry;
import org.nuxeo.runtime.RuntimeServiceEvent;
import org.nuxeo.runtime.RuntimeServiceListener;
import org.nuxeo.runtime.api.Framework;
import org.nuxeo.runtime.model.ComponentContext;
import org.nuxeo.runtime.model.ComponentInstance;
import org.nuxeo.runtime.model.DefaultComponent;
import org.nuxeo.runtime.services.event.Event;
import org.nuxeo.runtime.services.event.EventListener;
import org.nuxeo.runtime.services.event.EventService;

public class ConversionServiceImpl
extends DefaultComponent
implements ConversionService {
    protected static final Log log = LogFactory.getLog(ConversionServiceImpl.class);
    public static final String CONVERTER_EP = "converter";
    public static final String CONFIG_EP = "configuration";
    protected final Map<String, ConverterDescriptor> converterDescriptors = new HashMap<String, ConverterDescriptor>();
    protected final MimeTypeTranslationHelper translationHelper = new MimeTypeTranslationHelper();
    protected final GlobalConfigDescriptor config = new GlobalConfigDescriptor();
    protected static ConversionServiceImpl self;
    protected Thread gcThread;
    protected GCTask gcTask;
    ReloadListener reloadListener;
    protected final Map<String, ConverterCheckResult> checkResultCache = new HashMap<String, ConverterCheckResult>();

    public void activate(ComponentContext context) {
        this.converterDescriptors.clear();
        this.translationHelper.clear();
        self = this;
        this.config.clearCachingDirectory();
        Framework.addListener((RuntimeServiceListener)new RuntimeServiceListener(){

            public void handleEvent(RuntimeServiceEvent event) {
                if (2 != event.id) {
                    return;
                }
                Framework.removeListener((RuntimeServiceListener)this);
                ((EventService)Framework.getService(EventService.class)).removeListener("org.nuxeo.runtime.reload", (EventListener)ConversionServiceImpl.this.reloadListener);
                ConversionServiceImpl.this.endGC();
            }
        });
        this.reloadListener = new ReloadListener();
        ((EventService)Framework.getService(EventService.class)).addListener("org.nuxeo.runtime.reload", (EventListener)this.reloadListener);
    }

    public void deactivate(ComponentContext context) {
        if (this.config.isCacheEnabled()) {
            ConversionCacheHolder.deleteCache();
        }
        self = null;
        this.converterDescriptors.clear();
        this.translationHelper.clear();
    }

    public void registerContribution(Object contribution, String extensionPoint, ComponentInstance contributor) {
        if (CONVERTER_EP.equals(extensionPoint)) {
            ConverterDescriptor desc = (ConverterDescriptor)contribution;
            ConversionServiceImpl.registerConverter(desc);
        } else if (CONFIG_EP.equals(extensionPoint)) {
            GlobalConfigDescriptor desc = (GlobalConfigDescriptor)contribution;
            this.config.update(desc);
            this.config.clearCachingDirectory();
        } else {
            log.error((Object)("Unable to handle unknown extensionPoint " + extensionPoint));
        }
    }

    public void unregisterContribution(Object contribution, String extensionPoint, ComponentInstance contributor) {
    }

    public static Converter getConverter(String converterName) {
        ConverterDescriptor desc = ConversionServiceImpl.self.converterDescriptors.get(converterName);
        if (desc == null) {
            return null;
        }
        return desc.getConverterInstance();
    }

    public static ConverterDescriptor getConverterDescriptor(String converterName) {
        return ConversionServiceImpl.self.converterDescriptors.get(converterName);
    }

    public static long getGCIntervalInMinutes() {
        return ConversionServiceImpl.self.config.getGCInterval();
    }

    public static void setGCIntervalInMinutes(long interval) {
        ConversionServiceImpl.self.config.setGCInterval(interval);
    }

    public static void registerConverter(ConverterDescriptor desc) {
        if (ConversionServiceImpl.self.converterDescriptors.containsKey(desc.getConverterName())) {
            ConverterDescriptor existing = ConversionServiceImpl.self.converterDescriptors.get(desc.getConverterName());
            desc = existing.merge(desc);
        }
        desc.initConverter();
        ConversionServiceImpl.self.translationHelper.addConverter(desc);
        ConversionServiceImpl.self.converterDescriptors.put(desc.getConverterName(), desc);
    }

    public static int getMaxCacheSizeInKB() {
        return ConversionServiceImpl.self.config.getDiskCacheSize();
    }

    public static void setMaxCacheSizeInKB(int size) {
        ConversionServiceImpl.self.config.setDiskCacheSize(size);
    }

    public static boolean isCacheEnabled() {
        return ConversionServiceImpl.self.config.isCacheEnabled();
    }

    public static String getCacheBasePath() {
        return ConversionServiceImpl.self.config.getCachingDirectory();
    }

    public List<String> getRegistredConverters() {
        ArrayList<String> converterNames = new ArrayList<String>();
        converterNames.addAll(this.converterDescriptors.keySet());
        return converterNames;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Blob convertBlobToPDF(Blob blob) throws IOException {
        Blob result;
        String mimetype = blob.getMimeType();
        String filename = blob.getFilename();
        if ("application/pdf".equals(mimetype)) {
            return blob;
        }
        if ("text/plain".equals(mimetype)) {
            result = this.convertBlobToMimeType(blob, "application/pdf");
        } else {
            if (!"text/html".equals(mimetype)) {
                blob = this.convertBlobToMimeType(blob, "text/html");
                blob.setFilename(filename);
            }
            Path tempDirectory = Framework.createTempDirectory((String)"blobs", (FileAttribute[])new FileAttribute[0]);
            try {
                DownloadService downloadService = (DownloadService)Framework.getService(DownloadService.class);
                blob = ConversionServiceImpl.replaceURLsByAbsolutePaths(blob, tempDirectory, arg_0 -> ((DownloadService)downloadService).resolveBlobFromDownloadUrl(arg_0));
                result = this.convertBlobToMimeType(blob, "application/pdf");
            }
            finally {
                org.apache.commons.io.FileUtils.deleteQuietly((File)tempDirectory.toFile());
            }
        }
        if (result != null) {
            ConversionServiceImpl.adjustPDFBlobName(filename, result);
        }
        return result;
    }

    protected Blob convertBlobToMimeType(Blob blob, String destinationMimeType) {
        SimpleBlobHolder bh = new SimpleBlobHolder(blob);
        return (bh = this.convertToMimeType(destinationMimeType, (BlobHolder)bh, null)) == null ? null : bh.getBlob();
    }

    protected static void adjustPDFBlobName(String filename, Blob blob) {
        filename = StringUtils.isBlank((String)filename) ? "file_" + System.currentTimeMillis() : FilenameUtils.removeExtension((String)FilenameUtils.getName((String)filename));
        blob.setFilename(filename + ".pdf");
        blob.setMimeType("application/pdf");
    }

    protected static Blob replaceURLsByAbsolutePaths(Blob blob, Path tempDirectory, Function<String, Blob> blobResolver) throws IOException {
        String url;
        Blob imageBlob;
        String initialBlobContent = blob.getString();
        Pattern pattern = Pattern.compile("(src=([\"']))(.*?)(\\2)");
        Matcher matcher = pattern.matcher(initialBlobContent);
        StringBuffer sb = new StringBuffer();
        while (matcher.find() && (imageBlob = blobResolver.apply(url = matcher.group(3))) != null) {
            String safeFilename = FileUtils.getSafeFilename((String)imageBlob.getFilename());
            File imageFile = tempDirectory.resolve(safeFilename).toFile();
            imageBlob.transferTo(imageFile);
            matcher.appendReplacement(sb, "$1" + Matcher.quoteReplacement(imageFile.toPath().toString()) + "$4");
        }
        matcher.appendTail(sb);
        String blobContentWithAbsolutePaths = sb.toString();
        if (blobContentWithAbsolutePaths.equals(initialBlobContent)) {
            return blob;
        }
        StringBlob newBlob = new StringBlob(blobContentWithAbsolutePaths, blob.getMimeType(), blob.getEncoding());
        newBlob.setFilename(blob.getFilename());
        return newBlob;
    }

    public BlobHolder convert(String converterName, BlobHolder blobHolder, Map<String, Serializable> parameters) throws ConversionException {
        ConverterCheckResult check;
        if (parameters == null) {
            parameters = new HashMap<String, Serializable>();
        }
        if (!(check = this.isConverterAvailable(converterName)).isAvailable()) {
            throw new ConverterNotAvailable(converterName);
        }
        ConverterDescriptor desc = this.converterDescriptors.get(converterName);
        if (desc == null) {
            throw new ConversionException("Converter " + converterName + " can not be found");
        }
        String cacheKey = CacheKeyGenerator.computeKey(converterName, blobHolder, parameters);
        BlobHolder result = ConversionCacheHolder.getFromCache(cacheKey);
        if (result == null) {
            Converter converter = desc.getConverterInstance();
            result = converter.convert(blobHolder, parameters);
            if (this.config.isCacheEnabled()) {
                ConversionCacheHolder.addToCache(cacheKey, result);
            }
        }
        if (result != null) {
            this.updateResultBlobMimeType(result, desc);
            this.updateResultBlobFileName(blobHolder, result);
        }
        return result;
    }

    protected void updateResultBlobMimeType(BlobHolder resultBh, ConverterDescriptor desc) {
        Blob mainBlob = resultBh.getBlob();
        if (mainBlob == null) {
            return;
        }
        String mimeType = mainBlob.getMimeType();
        if (StringUtils.isBlank((String)mimeType) || mimeType.equals("application/octet-stream")) {
            mainBlob.setMimeType(desc.getDestinationMimeType());
        }
    }

    protected void updateResultBlobFileName(BlobHolder srcBh, BlobHolder resultBh) {
        Blob srcBlob;
        Blob mainBlob = resultBh.getBlob();
        if (mainBlob == null) {
            return;
        }
        String filename = mainBlob.getFilename();
        if ((StringUtils.isBlank((String)filename) || filename.startsWith("nxblob-")) && (srcBlob = srcBh.getBlob()) != null && StringUtils.isNotBlank((String)srcBlob.getFilename())) {
            String extension;
            String baseName = FilenameUtils.getBaseName((String)srcBlob.getFilename());
            MimetypeRegistry mimetypeRegistry = (MimetypeRegistry)Framework.getLocalService(MimetypeRegistry.class);
            MimetypeEntry mimeTypeEntry = mimetypeRegistry.getMimetypeEntryByMimeType(mainBlob.getMimeType());
            List extensions = mimeTypeEntry.getExtensions();
            if (!extensions.isEmpty()) {
                extension = (String)extensions.get(0);
            } else {
                extension = FilenameUtils.getExtension((String)filename);
                if (extension == null) {
                    extension = "bin";
                }
            }
            mainBlob.setFilename(baseName + "." + extension);
        }
    }

    public BlobHolder convertToMimeType(String destinationMimeType, BlobHolder blobHolder, Map<String, Serializable> parameters) throws ConversionException {
        String srcMt = blobHolder.getBlob().getMimeType();
        String converterName = this.translationHelper.getConverterName(srcMt, destinationMimeType);
        if (converterName == null) {
            throw new ConversionException("Cannot find converter from type " + srcMt + " to type " + destinationMimeType);
        }
        return this.convert(converterName, blobHolder, parameters);
    }

    public List<String> getConverterNames(String sourceMimeType, String destinationMimeType) {
        return this.translationHelper.getConverterNames(sourceMimeType, destinationMimeType);
    }

    public String getConverterName(String sourceMimeType, String destinationMimeType) {
        List<String> converterNames = this.getConverterNames(sourceMimeType, destinationMimeType);
        if (!converterNames.isEmpty()) {
            return converterNames.get(converterNames.size() - 1);
        }
        return null;
    }

    public ConverterCheckResult isConverterAvailable(String converterName) throws ConversionException {
        return this.isConverterAvailable(converterName, false);
    }

    public ConverterCheckResult isConverterAvailable(String converterName, boolean refresh) throws ConverterNotRegistered {
        ConverterCheckResult result;
        if (!refresh && this.checkResultCache.containsKey(converterName)) {
            return this.checkResultCache.get(converterName);
        }
        ConverterDescriptor descriptor = this.converterDescriptors.get(converterName);
        if (descriptor == null) {
            throw new ConverterNotRegistered(converterName);
        }
        Converter converter = descriptor.getConverterInstance();
        if (converter instanceof ExternalConverter) {
            ExternalConverter exConverter = (ExternalConverter)converter;
            result = exConverter.isConverterAvailable();
        } else if (converter instanceof ChainedConverter) {
            ChainedConverter chainedConverter = (ChainedConverter)converter;
            result = new ConverterCheckResult();
            if (chainedConverter.isSubConvertersBased()) {
                String subConverterName;
                Iterator<String> iterator = chainedConverter.getSubConverters().iterator();
                while (iterator.hasNext() && (result = this.isConverterAvailable(subConverterName = iterator.next(), refresh)).isAvailable()) {
                }
            }
        } else {
            result = new ConverterCheckResult();
        }
        result.setSupportedInputMimeTypes(descriptor.getSourceMimeTypes());
        this.checkResultCache.put(converterName, result);
        return result;
    }

    public boolean isSourceMimeTypeSupported(String converterName, String sourceMimeType) {
        return ConversionServiceImpl.getConverterDescriptor(converterName).getSourceMimeTypes().contains(sourceMimeType);
    }

    public String scheduleConversion(String converterName, BlobHolder blobHolder, Map<String, Serializable> parameters) {
        WorkManager workManager = (WorkManager)Framework.getService(WorkManager.class);
        ConversionWork work = new ConversionWork(converterName, null, blobHolder, parameters);
        workManager.schedule((Work)work);
        return work.getId();
    }

    public String scheduleConversionToMimeType(String destinationMimeType, BlobHolder blobHolder, Map<String, Serializable> parameters) {
        WorkManager workManager = (WorkManager)Framework.getService(WorkManager.class);
        ConversionWork work = new ConversionWork(null, destinationMimeType, blobHolder, parameters);
        workManager.schedule((Work)work);
        return work.getId();
    }

    public ConversionStatus getConversionStatus(String id) {
        WorkManager workManager = (WorkManager)Framework.getService(WorkManager.class);
        Work.State workState = workManager.getWorkState(id);
        if (workState == null) {
            String entryKey = TransientStoreWork.computeEntryKey((String)id);
            if (TransientStoreWork.containsBlobHolder((String)entryKey)) {
                return new ConversionStatus(id, ConversionStatus.Status.COMPLETED);
            }
            return null;
        }
        return new ConversionStatus(id, ConversionStatus.Status.valueOf((String)workState.name()));
    }

    public BlobHolder getConversionResult(String id, boolean cleanTransientStoreEntry) {
        String entryKey = TransientStoreWork.computeEntryKey((String)id);
        BlobHolder bh = TransientStoreWork.getBlobHolder((String)entryKey);
        if (cleanTransientStoreEntry) {
            TransientStoreWork.removeBlobHolder((String)entryKey);
        }
        return bh;
    }

    public <T> T getAdapter(Class<T> adapter) {
        if (adapter.isAssignableFrom(MimeTypeTranslationHelper.class)) {
            return adapter.cast(this.translationHelper);
        }
        return (T)super.getAdapter(adapter);
    }

    public void applicationStarted(ComponentContext context) {
        this.startGC();
    }

    protected void startGC() {
        log.debug((Object)"CasheCGTaskActivator activated starting GC thread");
        this.gcTask = new GCTask();
        this.gcThread = new Thread((Runnable)this.gcTask, "Nuxeo-Convert-GC");
        this.gcThread.setDaemon(true);
        this.gcThread.start();
        log.debug((Object)"GC Thread started");
    }

    public void endGC() {
        if (this.gcTask == null) {
            return;
        }
        log.debug((Object)"Stopping GC Thread");
        this.gcTask.GCEnabled = false;
        this.gcTask = null;
        this.gcThread.interrupt();
        this.gcThread = null;
    }

    class ReloadListener
    implements EventListener {
        ReloadListener() {
        }

        public void handleEvent(Event event) {
            if ("after-reload".equals(event.getId())) {
                ConversionServiceImpl.this.startGC();
            } else if ("before-reload".equals(event.getId())) {
                ConversionServiceImpl.this.endGC();
            }
        }
    }
}

