/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.automation.server.jaxrs.batch;

import java.io.IOException;
import java.io.InputStream;
import java.security.Principal;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import java.util.concurrent.atomic.AtomicInteger;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuxeo.ecm.automation.AutomationService;
import org.nuxeo.ecm.automation.OperationContext;
import org.nuxeo.ecm.automation.OperationException;
import org.nuxeo.ecm.automation.core.util.BlobList;
import org.nuxeo.ecm.automation.core.util.ComplexTypeJSONDecoder;
import org.nuxeo.ecm.automation.core.util.JSONBlobDecoder;
import org.nuxeo.ecm.automation.server.AutomationServer;
import org.nuxeo.ecm.automation.server.RestBinding;
import org.nuxeo.ecm.automation.server.jaxrs.batch.Batch;
import org.nuxeo.ecm.automation.server.jaxrs.batch.BatchFileEntry;
import org.nuxeo.ecm.automation.server.jaxrs.batch.BatchManager;
import org.nuxeo.ecm.automation.server.jaxrs.batch.JSONBatchBlobDecoder;
import org.nuxeo.ecm.core.api.Blob;
import org.nuxeo.ecm.core.api.CoreSession;
import org.nuxeo.ecm.core.api.NuxeoException;
import org.nuxeo.ecm.core.api.NuxeoPrincipal;
import org.nuxeo.ecm.core.transientstore.api.TransientStore;
import org.nuxeo.ecm.core.transientstore.api.TransientStoreService;
import org.nuxeo.ecm.webengine.model.exceptions.WebSecurityException;
import org.nuxeo.runtime.api.Framework;
import org.nuxeo.runtime.model.DefaultComponent;
import org.nuxeo.runtime.services.config.ConfigurationService;

public class BatchManagerComponent
extends DefaultComponent
implements BatchManager {
    protected static final Log log = LogFactory.getLog(BatchManagerComponent.class);
    protected static final String TRANSIENT_STORE_NAME = "BatchManagerCache";
    protected static final String CLIENT_BATCH_ID_FLAG = "allowClientGeneratedBatchId";
    protected final AtomicInteger uploadInProgress = new AtomicInteger(0);

    @Override
    public TransientStore getTransientStore() {
        TransientStoreService tss = (TransientStoreService)Framework.getService(TransientStoreService.class);
        return tss.getStore(TRANSIENT_STORE_NAME);
    }

    @Override
    public String initBatch() {
        Batch batch = this.initBatchInternal(null);
        return batch.getKey();
    }

    @Override
    @Deprecated
    public String initBatch(String batchId, String contextName) {
        Batch batch = this.initBatchInternal(batchId);
        return batch.getKey();
    }

    protected Batch initBatchInternal(String batchId) {
        if (StringUtils.isEmpty((String)batchId)) {
            batchId = "batchId-" + UUID.randomUUID().toString();
        } else if (!((ConfigurationService)Framework.getService(ConfigurationService.class)).isBooleanPropertyTrue(CLIENT_BATCH_ID_FLAG)) {
            throw new NuxeoException(String.format("Cannot initialize upload batch with a given id since configuration property %s is not set to true", CLIENT_BATCH_ID_FLAG));
        }
        log.debug((Object)("Initializing batch with id " + batchId));
        this.getTransientStore().setCompleted(batchId, false);
        return new Batch(batchId);
    }

    public Batch getBatch(String batchId) {
        HashMap batchEntryParams = this.getTransientStore().getParameters(batchId);
        if (batchEntryParams == null) {
            if (!this.hasBatch(batchId)) {
                return null;
            }
            batchEntryParams = new HashMap();
        }
        return new Batch(batchId, batchEntryParams);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void addStream(String batchId, String index, InputStream is, String name, String mime) throws IOException {
        this.uploadInProgress.incrementAndGet();
        try {
            Batch batch = this.getBatch(batchId);
            if (batch == null) {
                batch = this.initBatchInternal(batchId);
            }
            batch.addFile(index, is, name, mime);
            log.debug((Object)String.format("Added file %s [%s] to batch %s", index, name, batch.getKey()));
        }
        finally {
            this.uploadInProgress.decrementAndGet();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void addStream(String batchId, String index, InputStream is, int chunkCount, int chunkIndex, String name, String mime, long fileSize) throws IOException {
        this.uploadInProgress.incrementAndGet();
        try {
            Batch batch = this.getBatch(batchId);
            if (batch == null) {
                batch = this.initBatchInternal(batchId);
            }
            batch.addChunk(index, is, chunkCount, chunkIndex, name, mime, fileSize);
            log.debug((Object)String.format("Added chunk %s to file %s [%s] in batch %s", chunkIndex, index, name, batch.getKey()));
        }
        finally {
            this.uploadInProgress.decrementAndGet();
        }
    }

    @Override
    public boolean hasBatch(String batchId) {
        return batchId != null && this.getTransientStore().exists(batchId);
    }

    @Override
    public List<Blob> getBlobs(String batchId) {
        return this.getBlobs(batchId, 0);
    }

    @Override
    public List<Blob> getBlobs(String batchId, int timeoutS) {
        Batch batch;
        if (this.uploadInProgress.get() > 0 && timeoutS > 0) {
            for (int i = 0; i < timeoutS * 5; ++i) {
                try {
                    Thread.sleep(200L);
                }
                catch (InterruptedException e) {
                    Thread.currentThread().interrupt();
                }
                if (this.uploadInProgress.get() == 0) break;
            }
        }
        if ((batch = this.getBatch(batchId)) == null) {
            log.error((Object)("Unable to find batch with id " + batchId));
            return Collections.emptyList();
        }
        return batch.getBlobs();
    }

    @Override
    public Blob getBlob(String batchId, String fileIndex) {
        return this.getBlob(batchId, fileIndex, 0);
    }

    @Override
    public Blob getBlob(String batchId, String fileIndex, int timeoutS) {
        Blob blob = this.getBatchBlob(batchId, fileIndex);
        if (blob == null && timeoutS > 0 && this.uploadInProgress.get() > 0) {
            for (int i = 0; i < timeoutS * 5; ++i) {
                try {
                    Thread.sleep(200L);
                }
                catch (InterruptedException e) {
                    Thread.currentThread().interrupt();
                }
                blob = this.getBatchBlob(batchId, fileIndex);
                if (blob != null) break;
            }
        }
        if (!this.hasBatch(batchId)) {
            log.error((Object)("Unable to find batch with id " + batchId));
            return null;
        }
        return blob;
    }

    protected Blob getBatchBlob(String batchId, String fileIndex) {
        Blob blob = null;
        Batch batch = this.getBatch(batchId);
        if (batch != null) {
            blob = batch.getBlob(fileIndex);
        }
        return blob;
    }

    @Override
    public List<BatchFileEntry> getFileEntries(String batchId) {
        Batch batch = this.getBatch(batchId);
        if (batch == null) {
            return null;
        }
        return batch.getFileEntries();
    }

    @Override
    public BatchFileEntry getFileEntry(String batchId, String fileIndex) {
        Batch batch = this.getBatch(batchId);
        if (batch == null) {
            return null;
        }
        return batch.getFileEntry(fileIndex);
    }

    @Override
    public void clean(String batchId) {
        Batch batch = this.getBatch(batchId);
        if (batch != null) {
            batch.clean();
        }
    }

    @Override
    public Object execute(String batchId, String chainOrOperationId, CoreSession session, Map<String, Object> contextParams, Map<String, Object> operationParams) {
        List<Blob> blobs = this.getBlobs(batchId, this.getUploadWaitTimeout());
        if (blobs == null) {
            String message = String.format("Unable to find batch associated with id '%s'", batchId);
            log.error((Object)message);
            throw new NuxeoException(message);
        }
        return this.execute(new BlobList(blobs), chainOrOperationId, session, contextParams, operationParams);
    }

    @Override
    public Object execute(String batchId, String fileIndex, String chainOrOperationId, CoreSession session, Map<String, Object> contextParams, Map<String, Object> operationParams) {
        Blob blob = this.getBlob(batchId, fileIndex, this.getUploadWaitTimeout());
        if (blob == null) {
            String message = String.format("Unable to find batch associated with id '%s' or file associated with index '%s'", batchId, fileIndex);
            log.error((Object)message);
            throw new NuxeoException(message);
        }
        return this.execute(blob, chainOrOperationId, session, contextParams, operationParams);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected Object execute(Object blobInput, String chainOrOperationId, CoreSession session, Map<String, Object> contextParams, Map<String, Object> operationParams) {
        if (contextParams == null) {
            contextParams = new HashMap<String, Object>();
        }
        if (operationParams == null) {
            operationParams = new HashMap<String, Object>();
        }
        try (OperationContext ctx = new OperationContext(session);){
            Principal principal;
            AutomationServer server = (AutomationServer)Framework.getService(AutomationServer.class);
            RestBinding binding = server.getOperationBinding(chainOrOperationId);
            if (!(binding == null || !binding.isAdministrator() || (principal = ctx.getPrincipal()) instanceof NuxeoPrincipal && ((NuxeoPrincipal)principal).isAdministrator())) {
                String message = "Not allowed. You must be administrator to use this operation";
                log.error((Object)message);
                throw new WebSecurityException(message);
            }
            ctx.setInput(blobInput);
            ctx.putAll(contextParams);
            Object result = null;
            AutomationService as = (AutomationService)Framework.getLocalService(AutomationService.class);
            Object object = result = as.run(ctx, chainOrOperationId, operationParams);
            return object;
        }
        catch (OperationException e) {
            log.error((Object)"Error while executing automation batch ", (Throwable)e);
            throw new NuxeoException((Throwable)e);
        }
    }

    protected int getUploadWaitTimeout() {
        String t = Framework.getProperty((String)"org.nuxeo.batch.upload.wait.timeout", (String)"5");
        try {
            return Integer.parseInt(t);
        }
        catch (NumberFormatException e) {
            log.error((Object)"Wrong number format for upload wait timeout property", (Throwable)e);
            return 5;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Object executeAndClean(String batchId, String chainOrOperationId, CoreSession session, Map<String, Object> contextParams, Map<String, Object> operationParams) {
        try {
            Object object = this.execute(batchId, chainOrOperationId, session, contextParams, operationParams);
            return object;
        }
        finally {
            this.clean(batchId);
        }
    }

    @Override
    public boolean removeFileEntry(String batchId, String filedIdx) {
        Batch batch = this.getBatch(batchId);
        if (batch == null) {
            return false;
        }
        return batch.removeFileEntry(filedIdx, this.getTransientStore());
    }

    static {
        ComplexTypeJSONDecoder.registerBlobDecoder((JSONBlobDecoder)new JSONBatchBlobDecoder());
    }
}

