/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.platform.query.api;

import java.io.IOException;
import java.io.Serializable;
import java.security.Principal;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang.ArrayUtils;
import org.apache.commons.lang.NotImplementedException;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuxeo.ecm.core.api.DocumentModel;
import org.nuxeo.ecm.core.api.NuxeoException;
import org.nuxeo.ecm.core.api.SortInfo;
import org.nuxeo.ecm.core.api.impl.SimpleDocumentModel;
import org.nuxeo.ecm.core.api.model.Property;
import org.nuxeo.ecm.core.event.EventService;
import org.nuxeo.ecm.core.event.impl.UnboundEventContext;
import org.nuxeo.ecm.core.io.registry.MarshallerHelper;
import org.nuxeo.ecm.core.io.registry.context.RenderingContext;
import org.nuxeo.ecm.platform.query.api.Aggregate;
import org.nuxeo.ecm.platform.query.api.AggregateDefinition;
import org.nuxeo.ecm.platform.query.api.AggregateRangeDateDefinition;
import org.nuxeo.ecm.platform.query.api.Bucket;
import org.nuxeo.ecm.platform.query.api.PageProvider;
import org.nuxeo.ecm.platform.query.api.PageProviderChangedListener;
import org.nuxeo.ecm.platform.query.api.PageProviderDefinition;
import org.nuxeo.ecm.platform.query.api.PageSelection;
import org.nuxeo.ecm.platform.query.api.PageSelections;
import org.nuxeo.ecm.platform.query.api.QuickFilter;
import org.nuxeo.ecm.platform.query.api.WhereClauseDefinition;
import org.nuxeo.runtime.api.Framework;
import org.nuxeo.runtime.services.config.ConfigurationService;

public abstract class AbstractPageProvider<T>
implements PageProvider<T> {
    public static final Log log = LogFactory.getLog(AbstractPageProvider.class);
    private static final long serialVersionUID = 1L;
    public static final String PAGEPROVIDER_TRACK_PROPERTY_NAME = "nuxeo.pageprovider.track";
    protected static final List<String> SKIPPED_SCHEMAS_FOR_SEARCHFIELD = Collections.singletonList("cvd");
    protected String name;
    protected long offset = 0L;
    protected long pageSize = 0L;
    protected List<Long> pageSizeOptions;
    protected long maxPageSize = this.getDefaultMaxPageSize();
    protected long resultsCount = -1L;
    protected int currentEntryIndex = 0;
    protected int currentHigherNonEmptyPageIndex = 0;
    protected List<SortInfo> sortInfos;
    protected boolean sortable = false;
    protected List<T> selectedEntries;
    protected PageSelections<T> currentSelectPage;
    protected Map<String, Serializable> properties;
    protected Object[] parameters;
    protected DocumentModel searchDocumentModel;
    protected List<QuickFilter> quickFilters;
    protected List<String> highlights;
    protected String errorMessage;
    protected Throwable error;
    protected PageProviderDefinition definition;
    protected PageProviderChangedListener pageProviderChangedListener;
    protected Boolean tracking = null;

    public abstract List<T> getCurrentPage();

    protected void pageChanged() {
        this.currentEntryIndex = 0;
        this.currentSelectPage = null;
        this.notifyPageChanged();
    }

    public void firstPage() {
        long pageSize = this.getPageSize();
        if (pageSize == 0L) {
            return;
        }
        long offset = this.getCurrentPageOffset();
        if (offset != 0L) {
            this.setCurrentPageOffset(0L);
            this.pageChanged();
        }
    }

    public long getCurrentPageIndex() {
        long pageSize = this.getPageSize();
        if (pageSize == 0L) {
            return 0L;
        }
        long offset = this.getCurrentPageOffset();
        return offset / pageSize;
    }

    public long getCurrentPageOffset() {
        return this.offset;
    }

    public void setCurrentPageOffset(long offset) {
        this.offset = offset;
    }

    public long getCurrentPageSize() {
        List<T> currentItems = this.getCurrentPage();
        if (currentItems != null) {
            return currentItems.size();
        }
        return 0L;
    }

    public String getName() {
        return this.name;
    }

    public long getNumberOfPages() {
        long pageSize = this.getPageSize();
        if (pageSize == 0L) {
            return 1L;
        }
        pageSize = this.getMinMaxPageSize();
        if (pageSize == 0L) {
            return 1L;
        }
        long resultsCount = this.getResultsCount();
        if (resultsCount < 0L) {
            return 0L;
        }
        return 1L + (resultsCount - 1L) / pageSize;
    }

    public void setCurrentPageIndex(long currentPageIndex) {
        long pageSize = this.getPageSize();
        long offset = currentPageIndex * pageSize;
        this.setCurrentPageOffset(offset);
        this.pageChanged();
    }

    public List<T> setCurrentPage(long page) {
        this.setCurrentPageIndex(page);
        return this.getCurrentPage();
    }

    public long getPageSize() {
        return this.pageSize;
    }

    public void setPageSize(long pageSize) {
        long localPageSize = this.getPageSize();
        if (localPageSize != pageSize) {
            this.pageSize = pageSize;
            this.setCurrentPageOffset(0L);
            this.refresh();
        }
    }

    public List<Long> getPageSizeOptions() {
        long ppsize;
        ArrayList<Long> res = new ArrayList<Long>();
        if (this.pageSizeOptions != null) {
            res.addAll(this.pageSizeOptions);
        }
        if ((ppsize = this.getPageSize()) > 0L && !res.contains(ppsize)) {
            res.add(ppsize);
        }
        Collections.sort(res);
        return res;
    }

    public void setPageSizeOptions(List<Long> options) {
        this.pageSizeOptions = options;
    }

    public List<SortInfo> getSortInfos() {
        ArrayList<SortInfo> res = new ArrayList<SortInfo>();
        if (this.sortInfos != null) {
            res.addAll(this.sortInfos);
        }
        return res;
    }

    public SortInfo getSortInfo() {
        if (this.sortInfos != null && !this.sortInfos.isEmpty()) {
            return this.sortInfos.get(0);
        }
        return null;
    }

    protected boolean sortInfoChanged(List<SortInfo> oldSortInfos, List<SortInfo> newSortInfos) {
        if (oldSortInfos == null && newSortInfos == null) {
            return false;
        }
        if (oldSortInfos == null) {
            oldSortInfos = Collections.emptyList();
        } else if (newSortInfos == null) {
            newSortInfos = Collections.emptyList();
        }
        if (oldSortInfos.size() != newSortInfos.size()) {
            return true;
        }
        for (int i = 0; i < oldSortInfos.size(); ++i) {
            SortInfo oldSort = (SortInfo)oldSortInfos.get(i);
            SortInfo newSort = (SortInfo)newSortInfos.get(i);
            if (oldSort == null && newSort == null) continue;
            if (oldSort == null || newSort == null) {
                return true;
            }
            if (oldSort.equals((Object)newSort)) continue;
            return true;
        }
        return false;
    }

    public void setQuickFilters(List<QuickFilter> quickFilters) {
        this.quickFilters = quickFilters;
    }

    public List<QuickFilter> getQuickFilters() {
        return this.quickFilters;
    }

    public List<QuickFilter> getAvailableQuickFilters() {
        return this.definition != null ? this.definition.getQuickFilters() : null;
    }

    public void addQuickFilter(QuickFilter quickFilter) {
        if (this.quickFilters == null) {
            this.quickFilters = new ArrayList<QuickFilter>();
        }
        this.quickFilters.add(quickFilter);
    }

    public void setSortInfos(List<SortInfo> sortInfo) {
        if (this.sortInfoChanged(this.sortInfos, sortInfo)) {
            this.sortInfos = sortInfo;
            this.refresh();
        }
    }

    public void setSortInfo(SortInfo sortInfo) {
        ArrayList<SortInfo> newSortInfos = new ArrayList<SortInfo>();
        if (sortInfo != null) {
            newSortInfos.add(sortInfo);
        }
        this.setSortInfos(newSortInfos);
    }

    public void setSortInfo(String sortColumn, boolean sortAscending, boolean removeOtherSortInfos) {
        if (removeOtherSortInfos) {
            SortInfo sortInfo = new SortInfo(sortColumn, sortAscending);
            this.setSortInfo(sortInfo);
        } else if (this.getSortInfoIndex(sortColumn, sortAscending) == -1) {
            if (this.getSortInfoIndex(sortColumn, !sortAscending) != -1) {
                ArrayList<SortInfo> newSortInfos = new ArrayList<SortInfo>();
                for (SortInfo sortInfo : this.getSortInfos()) {
                    if (sortColumn.equals(sortInfo.getSortColumn())) {
                        newSortInfos.add(new SortInfo(sortColumn, sortAscending));
                        continue;
                    }
                    newSortInfos.add(sortInfo);
                }
                this.setSortInfos(newSortInfos);
            } else {
                this.addSortInfo(sortColumn, sortAscending);
            }
        }
    }

    public void addSortInfo(String sortColumn, boolean sortAscending) {
        SortInfo sortInfo = new SortInfo(sortColumn, sortAscending);
        List<SortInfo> sortInfos = this.getSortInfos();
        if (sortInfos == null) {
            this.setSortInfo(sortInfo);
        } else {
            sortInfos.add(sortInfo);
            this.setSortInfos(sortInfos);
        }
    }

    public int getSortInfoIndex(String sortColumn, boolean sortAscending) {
        List<SortInfo> sortInfos = this.getSortInfos();
        if (sortInfos == null || sortInfos.isEmpty()) {
            return -1;
        }
        SortInfo sortInfo = new SortInfo(sortColumn, sortAscending);
        return sortInfos.indexOf(sortInfo);
    }

    public List<String> getHighlights() {
        return this.highlights;
    }

    public void setHighlights(List<String> highlights) {
        this.highlights = highlights;
    }

    public boolean isNextPageAvailable() {
        long pageSize = this.getPageSize();
        if (pageSize == 0L) {
            return false;
        }
        long resultsCount = this.getResultsCount();
        if (resultsCount < 0L) {
            long currentPageIndex = this.getCurrentPageIndex();
            return currentPageIndex < (long)(this.getCurrentHigherNonEmptyPageIndex() + this.getMaxNumberOfEmptyPages());
        }
        long offset = this.getCurrentPageOffset();
        return resultsCount > pageSize + offset;
    }

    public boolean isLastPageAvailable() {
        long resultsCount = this.getResultsCount();
        if (resultsCount < 0L) {
            return false;
        }
        return this.isNextPageAvailable();
    }

    public boolean isPreviousPageAvailable() {
        long offset = this.getCurrentPageOffset();
        return offset > 0L;
    }

    public void lastPage() {
        long pageSize = this.getPageSize();
        long resultsCount = this.getResultsCount();
        if (pageSize == 0L || resultsCount < 0L) {
            return;
        }
        if (resultsCount % pageSize == 0L) {
            this.setCurrentPageOffset(resultsCount - pageSize);
        } else {
            this.setCurrentPageOffset(resultsCount - resultsCount % pageSize);
        }
        this.pageChanged();
    }

    public void nextPage() {
        long pageSize = this.getPageSize();
        if (pageSize == 0L) {
            return;
        }
        long offset = this.getCurrentPageOffset();
        this.setCurrentPageOffset(offset += pageSize);
        this.pageChanged();
    }

    public void previousPage() {
        long pageSize = this.getPageSize();
        if (pageSize == 0L) {
            return;
        }
        long offset = this.getCurrentPageOffset();
        if (offset >= pageSize) {
            this.setCurrentPageOffset(offset -= pageSize);
            this.pageChanged();
        }
    }

    public void refresh() {
        this.setResultsCount(-1L);
        this.setCurrentHigherNonEmptyPageIndex(-1);
        this.currentSelectPage = null;
        this.errorMessage = null;
        this.error = null;
        this.notifyRefresh();
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getCurrentPageStatus() {
        long total = this.getNumberOfPages();
        long current = this.getCurrentPageIndex() + 1L;
        if (total <= 0L) {
            return String.format("%d", current);
        }
        return String.format("%d/%d", current, total);
    }

    public boolean isNextEntryAvailable() {
        long pageSize = this.getPageSize();
        long resultsCount = this.getResultsCount();
        if (pageSize == 0L) {
            if (resultsCount < 0L) {
                long currentPageSize = this.getCurrentPageSize();
                return (long)this.currentEntryIndex < currentPageSize - 1L;
            }
            return (long)this.currentEntryIndex < resultsCount - 1L;
        }
        long currentPageSize = this.getCurrentPageSize();
        if ((long)this.currentEntryIndex < currentPageSize - 1L) {
            return true;
        }
        if (resultsCount < 0L) {
            return false;
        }
        return this.isNextPageAvailable();
    }

    public boolean isPreviousEntryAvailable() {
        return this.currentEntryIndex != 0 || this.isPreviousPageAvailable();
    }

    public void nextEntry() {
        long pageSize = this.getPageSize();
        long resultsCount = this.getResultsCount();
        if (pageSize == 0L) {
            if (resultsCount < 0L) {
                long currentPageSize = this.getCurrentPageSize();
                if ((long)this.currentEntryIndex < currentPageSize - 1L) {
                    ++this.currentEntryIndex;
                    return;
                }
            } else if ((long)this.currentEntryIndex < resultsCount - 1L) {
                ++this.currentEntryIndex;
                return;
            }
        } else {
            long currentPageSize = this.getCurrentPageSize();
            if ((long)this.currentEntryIndex < currentPageSize - 1L) {
                ++this.currentEntryIndex;
                return;
            }
            if (resultsCount >= 0L && this.isNextPageAvailable()) {
                this.nextPage();
                this.currentEntryIndex = 0;
                return;
            }
        }
    }

    public void previousEntry() {
        if (this.currentEntryIndex > 0) {
            --this.currentEntryIndex;
            return;
        }
        if (!this.isPreviousPageAvailable()) {
            return;
        }
        this.previousPage();
        List<T> currentPage = this.getCurrentPage();
        this.currentEntryIndex = currentPage == null || currentPage.isEmpty() ? 0 : new Long(this.getPageSize() - 1L).intValue();
    }

    public T getCurrentEntry() {
        List<T> currentPage = this.getCurrentPage();
        if (currentPage == null || currentPage.isEmpty()) {
            return null;
        }
        return currentPage.get(this.currentEntryIndex);
    }

    public void setCurrentEntry(T entry) {
        List<T> currentPage = this.getCurrentPage();
        if (currentPage == null || currentPage.isEmpty()) {
            throw new NuxeoException(String.format("Entry '%s' not found in current page", entry));
        }
        int i = currentPage.indexOf(entry);
        if (i == -1) {
            throw new NuxeoException(String.format("Entry '%s' not found in current page", entry));
        }
        this.currentEntryIndex = i;
    }

    public void setCurrentEntryIndex(long index) {
        int intIndex = new Long(index).intValue();
        List<T> currentPage = this.getCurrentPage();
        if (currentPage == null || currentPage.isEmpty()) {
            throw new NuxeoException(String.format("Index %s not found in current page", new Integer(intIndex)));
        }
        if (index >= (long)currentPage.size()) {
            throw new NuxeoException(String.format("Index %s not found in current page", new Integer(intIndex)));
        }
        this.currentEntryIndex = intIndex;
    }

    public long getResultsCount() {
        return this.resultsCount;
    }

    public Map<String, Serializable> getProperties() {
        return new HashMap<String, Serializable>(this.properties);
    }

    public void setProperties(Map<String, Serializable> properties) {
        this.properties = properties;
    }

    protected boolean getBooleanProperty(String propName, boolean defaultValue) {
        Map<String, Serializable> props = this.getProperties();
        if (props.containsKey(propName)) {
            Serializable prop = props.get(propName);
            if (prop instanceof String) {
                return Boolean.parseBoolean((String)((Object)prop));
            }
            return Boolean.TRUE.equals(prop);
        }
        return defaultValue;
    }

    public void setResultsCount(long resultsCount) {
        this.resultsCount = resultsCount;
        this.setCurrentHigherNonEmptyPageIndex(-1);
    }

    public void setSortable(boolean sortable) {
        this.sortable = sortable;
    }

    public boolean isSortable() {
        return this.sortable;
    }

    public PageSelections<T> getCurrentSelectPage() {
        if (this.currentSelectPage == null) {
            ArrayList<PageSelection> entries = new ArrayList<PageSelection>();
            List<T> currentPage = this.getCurrentPage();
            this.currentSelectPage = new PageSelections();
            this.currentSelectPage.setName(this.name);
            if (currentPage != null && !currentPage.isEmpty()) {
                if (this.selectedEntries == null || this.selectedEntries.isEmpty()) {
                    for (T entry : currentPage) {
                        entries.add(new PageSelection(entry, false));
                    }
                } else {
                    boolean allSelected = true;
                    for (T entry : currentPage) {
                        Boolean selected = this.selectedEntries.contains(entry);
                        if (!Boolean.TRUE.equals(selected)) {
                            allSelected = false;
                        }
                        entries.add(new PageSelection(entry, selected.booleanValue()));
                    }
                    if (allSelected) {
                        this.currentSelectPage.setSelected(true);
                    }
                }
            }
            this.currentSelectPage.setEntries(entries);
        }
        return this.currentSelectPage;
    }

    public void setSelectedEntries(List<T> entries) {
        this.selectedEntries = entries;
        this.currentSelectPage = null;
    }

    public Object[] getParameters() {
        return this.parameters;
    }

    public void setParameters(Object[] parameters) {
        this.parameters = parameters;
    }

    public DocumentModel getSearchDocumentModel() {
        return this.searchDocumentModel;
    }

    protected boolean searchDocumentModelChanged(DocumentModel oldDoc, DocumentModel newDoc) {
        if (oldDoc == null && newDoc == null) {
            return false;
        }
        if (oldDoc == null || newDoc == null) {
            return true;
        }
        return true;
    }

    public void setSearchDocumentModel(DocumentModel searchDocumentModel) {
        if (this.searchDocumentModelChanged(this.searchDocumentModel, searchDocumentModel)) {
            this.refresh();
        }
        this.searchDocumentModel = searchDocumentModel;
    }

    public String getErrorMessage() {
        return this.errorMessage;
    }

    public Throwable getError() {
        return this.error;
    }

    public boolean hasError() {
        return this.error != null;
    }

    public PageProviderDefinition getDefinition() {
        return this.definition;
    }

    public void setDefinition(PageProviderDefinition providerDefinition) {
        this.definition = providerDefinition;
    }

    public long getMaxPageSize() {
        return this.maxPageSize;
    }

    public void setMaxPageSize(long maxPageSize) {
        this.maxPageSize = maxPageSize;
    }

    public long getMinMaxPageSize() {
        long pageSize = this.getPageSize();
        long maxPageSize = this.getMaxPageSize();
        if (maxPageSize < 0L) {
            maxPageSize = this.getDefaultMaxPageSize();
        }
        if (pageSize <= 0L) {
            return maxPageSize;
        }
        if (maxPageSize > 0L && maxPageSize < pageSize) {
            return maxPageSize;
        }
        return pageSize;
    }

    public int getCurrentHigherNonEmptyPageIndex() {
        return this.currentHigherNonEmptyPageIndex;
    }

    public long getPageLimit() {
        return -1L;
    }

    public void setCurrentHigherNonEmptyPageIndex(int higherFilledPageIndex) {
        this.currentHigherNonEmptyPageIndex = higherFilledPageIndex;
    }

    public int getMaxNumberOfEmptyPages() {
        return 1;
    }

    protected long getDefaultMaxPageSize() {
        ConfigurationService cs;
        String maxPageSize;
        long res = 1000L;
        if (Framework.isInitialized() && !StringUtils.isBlank((String)(maxPageSize = (cs = (ConfigurationService)Framework.getService(ConfigurationService.class)).getProperty("nuxeo.pageprovider.default-max-page-size")))) {
            try {
                res = Long.parseLong(maxPageSize.trim());
            }
            catch (NumberFormatException e) {
                log.warn((Object)String.format("Invalid max page size defined for property \"%s\": %s (waiting for a long value)", "nuxeo.pageprovider.default-max-page-size", maxPageSize));
            }
        }
        return res;
    }

    public void setPageProviderChangedListener(PageProviderChangedListener listener) {
        this.pageProviderChangedListener = listener;
    }

    protected void notifyPageChanged() {
        if (this.pageProviderChangedListener != null) {
            this.pageProviderChangedListener.pageChanged((PageProvider)this);
        }
    }

    protected void notifyRefresh() {
        if (this.pageProviderChangedListener != null) {
            this.pageProviderChangedListener.refreshed((PageProvider)this);
        }
    }

    public boolean hasChangedParameters(Object[] parameters) {
        return this.getParametersChanged(this.getParameters(), parameters);
    }

    protected boolean getParametersChanged(Object[] oldParams, Object[] newParams) {
        if (oldParams == null && newParams == null) {
            return true;
        }
        if (oldParams != null && newParams != null) {
            if (oldParams.length != newParams.length) {
                return true;
            }
            for (int i = 0; i < oldParams.length; ++i) {
                if (oldParams[i] == null && newParams[i] == null || newParams[i] instanceof String[] && oldParams[i] instanceof String[] && Arrays.equals((String[])oldParams[i], (String[])newParams[i])) continue;
                if (oldParams[i] != null && !oldParams[i].equals(newParams[i])) {
                    return true;
                }
                if (newParams[i] == null || newParams[i].equals(oldParams[i])) continue;
                return true;
            }
            return false;
        }
        return true;
    }

    public List<AggregateDefinition> getAggregateDefinitions() {
        return this.definition.getAggregates();
    }

    public Map<String, Aggregate<? extends Bucket>> getAggregates() {
        throw new NotImplementedException();
    }

    public boolean hasAggregateSupport() {
        return false;
    }

    protected boolean isTrackingEnabled() {
        List<String> pps;
        String trackedPageProviders;
        if (this.tracking != null) {
            return this.tracking;
        }
        this.tracking = this.getDefinition().isUsageTrackingEnabled() ? Boolean.valueOf(true) : ("*".equals(trackedPageProviders = Framework.getProperty((String)PAGEPROVIDER_TRACK_PROPERTY_NAME, (String)"")) ? Boolean.valueOf(true) : ((pps = Arrays.asList(trackedPageProviders.split(","))).contains(this.getDefinition().getName()) ? Boolean.valueOf(true) : Boolean.valueOf(false)));
        return this.tracking;
    }

    protected void fireSearchEvent(Principal principal, String query, List<T> entries, Long executionTimeMs) {
        DocumentModel searchDocumentModel;
        if (!this.isTrackingEnabled()) {
            return;
        }
        HashMap<String, Serializable> props = new HashMap<String, Serializable>();
        props.put("pageProviderName", (Serializable)((Object)this.getDefinition().getName()));
        props.put("effectiveQuery", (Serializable)((Object)query));
        props.put("searchPattern", (Serializable)((Object)this.getDefinition().getPattern()));
        props.put("queryParams", (Serializable)this.getDefinition().getQueryParameters());
        props.put("params", (Serializable)this.getParameters());
        WhereClauseDefinition wc = this.getDefinition().getWhereClause();
        if (wc != null) {
            props.put("whereClause_fixedPart", (Serializable)((Object)wc.getFixedPart()));
            props.put("whereClause_select", (Serializable)((Object)wc.getSelectStatement()));
        }
        if ((searchDocumentModel = this.getSearchDocumentModel()) != null && !(searchDocumentModel instanceof SimpleDocumentModel)) {
            RenderingContext rCtx = RenderingContext.CtxBuilder.properties((String[])new String[]{"*"}).get();
            try {
                String searchDocumentModelAsJson = MarshallerHelper.objectToJson(DocumentModel.class, (Object)searchDocumentModel, (RenderingContext)rCtx);
                props.put("searchDocumentModelAsJson", (Serializable)((Object)searchDocumentModelAsJson));
            }
            catch (IOException e) {
                log.error((Object)"Unable to Marshall SearchDocumentModel as JSON", (Throwable)e);
            }
            ArrayList<String> searchFields = new ArrayList<String>();
            for (String schema : searchDocumentModel.getSchemas()) {
                for (Property prop : searchDocumentModel.getPropertyObjects(schema)) {
                    if (prop.getValue() == null || SKIPPED_SCHEMAS_FOR_SEARCHFIELD.contains(prop.getSchema().getNamespace().prefix)) continue;
                    if (prop.isList()) {
                        if (!ArrayUtils.isNotEmpty((Object[])((Object[])prop.getValue(Object[].class)))) continue;
                        searchFields.add(prop.getXPath());
                        continue;
                    }
                    searchFields.add(prop.getXPath());
                }
            }
            props.put("searchFields", searchFields);
        }
        if (entries != null) {
            props.put("resultsCountInPage", Integer.valueOf(entries.size()));
        }
        props.put("resultsCount", Long.valueOf(this.getResultsCount()));
        props.put("pageSize", Long.valueOf(this.getPageSize()));
        props.put("pageIndex", Long.valueOf(this.getCurrentPageIndex()));
        props.put("principal", (Serializable)((Object)principal.getName()));
        if (executionTimeMs != null) {
            props.put("executionTimeMs", executionTimeMs);
        }
        this.incorporateAggregates(props);
        EventService es = (EventService)Framework.getService(EventService.class);
        UnboundEventContext ctx = new UnboundEventContext(principal, props);
        es.fireEvent(ctx.newEvent("search"));
    }

    protected void incorporateAggregates(Map<String, Serializable> eventProps) {
        List ags = this.getDefinition().getAggregates();
        if (ags != null) {
            ArrayList aggregates = new ArrayList();
            for (AggregateDefinition ag : ags) {
                HashMap<String, Object> agData = new HashMap<String, Object>();
                agData.put("type", ag.getType());
                agData.put("id", ag.getId());
                agData.put("field", ag.getDocumentField());
                agData.putAll(ag.getProperties());
                ArrayList rangesData = new ArrayList();
                if (ag.getDateRanges() != null) {
                    HashMap<String, Object> rangeData;
                    for (AggregateRangeDateDefinition range : ag.getDateRanges()) {
                        rangeData = new HashMap<String, Object>();
                        rangeData.put("from", range.getFromAsString());
                        rangeData.put("to", range.getToAsString());
                        rangesData.add(rangeData);
                    }
                    for (AggregateRangeDateDefinition range : ag.getRanges()) {
                        rangeData = new HashMap();
                        rangeData.put("from-dbl", range.getFrom());
                        rangeData.put("to-dbl", range.getTo());
                        rangesData.add(rangeData);
                    }
                }
                agData.put("ranges", rangesData);
                aggregates.add(agData);
            }
            eventProps.put("aggregates", aggregates);
        }
    }
}

