/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.webengine;

import java.io.File;
import java.io.IOException;
import java.text.ParseException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuxeo.ecm.webengine.ResourceBinding;
import org.nuxeo.ecm.webengine.WebEngine;
import org.nuxeo.ecm.webengine.rendering.RenderingExtensionDescriptor;
import org.nuxeo.ecm.webengine.security.GuardDescriptor;
import org.nuxeo.ecm.webengine.security.PermissionService;
import org.nuxeo.runtime.RuntimeServiceException;
import org.nuxeo.runtime.api.Framework;
import org.nuxeo.runtime.model.ComponentContext;
import org.nuxeo.runtime.model.ComponentInstance;
import org.nuxeo.runtime.model.ComponentName;
import org.nuxeo.runtime.model.DefaultComponent;

public class WebEngineComponent
extends DefaultComponent {
    public static final ComponentName NAME = new ComponentName(WebEngineComponent.class.getName());
    public static final String RENDERING_EXTENSION_XP = "rendering-extension";
    public static final String RESOURCE_BINDING_XP = "resource";
    public static final String REQUEST_CONFIGURATION_XP = "request-configuration";
    public static final String GUARD_XP = "guard";
    public static final String FORM_XP = "form";
    private static final Log log = LogFactory.getLog(WebEngineComponent.class);
    private WebEngine engine;

    public void activate(ComponentContext context) {
        super.activate(context);
        String webDir = Framework.getProperty((String)"org.nuxeo.ecm.web.root");
        File root = null;
        root = webDir != null ? new File(webDir) : new File(Framework.getRuntime().getHome(), "web");
        try {
            root = root.getCanonicalFile();
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        log.info((Object)("Using web root: " + root));
        this.engine = new WebEngine(new File(root, "root.war"));
        this.engine.start();
    }

    public void deactivate(ComponentContext context) {
        this.engine.stop();
        this.engine = null;
        super.deactivate(context);
    }

    public WebEngine getEngine() {
        return this.engine;
    }

    public void registerContribution(Object contribution, String extensionPoint, ComponentInstance contributor) {
        if (GUARD_XP.equals(extensionPoint)) {
            GuardDescriptor gd = (GuardDescriptor)contribution;
            try {
                PermissionService.getInstance().registerGuard(gd.getId(), gd.getGuard());
            }
            catch (ParseException e) {
                throw new RuntimeException(e);
            }
        } else if (RESOURCE_BINDING_XP.equals(extensionPoint)) {
            this.engine.addResourceBinding((ResourceBinding)contribution);
        } else if (extensionPoint.equals(RENDERING_EXTENSION_XP)) {
            RenderingExtensionDescriptor fed = (RenderingExtensionDescriptor)contribution;
            try {
                this.engine.registerRenderingExtension(fed.name, fed.newInstance());
            }
            catch (ReflectiveOperationException e) {
                throw new RuntimeServiceException("Deployment Error. Failed to contribute freemarker template extension: " + fed.name);
            }
        } else if (extensionPoint.equals(REQUEST_CONFIGURATION_XP)) {
            log.warn((Object)"Extension point request-configuration is obsolete since 8.4, transactions are always active");
        }
    }

    public void unregisterContribution(Object contribution, String extensionPoint, ComponentInstance contributor) {
        if (GUARD_XP.equals(extensionPoint)) {
            GuardDescriptor gd = (GuardDescriptor)contribution;
            PermissionService.getInstance().unregisterGuard(gd.getId());
        } else if (RESOURCE_BINDING_XP.equals(extensionPoint)) {
            this.engine.removeResourceBinding((ResourceBinding)contribution);
        } else if (extensionPoint.equals(RENDERING_EXTENSION_XP)) {
            RenderingExtensionDescriptor fed = (RenderingExtensionDescriptor)contribution;
            this.engine.unregisterRenderingExtension(fed.name);
        }
    }

    public <T> T getAdapter(Class<T> adapter) {
        if (adapter == WebEngine.class) {
            return adapter.cast(this.engine);
        }
        return null;
    }
}

