/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.automation.core.operations.services.directory;

import java.text.Collator;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.TreeSet;
import net.sf.json.JSONArray;
import net.sf.json.JSONObject;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuxeo.common.utils.i18n.I18NUtils;
import org.nuxeo.ecm.automation.OperationContext;
import org.nuxeo.ecm.automation.core.annotations.Context;
import org.nuxeo.ecm.automation.core.annotations.Operation;
import org.nuxeo.ecm.automation.core.annotations.OperationMethod;
import org.nuxeo.ecm.automation.core.annotations.Param;
import org.nuxeo.ecm.automation.features.SuggestConstants;
import org.nuxeo.ecm.core.api.Blob;
import org.nuxeo.ecm.core.api.Blobs;
import org.nuxeo.ecm.core.api.DocumentModel;
import org.nuxeo.ecm.core.api.DocumentModelList;
import org.nuxeo.ecm.core.api.PropertyException;
import org.nuxeo.ecm.core.schema.SchemaManager;
import org.nuxeo.ecm.core.schema.types.Field;
import org.nuxeo.ecm.core.schema.types.QName;
import org.nuxeo.ecm.core.schema.types.Schema;
import org.nuxeo.ecm.directory.Directory;
import org.nuxeo.ecm.directory.DirectoryException;
import org.nuxeo.ecm.directory.Session;
import org.nuxeo.ecm.directory.api.DirectoryService;

@Operation(id="Directory.SuggestEntries", category="Services", label="Get suggested directory entries", description="Get the entries suggestions of a directory. This is returning a blob containing a serialized JSON array. Prefix parameter is used to filter the entries.", addToStudio=false)
public class SuggestDirectoryEntries {
    Collator collator;
    private static final Log log = LogFactory.getLog(SuggestDirectoryEntries.class);
    public static final String ID = "Directory.SuggestEntries";
    @Context
    protected OperationContext ctx;
    @Context
    protected DirectoryService directoryService;
    @Context
    protected SchemaManager schemaManager;
    @Param(name="directoryName", required=true)
    protected String directoryName;
    @Param(name="localize", required=false)
    protected boolean localize;
    @Param(name="lang", required=false)
    protected String lang;
    @Param(name="searchTerm", alias={"prefix"}, required=false)
    protected String prefix;
    @Param(name="labelFieldName", required=false)
    protected String labelFieldName = "label";
    @Param(name="dbl10n", required=false)
    protected boolean dbl10n = false;
    @Param(name="canSelectParent", required=false)
    protected boolean canSelectParent = false;
    @Param(name="filterParent", required=false)
    protected boolean filterParent = false;
    @Param(name="keySeparator", required=false)
    protected String keySeparator = "/";
    @Param(name="displayObsoleteEntries", required=false)
    protected boolean displayObsoleteEntries = false;
    @Param(name="limit", required=false)
    protected int limit = -1;
    @Param(name="contains", required=false)
    protected boolean contains = false;
    @Param(name="caseSensitive", required=false)
    protected boolean caseSensitive = false;
    @Param(name="absoluteLabelSeparator", required=false)
    protected String absoluteLabelSeparator = "/";
    private String label = null;
    private boolean isChained = false;
    private String obsoleteWarningMessage = null;

    protected String getLang() {
        if (this.lang == null) {
            this.lang = (String)this.ctx.get((Object)"lang");
            if (this.lang == null) {
                this.lang = "en";
            }
        }
        return this.lang;
    }

    protected Locale getLocale() {
        return new Locale(this.getLang());
    }

    protected Collator getCollator() {
        if (this.collator == null) {
            this.collator = Collator.getInstance(this.getLocale());
            if (this.caseSensitive) {
                this.collator.setStrength(2);
            } else {
                this.collator.setStrength(1);
            }
        }
        return this.collator;
    }

    protected String getObsoleteWarningMessage() {
        if (this.obsoleteWarningMessage == null) {
            this.obsoleteWarningMessage = I18NUtils.getMessageString((String)"messages", (String)"obsolete", (Object[])new Object[0], (Locale)this.getLocale());
        }
        return this.obsoleteWarningMessage;
    }

    @OperationMethod
    public Blob run() {
        Directory directory = this.directoryService.getDirectory(this.directoryName);
        if (directory == null) {
            log.error((Object)("Could not find directory with name " + this.directoryName));
            return null;
        }
        try (Session session = directory.getSession();){
            String schemaName = directory.getSchema();
            Schema schema = this.schemaManager.getSchema(schemaName);
            Field parentField = schema.getField("parent");
            this.isChained = parentField != null;
            String parentDirectory = directory.getParentDirectory();
            if (parentDirectory == null || parentDirectory.isEmpty() || parentDirectory.equals(this.directoryName)) {
                parentDirectory = null;
            }
            boolean postFilter = true;
            this.label = SuggestConstants.getLabelFieldName(schema, this.dbl10n, this.labelFieldName, this.getLang());
            HashMap<String, Object> filter = new HashMap<String, Object>();
            if (!this.displayObsoleteEntries) {
                filter.put("obsolete", 0L);
            }
            TreeSet<String> fullText = new TreeSet<String>();
            if (this.dbl10n || !this.localize) {
                postFilter = false;
                if (this.prefix != null && !this.prefix.isEmpty()) {
                    String computedPrefix = this.prefix;
                    if (this.contains) {
                        computedPrefix = '%' + computedPrefix;
                    }
                    filter.put(this.label, computedPrefix);
                    fullText.add(this.label);
                }
            }
            DocumentModelList entries = session.query(filter, fullText, Collections.emptyMap(), false, postFilter ? -1 : this.limit, -1);
            JSONAdapter jsonAdapter = new JSONAdapter(session, schema);
            for (DocumentModel entry : entries) {
                JSONAdapter adapter = new JSONAdapter(session, schema, entry);
                if (!this.filterParent && this.isChained && parentDirectory == null && !adapter.isLeaf() || this.prefix != null && !this.prefix.isEmpty() && postFilter && (this.contains ? !adapter.getLabel().toLowerCase().contains(this.prefix.toLowerCase()) : !adapter.getLabel().toLowerCase().startsWith(this.prefix.toLowerCase()))) continue;
                jsonAdapter.push(adapter);
            }
            Iterator iterator = Blobs.createBlob((String)jsonAdapter.getChildrenJSONArray().toString(), (String)"application/json");
            return iterator;
        }
    }

    protected String translate(String key) {
        if (key == null) {
            return "";
        }
        return I18NUtils.getMessageString((String)"messages", (String)key, (Object[])new Object[0], (Locale)this.getLocale());
    }

    private class JSONAdapter
    implements Comparable<JSONAdapter> {
        private final Map<String, JSONAdapter> children;
        private final Session session;
        private final Schema schema;
        private boolean isRoot = false;
        private Boolean isLeaf = null;
        private JSONObject obj;

        public JSONAdapter(Session session, Schema schema) {
            this.session = session;
            this.schema = schema;
            this.children = new HashMap<String, JSONAdapter>();
            this.isRoot = true;
        }

        public JSONAdapter(Session session, Schema schema, DocumentModel entry) throws PropertyException {
            this(session, schema);
            this.isRoot = false;
            this.obj = new JSONObject();
            for (Field field : schema.getFields()) {
                QName fieldName = field.getName();
                String key = fieldName.getLocalName();
                Object value = entry.getPropertyValue(fieldName.getPrefixedName());
                if (suggestDirectoryEntries.label.equals(key)) {
                    if (suggestDirectoryEntries.localize && !suggestDirectoryEntries.dbl10n) {
                        value = suggestDirectoryEntries.translate(value.toString());
                    }
                    this.obj.element("displayLabel", value);
                }
                this.obj.element(key, value);
            }
            if (suggestDirectoryEntries.displayObsoleteEntries && this.obj.containsKey((Object)"obsolete") && this.obj.getInt("obsolete") > 0) {
                this.obj.element("warn_message", (Object)suggestDirectoryEntries.getObsoleteWarningMessage());
            }
        }

        @Override
        public int compareTo(JSONAdapter other) {
            if (other != null) {
                int i = this.getOrder() - other.getOrder();
                if (i != 0) {
                    return i;
                }
                return SuggestDirectoryEntries.this.getCollator().compare(this.getLabel(), other.getLabel());
            }
            return -1;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            JSONAdapter other = (JSONAdapter)obj;
            if (!this.getOuterType().equals(other.getOuterType())) {
                return false;
            }
            return !(this.obj == null ? other.obj != null : !this.obj.equals((Object)other.obj));
        }

        public JSONArray getChildrenJSONArray() {
            JSONArray result = new JSONArray();
            for (JSONAdapter ja : this.getSortedChildren()) {
                ja.getObj().element("computedId", (Object)((!this.isRoot ? this.getComputedId() + SuggestDirectoryEntries.this.keySeparator : "") + ja.getId()));
                ja.getObj().element("absoluteLabel", (Object)((!this.isRoot ? this.getAbsoluteLabel() + SuggestDirectoryEntries.this.absoluteLabelSeparator : "") + ja.getLabel()));
                result.add((Object)ja.toJSONObject());
            }
            return result;
        }

        public String getComputedId() {
            return this.isRoot ? null : this.obj.optString("computedId");
        }

        public String getId() {
            return this.isRoot ? null : this.obj.optString("id");
        }

        public String getLabel() {
            return this.isRoot ? null : this.obj.optString("displayLabel");
        }

        public String getAbsoluteLabel() {
            return this.isRoot ? null : this.obj.optString("absoluteLabel");
        }

        public JSONObject getObj() {
            return this.obj;
        }

        public int getOrder() {
            return this.isRoot ? -1 : this.obj.optInt("ordering");
        }

        private SuggestDirectoryEntries getOuterType() {
            return SuggestDirectoryEntries.this;
        }

        public String getParentId() {
            return this.isRoot ? null : this.obj.optString("parent");
        }

        public List<JSONAdapter> getSortedChildren() {
            if (this.children == null) {
                return null;
            }
            ArrayList<JSONAdapter> result = new ArrayList<JSONAdapter>(this.children.values());
            Collections.sort(result);
            return result;
        }

        public int hashCode() {
            int prime = 31;
            int result = 1;
            result = 31 * result + this.getOuterType().hashCode();
            result = 31 * result + (this.obj == null ? 0 : this.obj.hashCode());
            return result;
        }

        public boolean isLeaf() {
            if (this.isLeaf == null) {
                if (SuggestDirectoryEntries.this.isChained) {
                    String id = this.getId();
                    if (id != null) {
                        Map<String, String> filter = Collections.singletonMap("parent", this.getId());
                        try {
                            this.isLeaf = this.session.query(filter, Collections.emptySet(), Collections.emptyMap(), false, 1, -1).isEmpty();
                        }
                        catch (DirectoryException ce) {
                            log.error((Object)"Could not retrieve children of entry", (Throwable)ce);
                            this.isLeaf = true;
                        }
                    } else {
                        this.isLeaf = true;
                    }
                } else {
                    this.isLeaf = true;
                }
            }
            return this.isLeaf;
        }

        public boolean isObsolete() {
            return this.isRoot ? false : this.obj.optInt("obsolete") > 0;
        }

        private void mergeJsonAdapter(JSONAdapter branch) {
            JSONAdapter found = this.children.get(branch.getLabel());
            if (found != null) {
                for (JSONAdapter branchChild : branch.children.values()) {
                    found.mergeJsonAdapter(branchChild);
                }
            } else {
                this.children.put(branch.getLabel(), branch);
            }
        }

        public JSONAdapter push(JSONAdapter newEntry) throws PropertyException {
            String parentIdOfNewEntry = newEntry.getParentId();
            if (parentIdOfNewEntry != null && !parentIdOfNewEntry.isEmpty()) {
                if (parentIdOfNewEntry.equals(this.getId())) {
                    this.mergeJsonAdapter(newEntry);
                    return this;
                }
                String parentId = newEntry.getParentId();
                DocumentModel parent = this.session.getEntry(parentId);
                if (parent == null) {
                    if (log.isInfoEnabled()) {
                        log.info((Object)String.format("parent %s not found for entry %s", parentId, newEntry.getId()));
                    }
                    this.mergeJsonAdapter(newEntry);
                    return this;
                }
                return this.push(new JSONAdapter(this.session, this.schema, parent).push(newEntry));
            }
            this.mergeJsonAdapter(newEntry);
            return this;
        }

        private JSONObject toJSONObject() {
            if (this.isLeaf()) {
                return this.getObj();
            }
            if (SuggestDirectoryEntries.this.canSelectParent) {
                return this.getObj().element("children", (Collection)this.getChildrenJSONArray());
            }
            return new JSONObject().element("displayLabel", (Object)this.getLabel()).element("children", (Collection)this.getChildrenJSONArray());
        }

        public String toString() {
            return this.obj != null ? this.obj.toString() : null;
        }
    }
}

