/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.automation.core.operations.users;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import net.sf.json.JSONArray;
import net.sf.json.JSONObject;
import org.apache.commons.lang.StringUtils;
import org.nuxeo.ecm.automation.core.annotations.Context;
import org.nuxeo.ecm.automation.core.annotations.Operation;
import org.nuxeo.ecm.automation.core.annotations.OperationMethod;
import org.nuxeo.ecm.automation.core.annotations.Param;
import org.nuxeo.ecm.core.api.Blob;
import org.nuxeo.ecm.core.api.Blobs;
import org.nuxeo.ecm.core.api.DocumentModel;
import org.nuxeo.ecm.core.api.DocumentModelList;
import org.nuxeo.ecm.platform.usermanager.UserManager;

@Operation(id="User.Query", category="Users & Groups", aliases={"Services.QueryUsers"}, label="Query users", description="Query users on a combination of their username, firstName and lastName fields, or on any of them (pattern).")
public class QueryUsers {
    public static final String ID = "User.Query";
    public static final Set<String> FULLTEXT_FIELDS = new HashSet<String>(Arrays.asList("username", "firstName", "lastName"));
    public static final String JSON_USERNAME = "username";
    public static final String JSON_FIRSTNAME = "firstName";
    public static final String JSON_LASTNAME = "lastName";
    public static final String JSON_EMAIL = "email";
    public static final String JSON_COMPANY = "company";
    public static final String JSON_TENANT_ID = "tenantId";
    @Context
    protected UserManager userManager;
    @Param(name="username", required=false)
    protected String username;
    @Param(name="firstName", required=false)
    protected String firstName;
    @Param(name="lastName", required=false)
    protected String lastName;
    @Param(name="pattern", required=false)
    protected String pattern;
    @Param(name="tenantId", required=false)
    protected String tenantId;

    @OperationMethod
    public Blob run() {
        DocumentModelList users;
        if (StringUtils.isBlank((String)this.pattern)) {
            HashMap<String, String> filter = new HashMap<String, String>();
            if (StringUtils.isNotBlank((String)this.username)) {
                filter.put(JSON_USERNAME, this.username);
            }
            if (StringUtils.isNotBlank((String)this.firstName)) {
                filter.put(JSON_FIRSTNAME, this.firstName);
            }
            if (StringUtils.isNotBlank((String)this.lastName)) {
                filter.put(JSON_LASTNAME, this.lastName);
            }
            if (StringUtils.isNotBlank((String)this.tenantId)) {
                filter.put(JSON_TENANT_ID, this.tenantId);
            }
            users = this.userManager.searchUsers(filter, FULLTEXT_FIELDS);
        } else {
            users = new ArrayList();
            HashSet<String> userIds = new HashSet<String>();
            for (String field : FULLTEXT_FIELDS) {
                HashMap<String, String> filter = new HashMap<String, String>();
                filter.put(field, this.pattern);
                if (StringUtils.isNotBlank((String)this.tenantId)) {
                    filter.put(JSON_TENANT_ID, this.tenantId);
                }
                DocumentModelList userDocs = this.userManager.searchUsers(filter, Collections.singleton(field));
                for (DocumentModel userDoc : userDocs) {
                    if (!userIds.add(userDoc.getId())) continue;
                    users.add(userDoc);
                }
            }
        }
        return this.buildResponse((List<DocumentModel>)users);
    }

    protected Blob buildResponse(List<DocumentModel> users) {
        JSONArray array = new JSONArray();
        for (DocumentModel user : users) {
            JSONObject o = new JSONObject();
            o.element(JSON_USERNAME, user.getProperty("user", JSON_USERNAME));
            o.element(JSON_FIRSTNAME, user.getProperty("user", JSON_FIRSTNAME));
            o.element(JSON_LASTNAME, user.getProperty("user", JSON_LASTNAME));
            o.element(JSON_EMAIL, user.getProperty("user", JSON_EMAIL));
            o.element(JSON_COMPANY, user.getProperty("user", JSON_COMPANY));
            o.element(JSON_TENANT_ID, user.getProperty("user", JSON_TENANT_ID));
            array.add((Object)o);
        }
        JSONObject result = new JSONObject();
        result.put((Object)"users", (Object)array);
        return Blobs.createBlob((String)result.toString(), (String)"application/json");
    }
}

