/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.automation.core.operations.users;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import net.sf.json.JSONArray;
import net.sf.json.JSONObject;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuxeo.common.utils.i18n.I18NUtils;
import org.nuxeo.ecm.automation.OperationContext;
import org.nuxeo.ecm.automation.core.annotations.Context;
import org.nuxeo.ecm.automation.core.annotations.Operation;
import org.nuxeo.ecm.automation.core.annotations.OperationMethod;
import org.nuxeo.ecm.automation.core.annotations.Param;
import org.nuxeo.ecm.automation.features.SuggestConstants;
import org.nuxeo.ecm.core.api.Blob;
import org.nuxeo.ecm.core.api.Blobs;
import org.nuxeo.ecm.core.api.DocumentModel;
import org.nuxeo.ecm.core.api.DocumentModelList;
import org.nuxeo.ecm.core.schema.SchemaManager;
import org.nuxeo.ecm.core.schema.types.Field;
import org.nuxeo.ecm.core.schema.types.QName;
import org.nuxeo.ecm.core.schema.types.Schema;
import org.nuxeo.ecm.directory.Directory;
import org.nuxeo.ecm.directory.SizeLimitExceededException;
import org.nuxeo.ecm.directory.api.DirectoryService;
import org.nuxeo.ecm.platform.usermanager.UserAdapter;
import org.nuxeo.ecm.platform.usermanager.UserManager;

@Operation(id="UserGroup.Suggestion", category="Services", label="Get user/group suggestion", description="Get the user/group list of the running instance. This is returning a blob containing a serialized JSON array..", addToStudio=false)
public class SuggestUserEntries {
    private static final Log log = LogFactory.getLog(SuggestUserEntries.class);
    public static final String ID = "UserGroup.Suggestion";
    public static final String POWERUSERS = "powerusers";
    @Context
    protected OperationContext ctx;
    @Context
    protected SchemaManager schemaManager;
    @Param(name="searchTerm", alias={"prefix"}, required=false)
    protected String prefix;
    @Param(name="searchType", required=false)
    protected String searchType;
    @Param(name="groupRestriction", required=false, description="Enter the id of a group to suggest only user from this group.")
    protected String groupRestriction;
    @Param(name="hideAdminGroups", required=false, description="If set, remove all administrator groups from the suggestions")
    protected boolean hideAdminGroups;
    @Param(name="hidePowerUsersGroup", required=false, description="If set, remove power users group from the suggestions")
    protected boolean hidePowerUsersGroup;
    @Param(name="userSuggestionMaxSearchResults", required=false)
    protected Integer userSuggestionMaxSearchResults;
    @Param(name="firstLabelField", required=false)
    protected String firstLabelField;
    @Param(name="secondLabelField", required=false)
    protected String secondLabelField;
    @Param(name="thirdLabelField", required=false)
    protected String thirdLabelField;
    @Param(name="hideFirstLabel", required=false)
    protected boolean hideFirstLabel = false;
    @Param(name="hideSecondLabel", required=false)
    protected boolean hideSecondLabel = false;
    @Param(name="hideThirdLabel", required=false)
    protected boolean hideThirdLabel;
    @Param(name="displayEmailInSuggestion", required=false)
    protected boolean displayEmailInSuggestion;
    @Param(name="hideIcon", required=false)
    protected boolean hideIcon;
    @Context
    protected UserManager userManager;
    @Context
    protected DirectoryService directoryService;
    @Param(name="lang", required=false)
    protected String lang;

    @OperationMethod
    public Blob run() {
        JSONArray result = new JSONArray();
        boolean isGroupRestriction = !StringUtils.isBlank((String)this.groupRestriction);
        boolean groupOnly = false;
        boolean userOnly = isGroupRestriction;
        if (!isGroupRestriction && this.searchType != null && !this.searchType.isEmpty()) {
            if (this.searchType.equals("USER_TYPE")) {
                userOnly = true;
            } else if (this.searchType.equals("GROUP_TYPE")) {
                groupOnly = true;
            }
        }
        try {
            Serializable value;
            String key;
            QName fieldName;
            Object obj;
            Schema schema;
            DocumentModelList userList = null;
            DocumentModelList groupList = null;
            if (!groupOnly) {
                schema = this.schemaManager.getSchema(this.userManager.getUserSchemaName());
                userList = this.userManager.searchUsers(this.prefix);
                Directory userDir = this.directoryService.getDirectory(this.userManager.getUserDirectoryName());
                for (DocumentModel user : userList) {
                    obj = new JSONObject();
                    for (Field field : schema.getFields()) {
                        fieldName = field.getName();
                        key = fieldName.getLocalName();
                        value = user.getPropertyValue(fieldName.getPrefixedName());
                        if (key.equals(userDir.getPasswordField())) continue;
                        obj.element(key, (Object)value);
                    }
                    String userId = user.getId();
                    obj.put((Object)"id", (Object)userId);
                    obj.put((Object)"type", (Object)"USER_TYPE");
                    obj.put((Object)"prefixed_id", (Object)("user:" + userId));
                    SuggestConstants.computeUserLabel((JSONObject)obj, this.firstLabelField, this.secondLabelField, this.thirdLabelField, this.hideFirstLabel, this.hideSecondLabel, this.hideThirdLabel, this.displayEmailInSuggestion, userId);
                    SuggestConstants.computeUserGroupIcon((JSONObject)obj, this.hideIcon);
                    if (isGroupRestriction) {
                        user = this.userManager.getUserModel(userId);
                        UserAdapter userAdapter = (UserAdapter)user.getAdapter(UserAdapter.class);
                        List groups = userAdapter.getGroups();
                        if (groups == null || !groups.contains(this.groupRestriction)) continue;
                        result.add(obj);
                        continue;
                    }
                    result.add(obj);
                }
            }
            if (!userOnly) {
                schema = this.schemaManager.getSchema(this.userManager.getGroupSchemaName());
                groupList = this.userManager.searchGroups(this.prefix);
                List admins = new ArrayList();
                if (this.hideAdminGroups) {
                    admins = this.userManager.getAdministratorsGroups();
                }
                block4: for (DocumentModel group : groupList) {
                    Object adminGroupName2;
                    if (this.hideAdminGroups) {
                        for (Object adminGroupName2 : admins) {
                            if (!((String)adminGroupName2).equals(group.getId())) continue;
                            break block4;
                        }
                    }
                    if (this.hidePowerUsersGroup && POWERUSERS.equals(group.getId())) break;
                    obj = new JSONObject();
                    adminGroupName2 = schema.getFields().iterator();
                    while (adminGroupName2.hasNext()) {
                        Field field;
                        field = (Field)adminGroupName2.next();
                        fieldName = field.getName();
                        key = fieldName.getLocalName();
                        value = group.getPropertyValue(fieldName.getPrefixedName());
                        obj.element(key, (Object)value);
                    }
                    String groupId = group.getId();
                    obj.put((Object)"id", (Object)groupId);
                    SuggestConstants.computeGroupLabel((JSONObject)obj, groupId, this.userManager.getGroupLabelField(), this.hideFirstLabel);
                    obj.put((Object)"type", (Object)"GROUP_TYPE");
                    obj.put((Object)"prefixed_id", (Object)("group:" + groupId));
                    SuggestConstants.computeUserGroupIcon((JSONObject)obj, this.hideIcon);
                    result.add(obj);
                }
            }
            int userSize = userList != null ? userList.size() : 0;
            int groupSize = groupList != null ? groupList.size() : 0;
            int totalSize = userSize + groupSize;
            if (this.userSuggestionMaxSearchResults != null && this.userSuggestionMaxSearchResults > 0 && (userSize > this.userSuggestionMaxSearchResults || groupSize > this.userSuggestionMaxSearchResults || totalSize > this.userSuggestionMaxSearchResults)) {
                throw new SizeLimitExceededException();
            }
        }
        catch (SizeLimitExceededException e) {
            return this.searchOverflowMessage();
        }
        return Blobs.createBlob((String)result.toString(), (String)"application/json");
    }

    private Blob searchOverflowMessage() {
        JSONArray result = new JSONArray();
        JSONObject obj = new JSONObject();
        obj.put((Object)"displayLabel", (Object)I18NUtils.getMessageString((String)"messages", (String)"label.security.searchOverFlow", (Object[])new Object[0], (Locale)this.getLocale()));
        result.add((Object)obj);
        return Blobs.createBlob((String)result.toString(), (String)"application/json");
    }

    protected String getLang() {
        if (this.lang == null) {
            this.lang = (String)this.ctx.get((Object)"lang");
            if (this.lang == null) {
                this.lang = "en";
            }
        }
        return this.lang;
    }

    protected Locale getLocale() {
        return new Locale(this.getLang());
    }
}

