/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.platform.forms.layout.facelets.plugins;

import com.sun.faces.facelets.tag.ui.DecorateHandler;
import java.io.IOException;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import javax.el.ELContext;
import javax.el.ExpressionFactory;
import javax.el.ValueExpression;
import javax.faces.component.UIComponent;
import javax.faces.view.facelets.FaceletContext;
import javax.faces.view.facelets.FaceletHandler;
import javax.faces.view.facelets.Tag;
import javax.faces.view.facelets.TagAttribute;
import javax.faces.view.facelets.TagAttributes;
import javax.faces.view.facelets.TagConfig;
import javax.faces.view.facelets.TagHandler;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuxeo.ecm.platform.forms.layout.api.FieldDefinition;
import org.nuxeo.ecm.platform.forms.layout.api.Widget;
import org.nuxeo.ecm.platform.forms.layout.api.exceptions.WidgetException;
import org.nuxeo.ecm.platform.forms.layout.facelets.FaceletHandlerHelper;
import org.nuxeo.ecm.platform.forms.layout.facelets.RenderVariables;
import org.nuxeo.ecm.platform.forms.layout.facelets.ValueExpressionHelper;
import org.nuxeo.ecm.platform.forms.layout.facelets.plugins.AbstractWidgetTypeHandler;
import org.nuxeo.ecm.platform.forms.layout.service.WebLayoutManager;
import org.nuxeo.ecm.platform.ui.web.binding.MapValueExpression;
import org.nuxeo.ecm.platform.ui.web.tag.handler.TagConfigFactory;
import org.nuxeo.ecm.platform.ui.web.util.FaceletDebugTracer;
import org.nuxeo.runtime.api.Framework;

public class TemplateWidgetTypeHandler
extends AbstractWidgetTypeHandler {
    private static final Log log = LogFactory.getLog(TemplateWidgetTypeHandler.class);
    public static final String TEMPLATE_PROPERTY_NAME = "template";
    public static final String BIND_VALUE_IF_NO_FIELD_PROPERTY_NAME = "bindValueIfNoField";

    public TemplateWidgetTypeHandler(TagConfig config) {
        super(config);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void apply(FaceletContext ctx, UIComponent parent, Widget widget) throws WidgetException, IOException {
        long start = FaceletDebugTracer.start();
        try {
            String template = this.getTemplateValue(widget);
            if (template == null) {
                log.error((Object)("Missing template property for widget " + widget.getName() + " in layout " + widget.getLayoutName()));
                return;
            }
            FaceletHandlerHelper helper = new FaceletHandlerHelper(this.tagConfig);
            TagAttribute templateAttr = this.getTemplateAttribute(helper);
            if (templateAttr == null) {
                templateAttr = helper.createAttribute(TEMPLATE_PROPERTY_NAME, template);
            }
            TagAttributes attributes = FaceletHandlerHelper.getTagAttributes(templateAttr);
            String widgetTagConfigId = widget.getTagConfigId();
            TagConfig config = TagConfigFactory.createTagConfig((TagConfig)this.tagConfig, (String)widgetTagConfigId, (TagAttributes)attributes, (FaceletHandler)this.nextHandler);
            Map<String, ValueExpression> variables = this.getVariablesForRendering(ctx, helper, widget, widgetTagConfigId, template);
            ArrayList<String> blockedPatterns = new ArrayList<String>();
            blockedPatterns.add(RenderVariables.widgetVariables.field.name() + "*");
            blockedPatterns.add(RenderVariables.widgetVariables.fieldOrValue.name());
            blockedPatterns.add(RenderVariables.widgetVariables.widgetProperty.name() + "_*");
            blockedPatterns.add(RenderVariables.widgetVariables.widgetProperties.name());
            blockedPatterns.add(RenderVariables.widgetVariables.widgetControl.name() + "_*");
            DecorateHandler includeHandler = new DecorateHandler(config);
            TagHandler handler = helper.getAliasTagHandler(widgetTagConfigId, variables, blockedPatterns, (TagHandler)includeHandler);
            handler.apply(ctx, parent);
        }
        finally {
            FaceletDebugTracer.trace((long)start, (Tag)this.tagConfig.getTag(), (String)widget.getId(), (long)-1L);
        }
    }

    protected Map<String, ValueExpression> getVariablesForRendering(FaceletContext ctx, FaceletHandlerHelper helper, Widget widget, String widgetTagConfigId, String template) {
        String value;
        String name;
        String key;
        HashMap<String, ValueExpression> variables = new HashMap<String, ValueExpression>();
        ExpressionFactory eFactory = ctx.getExpressionFactory();
        FieldDefinition[] fieldDefs = widget.getFieldDefinitions();
        FieldDefinition firstField = null;
        if (fieldDefs != null && fieldDefs.length > 0) {
            for (int i = 0; i < fieldDefs.length; ++i) {
                if (i == 0) {
                    this.addFieldVariable(variables, ctx, widget, fieldDefs[i], null);
                    firstField = fieldDefs[i];
                }
                this.addFieldVariable(variables, ctx, widget, fieldDefs[i], i);
            }
        } else if (this.getBindValueIfNoFieldValue(widget)) {
            this.addFieldVariable(variables, ctx, widget, null, null);
            this.addFieldVariable(variables, ctx, widget, null, 0);
        }
        String computedValue = ValueExpressionHelper.createExpressionString(widget.getValueName(), firstField);
        variables.put(RenderVariables.widgetVariables.fieldOrValue.name(), eFactory.createValueExpression((ELContext)ctx, computedValue, Object.class));
        WebLayoutManager layoutService = (WebLayoutManager)Framework.getService(WebLayoutManager.class);
        HashMap<String, ValueExpression> mappedExpressions = new HashMap<String, ValueExpression>();
        for (Map.Entry prop : widget.getProperties().entrySet()) {
            key = (String)prop.getKey();
            name = RenderVariables.widgetVariables.widgetProperty.name() + "_" + key;
            Serializable valueInstance = (Serializable)prop.getValue();
            value = !layoutService.referencePropertyAsExpression(key, valueInstance, widget.getType(), widget.getTypeCategory(), widget.getMode(), template) ? (String)((Object)valueInstance) : "#{" + RenderVariables.widgetVariables.widget.name() + ".properties." + key + "}";
            ValueExpression ve = eFactory.createValueExpression((ELContext)ctx, value, Object.class);
            variables.put(name, ve);
            mappedExpressions.put(key, ve);
        }
        variables.put(RenderVariables.widgetVariables.widgetProperties.name(), (ValueExpression)new MapValueExpression(mappedExpressions));
        for (Map.Entry ctrl : widget.getControls().entrySet()) {
            key = (String)ctrl.getKey();
            name = RenderVariables.widgetVariables.widgetControl.name() + "_" + key;
            value = "#{" + RenderVariables.widgetVariables.widget.name() + ".controls." + key + "}";
            variables.put(name, eFactory.createValueExpression((ELContext)ctx, value, Object.class));
        }
        return variables;
    }

    protected void addFieldVariable(Map<String, ValueExpression> variables, FaceletContext ctx, Widget widget, FieldDefinition fieldDef, Integer index) {
        String computedName = index == null ? RenderVariables.widgetVariables.field.name() : RenderVariables.widgetVariables.field.name() + "_" + index;
        String computedValue = ValueExpressionHelper.createExpressionString(widget.getValueName(), fieldDef);
        ExpressionFactory eFactory = ctx.getExpressionFactory();
        variables.put(computedName, eFactory.createValueExpression((ELContext)ctx, computedValue, Object.class));
    }

    protected String getTemplateValue(Widget widget) {
        return this.lookupProperty(TEMPLATE_PROPERTY_NAME, widget);
    }

    protected String lookupProperty(String name, Widget widget) {
        String val = (String)((Object)widget.getProperty(name));
        if (val == null) {
            val = this.getProperty(name);
        }
        return val;
    }

    protected boolean getBindValueIfNoFieldValue(Widget widget) {
        Object value = this.getProperty(BIND_VALUE_IF_NO_FIELD_PROPERTY_NAME);
        if (value == null) {
            value = widget.getProperty(BIND_VALUE_IF_NO_FIELD_PROPERTY_NAME);
        }
        if (value == null) {
            return false;
        }
        if (value instanceof Boolean) {
            return Boolean.TRUE.equals(value);
        }
        return Boolean.TRUE.equals(Boolean.valueOf(value.toString()));
    }

    protected TagAttribute getTemplateAttribute(FaceletHandlerHelper helper) {
        return null;
    }
}

