/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.core.io.download;

import java.util.Arrays;

public class DownloadBlobInfo {
    protected final String repository;
    protected final String docId;
    protected final String xpath;
    protected final String filename;

    public DownloadBlobInfo(String downloadPath) {
        String[] parts = downloadPath.split("/");
        int length = parts.length;
        if (length < 2) {
            throw new IllegalArgumentException("The path \"" + downloadPath + "\" is not used to download blobs.");
        }
        this.repository = parts[0];
        this.docId = parts[1];
        if (length == 2) {
            this.xpath = "blobholder:0";
            this.filename = null;
        } else if (length == 3) {
            this.xpath = parts[2];
            this.filename = null;
        } else {
            this.xpath = String.join((CharSequence)"/", Arrays.asList(parts).subList(2, length - 1));
            this.filename = parts[length - 1];
        }
    }
}

