/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.core.io.marshallers.json;

import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.Type;
import javax.inject.Inject;
import javax.ws.rs.core.MediaType;
import org.codehaus.jackson.JsonNode;
import org.codehaus.jackson.JsonParseException;
import org.codehaus.jackson.JsonParser;
import org.codehaus.jackson.JsonProcessingException;
import org.nuxeo.ecm.core.io.marshallers.json.InputStreamWithJsonNode;
import org.nuxeo.ecm.core.io.marshallers.json.JsonFactoryProvider;
import org.nuxeo.ecm.core.io.registry.MarshallerRegistry;
import org.nuxeo.ecm.core.io.registry.Reader;
import org.nuxeo.ecm.core.io.registry.context.RenderingContext;
import org.nuxeo.ecm.core.io.registry.reflect.Supports;

@Supports(value={"application/json"})
public abstract class AbstractJsonReader<EntityType>
implements Reader<EntityType> {
    @Inject
    protected RenderingContext ctx;
    @Inject
    protected MarshallerRegistry registry;

    @Override
    public boolean accept(Class<?> clazz, Type genericType, MediaType mediatype) {
        return true;
    }

    @Override
    public EntityType read(Class<?> clazz, Type genericType, MediaType mediaType, InputStream in) throws IOException {
        JsonNode jn = this.getNode(in, true);
        return this.read(jn);
    }

    protected JsonNode getNode(InputStream in, boolean getCurrentIfAvailable) throws IOException, JsonParseException, JsonProcessingException {
        if (getCurrentIfAvailable && in instanceof InputStreamWithJsonNode) {
            return ((InputStreamWithJsonNode)in).getJsonNode();
        }
        JsonParser jp = JsonFactoryProvider.get().createJsonParser(in);
        JsonNode jn = jp.readValueAsTree();
        return jn;
    }

    public abstract EntityType read(JsonNode var1) throws IOException;

    protected <T> T readEntity(Class<?> clazz, Type genericType, JsonNode jn) throws IOException {
        Class<?> effectiveGenericType = genericType != null ? genericType : clazz;
        Reader<?> reader = this.registry.getReader(this.ctx, clazz, effectiveGenericType, MediaType.APPLICATION_JSON_TYPE);
        return (T)reader.read(clazz, effectiveGenericType, MediaType.APPLICATION_JSON_TYPE, new InputStreamWithJsonNode(jn));
    }

    protected String getStringField(JsonNode jn, String elName) {
        JsonNode elNode = jn.get(elName);
        if (elNode != null && !elNode.isNull() && elNode.isTextual()) {
            return elNode.getTextValue();
        }
        return null;
    }
}

