/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.directory;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuxeo.common.xmap.annotation.XNode;
import org.nuxeo.common.xmap.annotation.XNodeList;
import org.nuxeo.common.xmap.annotation.XObject;
import org.nuxeo.ecm.directory.Directory;
import org.nuxeo.ecm.directory.DirectoryDeleteConstraintDescriptor;
import org.nuxeo.ecm.directory.DirectoryException;
import org.nuxeo.ecm.directory.PermissionDescriptor;
import org.nuxeo.ecm.directory.api.DirectoryDeleteConstraint;

@XObject(value="directory")
public class BaseDirectoryDescriptor
implements Cloneable {
    private static final Log log = LogFactory.getLog(BaseDirectoryDescriptor.class);
    public static final boolean AUTO_INCREMENT_ID_FIELD_DEFAULT = false;
    public static final int CACHE_TIMEOUT_DEFAULT = 0;
    public static final int CACHE_MAX_SIZE_DEFAULT = 0;
    public static final boolean READ_ONLY_DEFAULT = false;
    public static final SubstringMatchType SUBSTRING_MATCH_TYPE_DEFAULT = SubstringMatchType.subinitial;
    public static final char DEFAULT_DATA_FILE_CHARACTER_SEPARATOR = ',';
    public static final String CREATE_TABLE_POLICY_NEVER = "never";
    public static final String CREATE_TABLE_POLICY_ALWAYS = "always";
    public static final String CREATE_TABLE_POLICY_ON_MISSING_COLUMNS = "on_missing_columns";
    public static final String CREATE_TABLE_POLICY_DEFAULT = "never";
    public static final List<String> CREATE_TABLE_POLICIES = Arrays.asList("never", "always", "on_missing_columns");
    @XNode(value="@name")
    public String name;
    @XNode(value="@remove")
    public boolean remove;
    @XNode(value="@template")
    public boolean template;
    @XNode(value="@extends")
    public String extendz;
    @XNode(value="parentDirectory")
    public String parentDirectory;
    @XNode(value="schema")
    public String schemaName;
    @XNode(value="idField")
    public String idField;
    @XNode(value="autoincrementIdField")
    public Boolean autoincrementIdField;
    @XNode(value="table")
    public String tableName;
    @XNode(value="readOnly")
    public Boolean readOnly;
    @XNode(value="passwordField")
    public String passwordField;
    @XNode(value="passwordHashAlgorithm")
    public String passwordHashAlgorithm;
    @XNodeList(value="permissions/permission", type=PermissionDescriptor[].class, componentType=PermissionDescriptor.class)
    public PermissionDescriptor[] permissions;
    @XNode(value="cacheTimeout")
    public Integer cacheTimeout;
    @XNode(value="cacheMaxSize")
    public Integer cacheMaxSize;
    @XNode(value="cacheEntryName")
    public String cacheEntryName;
    @XNode(value="cacheEntryWithoutReferencesName")
    public String cacheEntryWithoutReferencesName;
    @XNode(value="negativeCaching")
    public Boolean negativeCaching;
    @XNode(value="substringMatchType")
    public String substringMatchType;
    @XNodeList(value="types/type", type=String[].class, componentType=String.class)
    public String[] types;
    @XNodeList(value="deleteConstraint", type=ArrayList.class, componentType=DirectoryDeleteConstraintDescriptor.class)
    List<DirectoryDeleteConstraintDescriptor> deleteConstraints;
    @XNode(value="dataFile")
    public String dataFileName;
    @XNode(value="dataFileCharacterSeparator", trim=false)
    public String dataFileCharacterSeparator = ",";
    @XNode(value="createTablePolicy")
    public String createTablePolicy;

    public boolean isAutoincrementIdField() {
        return this.autoincrementIdField == null ? false : this.autoincrementIdField;
    }

    public void setAutoincrementIdField(boolean autoincrementIdField) {
        this.autoincrementIdField = autoincrementIdField;
    }

    public String getDataFileName() {
        return this.dataFileName;
    }

    public char getDataFileCharacterSeparator() {
        char sep;
        if (StringUtils.isEmpty((String)this.dataFileCharacterSeparator)) {
            sep = ',';
        } else {
            sep = this.dataFileCharacterSeparator.charAt(0);
            if (this.dataFileCharacterSeparator.length() > 1) {
                log.warn((Object)("More than one character found for character separator, will use the first one \"" + sep + "\""));
            }
        }
        return sep;
    }

    public String getCreateTablePolicy() {
        if (StringUtils.isBlank((String)this.createTablePolicy)) {
            return "never";
        }
        String ctp = this.createTablePolicy.toLowerCase();
        if (!CREATE_TABLE_POLICIES.contains(ctp)) {
            throw new DirectoryException("Invalid createTablePolicy: " + this.createTablePolicy + ", it should be one of: " + CREATE_TABLE_POLICIES);
        }
        return ctp;
    }

    public boolean isReadOnly() {
        return this.readOnly == null ? false : this.readOnly;
    }

    public void setReadOnly(boolean readOnly) {
        this.readOnly = readOnly;
    }

    public int getCacheTimeout() {
        return this.cacheTimeout == null ? 0 : this.cacheTimeout;
    }

    public int getCacheMaxSize() {
        return this.cacheMaxSize == null ? 0 : this.cacheMaxSize;
    }

    public SubstringMatchType getSubstringMatchType() {
        if (StringUtils.isBlank((String)this.substringMatchType)) {
            return SUBSTRING_MATCH_TYPE_DEFAULT;
        }
        try {
            return SubstringMatchType.valueOf(this.substringMatchType);
        }
        catch (IllegalArgumentException e) {
            log.error((Object)("Unknown value for <substringMatchType>: " + this.substringMatchType));
            return SUBSTRING_MATCH_TYPE_DEFAULT;
        }
    }

    public BaseDirectoryDescriptor clone() {
        BaseDirectoryDescriptor clone;
        try {
            clone = (BaseDirectoryDescriptor)super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new AssertionError((Object)e);
        }
        if (this.permissions != null) {
            clone.permissions = new PermissionDescriptor[this.permissions.length];
            for (int i = 0; i < this.permissions.length; ++i) {
                clone.permissions[i] = this.permissions[i].clone();
            }
        }
        return clone;
    }

    public void merge(BaseDirectoryDescriptor other) {
        boolean bl = this.template = this.template || other.template;
        if (other.parentDirectory != null) {
            this.parentDirectory = other.parentDirectory;
        }
        if (other.schemaName != null) {
            this.schemaName = other.schemaName;
        }
        if (other.idField != null) {
            this.idField = other.idField;
        }
        if (other.autoincrementIdField != null) {
            this.autoincrementIdField = other.autoincrementIdField;
        }
        if (other.tableName != null) {
            this.tableName = other.tableName;
        }
        if (other.readOnly != null) {
            this.readOnly = other.readOnly;
        }
        if (other.passwordField != null) {
            this.passwordField = other.passwordField;
        }
        if (other.passwordHashAlgorithm != null) {
            this.passwordHashAlgorithm = other.passwordHashAlgorithm;
        }
        if (other.permissions != null && other.permissions.length != 0) {
            this.permissions = other.permissions;
        }
        if (other.cacheTimeout != null) {
            this.cacheTimeout = other.cacheTimeout;
        }
        if (other.cacheMaxSize != null) {
            this.cacheMaxSize = other.cacheMaxSize;
        }
        if (other.cacheEntryName != null) {
            this.cacheEntryName = other.cacheEntryName;
        }
        if (other.cacheEntryWithoutReferencesName != null) {
            this.cacheEntryWithoutReferencesName = other.cacheEntryWithoutReferencesName;
        }
        if (other.negativeCaching != null) {
            this.negativeCaching = other.negativeCaching;
        }
        if (other.substringMatchType != null) {
            this.substringMatchType = other.substringMatchType;
        }
        if (other.types != null) {
            this.types = other.types;
        }
        if (other.deleteConstraints != null) {
            this.deleteConstraints = other.deleteConstraints;
        }
        if (other.dataFileName != null) {
            this.dataFileName = other.dataFileName;
        }
        if (other.dataFileCharacterSeparator != null) {
            this.dataFileCharacterSeparator = other.dataFileCharacterSeparator;
        }
        if (other.createTablePolicy != null) {
            this.createTablePolicy = other.createTablePolicy;
        }
    }

    public Directory newDirectory() {
        throw new UnsupportedOperationException("Cannot be instantiated as Directory: " + this.getClass().getName());
    }

    public List<DirectoryDeleteConstraint> getDeleteConstraints() throws DirectoryException {
        ArrayList<DirectoryDeleteConstraint> res = new ArrayList<DirectoryDeleteConstraint>();
        if (this.deleteConstraints != null) {
            for (DirectoryDeleteConstraintDescriptor deleteConstraintDescriptor : this.deleteConstraints) {
                res.add(deleteConstraintDescriptor.getDeleteConstraint());
            }
        }
        return res;
    }

    public static enum SubstringMatchType {
        subinitial,
        subfinal,
        subany;

    }
}

