/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.directory;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuxeo.ecm.core.api.DataModel;
import org.nuxeo.ecm.core.api.DocumentModel;
import org.nuxeo.ecm.core.api.DocumentModelList;
import org.nuxeo.ecm.core.api.NuxeoPrincipal;
import org.nuxeo.ecm.core.api.PropertyException;
import org.nuxeo.ecm.core.api.impl.DataModelImpl;
import org.nuxeo.ecm.core.api.impl.DocumentModelImpl;
import org.nuxeo.ecm.core.api.impl.DocumentModelListImpl;
import org.nuxeo.ecm.core.api.local.ClientLoginModule;
import org.nuxeo.ecm.directory.Directory;
import org.nuxeo.ecm.directory.DirectoryDeleteConstraintException;
import org.nuxeo.ecm.directory.DirectoryException;
import org.nuxeo.ecm.directory.DirectorySecurityException;
import org.nuxeo.ecm.directory.PermissionDescriptor;
import org.nuxeo.ecm.directory.Session;
import org.nuxeo.ecm.directory.api.DirectoryDeleteConstraint;
import org.nuxeo.ecm.directory.api.DirectoryService;
import org.nuxeo.runtime.api.Framework;

public abstract class BaseSession
implements Session {
    protected static final String POWER_USERS_GROUP = "powerusers";
    protected static final String READONLY_ENTRY_FLAG = "READONLY_ENTRY";
    protected static final String MULTI_TENANT_ID_FORMAT = "tenant_%s_%s";
    private static final Log log = LogFactory.getLog(BaseSession.class);
    protected final Directory directory;
    protected PermissionDescriptor[] permissions = null;
    protected boolean readAllColumns;

    protected BaseSession(Directory directory) {
        this.directory = directory;
    }

    public abstract Directory getDirectory();

    @Override
    public void setReadAllColumns(boolean readAllColumns) {
        this.readAllColumns = readAllColumns;
    }

    @Override
    public String getIdField() {
        return this.directory.getIdField();
    }

    @Override
    public String getPasswordField() {
        return this.directory.getPasswordField();
    }

    @Override
    public boolean isAuthenticating() {
        return this.directory.getPasswordField() != null;
    }

    @Override
    public boolean isReadOnly() {
        return this.directory.isReadOnly();
    }

    public void checkPermission(String permission) {
        if (this.hasPermission(permission)) {
            return;
        }
        if (permission.equals("Write") && this.isReadOnly()) {
            throw new DirectorySecurityException("Directory is read-only");
        }
        NuxeoPrincipal user = ClientLoginModule.getCurrentPrincipal();
        throw new DirectorySecurityException("User " + user + " does not have " + permission + " permission");
    }

    public void checkDeleteConstraints(String entryId) {
        List<DirectoryDeleteConstraint> deleteConstraints = this.directory.getDirectoryDeleteConstraints();
        DirectoryService directoryService = (DirectoryService)Framework.getLocalService(DirectoryService.class);
        if (deleteConstraints != null && !deleteConstraints.isEmpty()) {
            for (DirectoryDeleteConstraint deleteConstraint : deleteConstraints) {
                if (deleteConstraint.canDelete(directoryService, entryId)) continue;
                throw new DirectoryDeleteConstraintException("This entry is referenced in another vocabulary.");
            }
        }
    }

    public boolean hasPermission(String permission) {
        if (permission.equals("Write") && this.isReadOnly()) {
            if (log.isTraceEnabled()) {
                log.trace((Object)"Directory is read-only");
            }
            return false;
        }
        NuxeoPrincipal user = ClientLoginModule.getCurrentPrincipal();
        if (user == null) {
            return true;
        }
        String username = user.getName();
        if (username.equals("system")) {
            return true;
        }
        if (this.permissions == null || this.permissions.length == 0) {
            if (user.isAdministrator()) {
                return true;
            }
            if (user.isMemberOf(POWER_USERS_GROUP)) {
                return true;
            }
            if (permission.equals("Read")) {
                return true;
            }
            if (log.isTraceEnabled()) {
                log.trace((Object)("User " + user + " does not have " + permission + " permission"));
            }
            return false;
        }
        ArrayList<String> groups = new ArrayList<String>(user.getAllGroups());
        groups.add("Everyone");
        boolean allowed = this.hasPermission(permission, username, groups);
        if (!allowed && permission.equals("Read")) {
            allowed = this.hasPermission("Write", username, groups);
        }
        if (!allowed && log.isTraceEnabled()) {
            log.trace((Object)("User " + user + " does not have " + permission + " permission"));
        }
        return allowed;
    }

    protected boolean hasPermission(String permission, String username, List<String> groups) {
        for (PermissionDescriptor desc : this.permissions) {
            if (!desc.name.equals(permission)) continue;
            if (desc.groups != null) {
                for (String group : desc.groups) {
                    if (!groups.contains(group)) continue;
                    return true;
                }
            }
            if (desc.users == null) continue;
            for (String user : desc.users) {
                if (!user.equals(username)) continue;
                return true;
            }
        }
        return false;
    }

    public static DocumentModel createEntryModel(String sessionId, String schema, String id, Map<String, Object> values) throws PropertyException {
        DocumentModelImpl entry = new DocumentModelImpl(sessionId, schema, id, null, null, null, null, new String[]{schema}, new HashSet(), null, null);
        if (values == null) {
            values = Collections.emptyMap();
        }
        DataModelImpl dataModel = new DataModelImpl(schema, values);
        entry.addDataModel((DataModel)dataModel);
        return entry;
    }

    public static DocumentModel createEntryModel(String sessionId, String schema, String id, Map<String, Object> values, boolean readOnly) throws PropertyException {
        DocumentModel entry = BaseSession.createEntryModel(sessionId, schema, id, values);
        if (readOnly) {
            BaseSession.setReadOnlyEntry(entry);
        }
        return entry;
    }

    protected static Map<String, Serializable> mkSerializableMap(Map<String, Object> map) {
        HashMap<String, Serializable> serializableMap = null;
        if (map != null) {
            serializableMap = new HashMap<String, Serializable>();
            for (String key : map.keySet()) {
                serializableMap.put(key, (Serializable)map.get(key));
            }
        }
        return serializableMap;
    }

    protected static Map<String, Object> mkObjectMap(Map<String, Serializable> map) {
        HashMap<String, Serializable> objectMap = null;
        if (map != null) {
            objectMap = new HashMap<String, Serializable>();
            for (String key : map.keySet()) {
                objectMap.put(key, map.get(key));
            }
        }
        return objectMap;
    }

    public static boolean isReadOnlyEntry(DocumentModel entry) {
        return entry.getContextData(READONLY_ENTRY_FLAG) == Boolean.TRUE;
    }

    public static void setReadOnlyEntry(DocumentModel entry) {
        entry.putContextData(READONLY_ENTRY_FLAG, (Serializable)Boolean.TRUE);
    }

    public static void setReadWriteEntry(DocumentModel entry) {
        entry.putContextData(READONLY_ENTRY_FLAG, (Serializable)Boolean.FALSE);
    }

    public static String computeMultiTenantDirectoryId(String tenantId, String id) {
        return String.format(MULTI_TENANT_ID_FORMAT, tenantId, id);
    }

    @Override
    public DocumentModelList query(Map<String, Serializable> filter, Set<String> fulltext, Map<String, String> orderBy, boolean fetchReferences, int limit, int offset) throws DirectoryException {
        log.info((Object)"Call an unoverrided query with offset and limit.");
        DocumentModelList entries = this.query(filter, fulltext, orderBy, fetchReferences);
        int toIndex = offset + limit;
        if (toIndex > entries.size()) {
            toIndex = entries.size();
        }
        return new DocumentModelListImpl(entries.subList(offset, toIndex));
    }
}

