/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.platform.web.common.exceptionhandling;

import java.io.IOException;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.security.Principal;
import java.util.HashMap;
import java.util.Locale;
import java.util.ResourceBundle;
import javax.servlet.RequestDispatcher;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuxeo.common.utils.URIUtils;
import org.nuxeo.common.utils.i18n.I18NUtils;
import org.nuxeo.ecm.core.api.NuxeoException;
import org.nuxeo.ecm.core.api.NuxeoPrincipal;
import org.nuxeo.ecm.core.api.WrappedException;
import org.nuxeo.ecm.platform.ui.web.auth.NuxeoAuthenticationFilter;
import org.nuxeo.ecm.platform.ui.web.auth.service.PluggableAuthenticationService;
import org.nuxeo.ecm.platform.web.common.exceptionhandling.ExceptionHelper;
import org.nuxeo.ecm.platform.web.common.exceptionhandling.NuxeoExceptionHandler;
import org.nuxeo.ecm.platform.web.common.exceptionhandling.NuxeoExceptionHandlerParameters;
import org.nuxeo.ecm.platform.web.common.exceptionhandling.descriptor.ErrorHandler;
import org.nuxeo.runtime.api.Framework;

public class DefaultNuxeoExceptionHandler
implements NuxeoExceptionHandler {
    private static final Log log = LogFactory.getLog(DefaultNuxeoExceptionHandler.class);
    protected NuxeoExceptionHandlerParameters parameters;

    @Override
    public void setParameters(NuxeoExceptionHandlerParameters parameters) {
        this.parameters = parameters;
    }

    protected void startHandlingException(HttpServletRequest request, HttpServletResponse response, Throwable t) throws ServletException {
        if (request.getAttribute("NuxeoExceptionHandlerMarker") == null) {
            if (log.isDebugEnabled()) {
                log.debug((Object)"Initial exception", t);
            }
        } else {
            throw new ServletException(t);
        }
        request.setAttribute("NuxeoExceptionHandlerMarker", (Object)true);
        request.setAttribute("nuxeo.disable.redirect.wrapper", (Object)true);
    }

    @Override
    public void handleException(HttpServletRequest request, HttpServletResponse response, Throwable t) throws IOException, ServletException {
        NuxeoPrincipal nuxeoPrincipal;
        Principal principal;
        Throwable unwrappedException = ExceptionHelper.unwrapException(t);
        if (ExceptionHelper.isSecurityError(unwrappedException) && (principal = request.getUserPrincipal()) instanceof NuxeoPrincipal && (nuxeoPrincipal = (NuxeoPrincipal)principal).isAnonymous() && this.handleAnonymousException(request, response)) {
            return;
        }
        this.startHandlingException(request, response, t);
        try {
            ErrorHandler handler = this.getHandler(t);
            Integer code = handler.getCode();
            int status = code == null ? 500 : code;
            this.parameters.getListener().startHandling(t, request, response);
            StringWriter swriter = new StringWriter();
            PrintWriter pwriter = new PrintWriter(swriter);
            t.printStackTrace(pwriter);
            String stackTrace = swriter.getBuffer().toString();
            if (status < 500) {
                log.debug((Object)t.getMessage(), t);
            } else {
                log.error((Object)stackTrace);
                this.parameters.getLogger().error((Object)stackTrace);
            }
            this.parameters.getListener().beforeSetErrorPageAttribute(unwrappedException, request, response);
            request.setAttribute("exception_message", (Object)unwrappedException.getLocalizedMessage());
            request.setAttribute("user_message", this.getUserMessage(handler.getMessage(), request.getLocale()));
            request.setAttribute("securityError", (Object)ExceptionHelper.isSecurityError(unwrappedException));
            request.setAttribute("messageBundle", (Object)ResourceBundle.getBundle(this.parameters.getBundleName(), request.getLocale(), Thread.currentThread().getContextClassLoader()));
            String dumpedRequest = this.parameters.getRequestDumper().getDump(request);
            if (status >= 500) {
                this.parameters.getLogger().error((Object)dumpedRequest);
            }
            request.setAttribute("isDevModeSet", (Object)Framework.isDevModeSet());
            if (Framework.isDevModeSet()) {
                request.setAttribute("stackTrace", (Object)stackTrace);
                request.setAttribute("request_dump", (Object)dumpedRequest);
            }
            this.parameters.getListener().beforeForwardToErrorPage(unwrappedException, request, response);
            if (!response.isCommitted()) {
                response.reset();
                response.setStatus(status);
                String errorPage = handler.getPage();
                errorPage = errorPage == null ? this.parameters.getDefaultErrorPage() : errorPage;
                RequestDispatcher requestDispatcher = request.getRequestDispatcher(errorPage);
                if (requestDispatcher != null) {
                    requestDispatcher.forward((ServletRequest)request, (ServletResponse)response);
                } else {
                    log.error((Object)("Cannot forward to error page, no RequestDispatcher found for errorPage=" + errorPage + " handler=" + handler));
                }
                this.parameters.getListener().responseComplete();
            } else {
                log.error((Object)"Cannot forward to error page: response is already committed");
            }
            this.parameters.getListener().afterDispatch(unwrappedException, request, response);
        }
        catch (ServletException e) {
            throw e;
        }
        catch (IOException | RuntimeException e) {
            throw new ServletException((Throwable)e);
        }
    }

    @Override
    public boolean handleAnonymousException(HttpServletRequest request, HttpServletResponse response) throws IOException, ServletException {
        PluggableAuthenticationService authService = (PluggableAuthenticationService)((Object)Framework.getRuntime().getComponent("org.nuxeo.ecm.platform.ui.web.auth.service.PluggableAuthenticationService"));
        if (authService == null) {
            return false;
        }
        authService.invalidateSession((ServletRequest)request);
        String loginURL = this.getLoginURL(request);
        if (loginURL == null) {
            return false;
        }
        if (!response.isCommitted()) {
            request.setAttribute("nuxeo.disable.redirect.wrapper", (Object)true);
            response.sendRedirect(loginURL);
            this.parameters.getListener().responseComplete();
        } else {
            log.error((Object)"Cannot redirect to login page: response is already committed");
        }
        return true;
    }

    @Override
    public String getLoginURL(HttpServletRequest request) {
        PluggableAuthenticationService authService = (PluggableAuthenticationService)((Object)Framework.getRuntime().getComponent("org.nuxeo.ecm.platform.ui.web.auth.service.PluggableAuthenticationService"));
        HashMap<String, String> urlParameters = new HashMap<String, String>();
        urlParameters.put("securityError", "true");
        urlParameters.put("forceAnonymousLogin", "true");
        if (request.getAttribute("requestedUrl") != null) {
            urlParameters.put("requestedUrl", (String)request.getAttribute("requestedUrl"));
        } else {
            urlParameters.put("requestedUrl", NuxeoAuthenticationFilter.getRequestedUrl(request));
        }
        String baseURL = authService.getBaseURL((ServletRequest)request) + "logout";
        return URIUtils.addParametersToURIQuery((String)baseURL, urlParameters);
    }

    protected ErrorHandler getHandler(Throwable t) {
        Throwable throwable = ExceptionHelper.unwrapException(t);
        String className = null;
        if (throwable instanceof WrappedException) {
            WrappedException wrappedException = (WrappedException)throwable;
            className = wrappedException.getClassName();
        } else {
            className = throwable.getClass().getName();
        }
        for (ErrorHandler handler : this.parameters.getHandlers()) {
            if (handler.getError() == null || !className.matches(handler.getError())) continue;
            return handler;
        }
        throw new NuxeoException("No error handler set.");
    }

    protected Object getUserMessage(String messageKey, Locale locale) {
        return I18NUtils.getMessageString((String)this.parameters.getBundleName(), (String)messageKey, null, (Locale)locale);
    }
}

