/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.platform.ec.notification;

import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuxeo.ecm.core.api.DocumentModel;
import org.nuxeo.ecm.core.api.DocumentRef;
import org.nuxeo.ecm.core.api.IdRef;
import org.nuxeo.ecm.core.event.Event;
import org.nuxeo.ecm.core.event.EventContext;
import org.nuxeo.ecm.core.event.EventListener;
import org.nuxeo.ecm.core.event.impl.DocumentEventContext;
import org.nuxeo.ecm.platform.ec.notification.SubscriptionAdapter;
import org.nuxeo.ecm.platform.ec.notification.service.NotificationService;
import org.nuxeo.ecm.platform.ec.notification.service.NotificationServiceHelper;

public class ProxySubscriptionPropagationListener
implements EventListener {
    private static final Log log = LogFactory.getLog(ProxySubscriptionPropagationListener.class);

    public void handleEvent(Event event) {
        EventContext ctx = event.getContext();
        if (!(ctx instanceof DocumentEventContext)) {
            return;
        }
        DocumentEventContext docCtx = (DocumentEventContext)ctx;
        DocumentModel publishedDoc = docCtx.getSourceDocument();
        if (!publishedDoc.isProxy()) {
            return;
        }
        NotificationService service = NotificationServiceHelper.getNotificationService();
        if (service == null) {
            log.error((Object)"Unable to get NotificationService, exiting");
            return;
        }
        List replacedProxyIds = (List)ctx.getProperties().get("replacedProxyRefs");
        if (replacedProxyIds == null) {
            return;
        }
        for (String replacedProxyId : replacedProxyIds) {
            DocumentModel fromDoc = ctx.getCoreSession().getDocument((DocumentRef)new IdRef(replacedProxyId));
            ((SubscriptionAdapter)fromDoc.getAdapter(SubscriptionAdapter.class)).copySubscriptionsTo(publishedDoc);
        }
        ctx.getCoreSession().saveDocument(publishedDoc);
    }
}

