/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.core.blob;

import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import java.util.Collections;
import java.util.Deque;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuxeo.ecm.core.api.Blob;
import org.nuxeo.ecm.core.api.DocumentModel;
import org.nuxeo.ecm.core.api.NuxeoException;
import org.nuxeo.ecm.core.blob.BlobDispatcher;
import org.nuxeo.ecm.core.blob.BlobDispatcherDescriptor;
import org.nuxeo.ecm.core.blob.BlobManager;
import org.nuxeo.ecm.core.blob.BlobProvider;
import org.nuxeo.ecm.core.blob.BlobProviderDescriptor;
import org.nuxeo.ecm.core.blob.DefaultBlobDispatcher;
import org.nuxeo.ecm.core.blob.ManagedBlob;
import org.nuxeo.ecm.core.blob.binary.BinaryBlobProvider;
import org.nuxeo.ecm.core.blob.binary.BinaryGarbageCollector;
import org.nuxeo.ecm.core.blob.binary.BinaryManager;
import org.nuxeo.ecm.core.blob.binary.BinaryManagerStatus;
import org.nuxeo.ecm.core.model.Document;
import org.nuxeo.ecm.core.model.Repository;
import org.nuxeo.ecm.core.repository.RepositoryService;
import org.nuxeo.runtime.api.Framework;
import org.nuxeo.runtime.model.ComponentContext;
import org.nuxeo.runtime.model.ComponentInstance;
import org.nuxeo.runtime.model.DefaultComponent;
import org.nuxeo.runtime.model.SimpleContributionRegistry;

public class BlobManagerComponent
extends DefaultComponent
implements BlobManager {
    private static final Log log = LogFactory.getLog(BlobManagerComponent.class);
    protected static final String XP = "configuration";
    protected static BlobDispatcher DEFAULT_BLOB_DISPATCHER = new DefaultBlobDispatcher();
    protected Deque<BlobDispatcherDescriptor> blobDispatcherDescriptorsRegistry = new LinkedList<BlobDispatcherDescriptor>();
    protected BlobProviderDescriptorRegistry blobProviderDescriptorsRegistry = new BlobProviderDescriptorRegistry();
    protected Map<String, BlobProvider> blobProviders = new HashMap<String, BlobProvider>();

    public void deactivate(ComponentContext context) {
        this.blobDispatcherDescriptorsRegistry.clear();
        this.blobProviderDescriptorsRegistry.clear();
        for (BlobProvider blobProvider : this.blobProviders.values()) {
            blobProvider.close();
        }
        this.blobProviders.clear();
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void registerContribution(Object contribution, String extensionPoint, ComponentInstance contributor) {
        if (!XP.equals(extensionPoint)) throw new NuxeoException("Invalid extension point: " + extensionPoint);
        if (contribution instanceof BlobDispatcherDescriptor) {
            this.registerBlobDispatcher((BlobDispatcherDescriptor)contribution);
            return;
        } else {
            if (!(contribution instanceof BlobProviderDescriptor)) throw new NuxeoException("Invalid descriptor: " + contribution.getClass());
            this.registerBlobProvider((BlobProviderDescriptor)contribution);
        }
    }

    public void unregisterContribution(Object contribution, String extensionPoint, ComponentInstance contributor) {
        if (XP.equals(extensionPoint)) {
            if (contribution instanceof BlobDispatcherDescriptor) {
                this.unregisterBlobDispatcher((BlobDispatcherDescriptor)contribution);
            } else if (contribution instanceof BlobProviderDescriptor) {
                this.unregisterBlobProvider((BlobProviderDescriptor)contribution);
            }
        }
    }

    protected void registerBlobDispatcher(BlobDispatcherDescriptor descr) {
        this.blobDispatcherDescriptorsRegistry.add(descr);
    }

    protected void unregisterBlobDispatcher(BlobDispatcherDescriptor descr) {
        this.blobDispatcherDescriptorsRegistry.remove(descr);
    }

    protected BlobDispatcher getBlobDispatcher() {
        BlobDispatcherDescriptor descr = this.blobDispatcherDescriptorsRegistry.peekLast();
        if (descr == null) {
            return DEFAULT_BLOB_DISPATCHER;
        }
        return descr.getBlobDispatcher();
    }

    public void registerBlobProvider(BlobProviderDescriptor descr) {
        this.closeOldBlobProvider(descr.name);
        this.blobProviderDescriptorsRegistry.addContribution(descr);
        this.getBlobProvider(descr.name);
    }

    public void unregisterBlobProvider(BlobProviderDescriptor descr) {
        this.closeOldBlobProvider(descr.name);
        this.blobProviderDescriptorsRegistry.removeContribution(descr);
    }

    protected synchronized void closeOldBlobProvider(String id) {
        BlobProvider blobProvider = this.blobProviders.remove(id);
        if (blobProvider != null) {
            blobProvider.close();
        }
    }

    @Override
    public synchronized BlobProvider getBlobProvider(String providerId) {
        BlobProvider blobProvider = this.blobProviders.get(providerId);
        if (blobProvider == null) {
            Map<String, String> properties;
            block8: {
                BlobProviderDescriptor descr = this.blobProviderDescriptorsRegistry.getBlobProviderDescriptor(providerId);
                if (descr == null) {
                    return null;
                }
                Class<?> klass = descr.klass;
                properties = descr.properties;
                try {
                    if (BlobProvider.class.isAssignableFrom(klass)) {
                        Class<?> blobProviderClass = klass;
                        blobProvider = (BlobProvider)blobProviderClass.newInstance();
                        break block8;
                    }
                    if (BinaryManager.class.isAssignableFrom(klass)) {
                        Class<?> binaryManagerClass = klass;
                        BinaryManager binaryManager = (BinaryManager)binaryManagerClass.newInstance();
                        blobProvider = new BinaryBlobProvider(binaryManager);
                        break block8;
                    }
                    throw new RuntimeException("Unknown class for blob provider: " + klass);
                }
                catch (ReflectiveOperationException e) {
                    throw new RuntimeException(e);
                }
            }
            try {
                blobProvider.initialize(providerId, properties);
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
            this.blobProviders.put(providerId, blobProvider);
        }
        return blobProvider;
    }

    @Override
    public Blob readBlob(BlobManager.BlobInfo blobInfo, String repositoryName) throws IOException {
        String key = blobInfo.key;
        if (key == null) {
            return null;
        }
        BlobProvider blobProvider = this.getBlobProvider(key, repositoryName);
        if (blobProvider == null) {
            throw new NuxeoException("No registered blob provider for key: " + key);
        }
        return blobProvider.readBlob(blobInfo);
    }

    protected BlobProvider getBlobProvider(String key, String repositoryName) {
        int colon = key.indexOf(58);
        String providerId = colon < 0 ? this.getBlobDispatcher().getBlobProvider(repositoryName) : key.substring(0, colon);
        return this.getBlobProvider(providerId);
    }

    @Override
    public String writeBlob(Blob blob, Document doc, String xpath) throws IOException {
        BlobProvider blobProvider;
        BlobDispatcher blobDispatcher = this.getBlobDispatcher();
        BlobDispatcher.BlobDispatch dispatch = null;
        if (blob instanceof ManagedBlob) {
            ManagedBlob managedBlob = (ManagedBlob)blob;
            String currentProviderId = managedBlob.getProviderId();
            if (!blobDispatcher.getBlobProviderIds().contains(currentProviderId)) {
                return managedBlob.getKey();
            }
            dispatch = blobDispatcher.getBlobProvider(doc, blob, xpath);
            if (dispatch.providerId.equals(currentProviderId)) {
                return managedBlob.getKey();
            }
        }
        if (dispatch == null) {
            dispatch = blobDispatcher.getBlobProvider(doc, blob, xpath);
        }
        if ((blobProvider = this.getBlobProvider(dispatch.providerId)) == null) {
            throw new NuxeoException("No registered blob provider with id: " + dispatch.providerId);
        }
        String key = blobProvider.writeBlob(blob, doc);
        if (dispatch.addPrefix) {
            key = dispatch.providerId + ':' + key;
        }
        return key;
    }

    @Override
    public BlobProvider getBlobProvider(Blob blob) {
        if (!(blob instanceof ManagedBlob)) {
            return null;
        }
        ManagedBlob managedBlob = (ManagedBlob)blob;
        return this.getBlobProvider(managedBlob.getProviderId());
    }

    @Override
    public InputStream getStream(Blob blob) throws IOException {
        BlobProvider blobProvider = this.getBlobProvider(blob);
        if (blobProvider == null) {
            return null;
        }
        return blobProvider.getStream((ManagedBlob)blob);
    }

    @Override
    public InputStream getThumbnail(Blob blob) throws IOException {
        BlobProvider blobProvider = this.getBlobProvider(blob);
        if (blobProvider == null) {
            return null;
        }
        return blobProvider.getThumbnail((ManagedBlob)blob);
    }

    @Override
    public URI getURI(Blob blob, BlobManager.UsageHint hint, HttpServletRequest servletRequest) throws IOException {
        BlobProvider blobProvider = this.getBlobProvider(blob);
        if (blobProvider == null) {
            return null;
        }
        return blobProvider.getURI((ManagedBlob)blob, hint, servletRequest);
    }

    @Override
    public Map<String, URI> getAvailableConversions(Blob blob, BlobManager.UsageHint hint) throws IOException {
        BlobProvider blobProvider = this.getBlobProvider(blob);
        if (blobProvider == null) {
            return Collections.emptyMap();
        }
        return blobProvider.getAvailableConversions((ManagedBlob)blob, hint);
    }

    @Override
    public InputStream getConvertedStream(Blob blob, String mimeType, DocumentModel doc) throws IOException {
        BlobProvider blobProvider = this.getBlobProvider(blob);
        if (blobProvider == null) {
            return null;
        }
        return blobProvider.getConvertedStream((ManagedBlob)blob, mimeType, doc);
    }

    protected void freezeVersion(Document.BlobAccessor accessor, Document doc) {
        Blob blob = accessor.getBlob();
        BlobProvider blobProvider = this.getBlobProvider(blob);
        if (blobProvider == null) {
            return;
        }
        try {
            ManagedBlob newBlob = blobProvider.freezeVersion((ManagedBlob)blob, doc);
            if (newBlob != null) {
                accessor.setBlob(newBlob);
            }
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public Map<String, BlobProvider> getBlobProviders() {
        return this.blobProviders;
    }

    @Override
    public void freezeVersion(Document doc) {
        doc.visitBlobs(accessor -> this.freezeVersion((Document.BlobAccessor)accessor, doc));
    }

    @Override
    public void notifyChanges(Document doc, Set<String> xpaths) {
        this.getBlobDispatcher().notifyChanges(doc, xpaths);
    }

    protected List<BinaryGarbageCollector> getGarbageCollectors() {
        LinkedList<BinaryGarbageCollector> gcs = new LinkedList<BinaryGarbageCollector>();
        for (String providerId : this.getBlobDispatcher().getBlobProviderIds()) {
            BlobProvider blobProvider = this.getBlobProvider(providerId);
            BinaryManager binaryManager = blobProvider.getBinaryManager();
            if (binaryManager == null) continue;
            gcs.add(binaryManager.getGarbageCollector());
        }
        return gcs;
    }

    @Override
    public BinaryManagerStatus garbageCollectBinaries(boolean delete) {
        List<BinaryGarbageCollector> gcs = this.getGarbageCollectors();
        long start = System.currentTimeMillis();
        for (BinaryGarbageCollector binaryGarbageCollector : gcs) {
            binaryGarbageCollector.start();
        }
        RepositoryService repositoryService = (RepositoryService)((Object)Framework.getService(RepositoryService.class));
        for (String repositoryName : repositoryService.getRepositoryNames()) {
            Repository repository = repositoryService.getRepository(repositoryName);
            repository.markReferencedBinaries();
        }
        BinaryManagerStatus binaryManagerStatus = new BinaryManagerStatus();
        for (BinaryGarbageCollector gc : gcs) {
            gc.stop(delete);
            BinaryManagerStatus status = gc.getStatus();
            binaryManagerStatus.numBinaries += status.numBinaries;
            binaryManagerStatus.sizeBinaries += status.sizeBinaries;
            binaryManagerStatus.numBinariesGC += status.numBinariesGC;
            binaryManagerStatus.sizeBinariesGC += status.sizeBinariesGC;
        }
        binaryManagerStatus.gcDuration = System.currentTimeMillis() - start;
        return binaryManagerStatus;
    }

    @Override
    public void markReferencedBinary(String key, String repositoryName) {
        BlobProvider blobProvider = this.getBlobProvider(key, repositoryName);
        BinaryManager binaryManager = blobProvider.getBinaryManager();
        if (binaryManager != null) {
            int colon = key.indexOf(58);
            if (colon > 0) {
                key = key.substring(colon + 1);
            }
            binaryManager.getGarbageCollector().mark(key);
        } else {
            log.error((Object)("Unknown binary manager for key: " + key));
        }
    }

    @Override
    public boolean isBinariesGarbageCollectionInProgress() {
        for (BinaryGarbageCollector gc : this.getGarbageCollectors()) {
            if (!gc.isInProgress()) continue;
            return true;
        }
        return false;
    }

    protected static class BlobProviderDescriptorRegistry
    extends SimpleContributionRegistry<BlobProviderDescriptor> {
        protected BlobProviderDescriptorRegistry() {
        }

        public String getContributionId(BlobProviderDescriptor contrib) {
            return contrib.name;
        }

        public BlobProviderDescriptor clone(BlobProviderDescriptor orig) {
            return new BlobProviderDescriptor(orig);
        }

        public void merge(BlobProviderDescriptor src, BlobProviderDescriptor dst) {
            dst.merge(src);
        }

        public boolean isSupportingMerge() {
            return true;
        }

        public void clear() {
            this.currentContribs.clear();
        }

        public BlobProviderDescriptor getBlobProviderDescriptor(String id) {
            return (BlobProviderDescriptor)this.getCurrentContribution(id);
        }
    }
}

