/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.core.blob.binary;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.FilterOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.lang.reflect.Field;
import java.security.GeneralSecurityException;
import java.security.Key;
import java.security.KeyStore;
import java.security.MessageDigest;
import java.security.SecureRandom;
import java.util.Arrays;
import java.util.Map;
import java.util.Random;
import javax.crypto.BadPaddingException;
import javax.crypto.Cipher;
import javax.crypto.CipherInputStream;
import javax.crypto.SecretKey;
import javax.crypto.SecretKeyFactory;
import javax.crypto.spec.IvParameterSpec;
import javax.crypto.spec.PBEKeySpec;
import javax.crypto.spec.SecretKeySpec;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuxeo.ecm.core.api.NuxeoException;
import org.nuxeo.ecm.core.blob.binary.Binary;
import org.nuxeo.ecm.core.blob.binary.LocalBinaryManager;
import org.nuxeo.runtime.api.Framework;

public class AESBinaryManager
extends LocalBinaryManager {
    private static final Log log = LogFactory.getLog(AESBinaryManager.class);
    protected static final byte[] FILE_MAGIC = new byte[]{78, 85, 88, 69, 79, 67, 82, 89, 80, 84};
    protected static final int FILE_VERSION_1 = 1;
    protected static final int USE_KEYSTORE = 1;
    protected static final int USE_PBKDF2 = 2;
    protected static final String AES = "AES";
    protected static final String AES_CBC_PKCS5_PADDING = "AES/CBC/PKCS5Padding";
    protected static final String PBKDF2_WITH_HMAC_SHA1 = "PBKDF2WithHmacSHA1";
    protected static final int PBKDF2_ITERATIONS = 10000;
    protected static final int PBKDF2_KEY_LENGTH = 256;
    protected static final String PARAM_PASSWORD = "password";
    protected static final String PARAM_KEY_STORE_TYPE = "keyStoreType";
    protected static final String PARAM_KEY_STORE_FILE = "keyStoreFile";
    protected static final String PARAM_KEY_STORE_PASSWORD = "keyStorePassword";
    protected static final String PARAM_KEY_ALIAS = "keyAlias";
    protected static final String PARAM_KEY_PASSWORD = "keyPassword";
    private static final int MAX_SALT_LEN = 1024;
    private static final int MAX_IV_LEN = 1024;
    protected static final Random RANDOM = new SecureRandom();
    protected String digestAlgorithm;
    protected boolean usePBKDF2;
    protected String password;
    protected String keyStoreType;
    protected String keyStoreFile;
    protected String keyStorePassword;
    protected String keyAlias;
    protected String keyPassword;

    public AESBinaryManager() {
        AESBinaryManager.setUnlimitedJCEPolicy();
    }

    protected static boolean setUnlimitedJCEPolicy() {
        try {
            Field field = Class.forName("javax.crypto.JceSecurity").getDeclaredField("isRestricted");
            field.setAccessible(true);
            if (Boolean.TRUE.equals(field.get(null))) {
                log.info((Object)"Setting JCE Unlimited Strength");
                field.set(null, Boolean.FALSE);
            }
            return true;
        }
        catch (IllegalArgumentException | ReflectiveOperationException | SecurityException e) {
            log.debug((Object)"Cannot check/set JCE Unlimited Strength", (Throwable)e);
            return false;
        }
    }

    @Override
    public void initialize(String blobProviderId, Map<String, String> properties) throws IOException {
        super.initialize(blobProviderId, properties);
        this.digestAlgorithm = this.getDigestAlgorithm();
        String options = properties.get("key");
        if (StringUtils.isBlank((String)options)) {
            throw new NuxeoException("Missing key for " + this.getClass().getSimpleName());
        }
        this.initializeOptions(options);
    }

    protected void initializeOptions(String options) {
        block16: for (String option : options.split(",")) {
            String[] split = option.split("=", 2);
            if (split.length != 2) {
                throw new NuxeoException("Unrecognized option: " + option);
            }
            String value = StringUtils.defaultIfBlank((String)split[1], null);
            switch (split[0]) {
                case "password": {
                    this.password = value;
                    continue block16;
                }
                case "keyStoreType": {
                    this.keyStoreType = value;
                    continue block16;
                }
                case "keyStoreFile": {
                    this.keyStoreFile = value;
                    continue block16;
                }
                case "keyStorePassword": {
                    this.keyStorePassword = value;
                    continue block16;
                }
                case "keyAlias": {
                    this.keyAlias = value;
                    continue block16;
                }
                case "keyPassword": {
                    this.keyPassword = value;
                    continue block16;
                }
                default: {
                    throw new NuxeoException("Unrecognized option: " + option);
                }
            }
        }
        boolean bl = this.usePBKDF2 = this.password != null;
        if (this.usePBKDF2) {
            if (this.keyStoreType != null) {
                throw new NuxeoException("Cannot use keyStoreType with password");
            }
            if (this.keyStoreFile != null) {
                throw new NuxeoException("Cannot use keyStoreFile with password");
            }
            if (this.keyStorePassword != null) {
                throw new NuxeoException("Cannot use keyStorePassword with password");
            }
            if (this.keyAlias != null) {
                throw new NuxeoException("Cannot use keyAlias with password");
            }
            if (this.keyPassword != null) {
                throw new NuxeoException("Cannot use keyPassword with password");
            }
        } else {
            if (this.keyStoreType == null) {
                throw new NuxeoException("Missing keyStoreType");
            }
            if (this.keyStoreFile == null && this.keyStorePassword != null) {
                throw new NuxeoException("Missing keyStorePassword");
            }
            if (this.keyAlias == null) {
                throw new NuxeoException("Missing keyAlias");
            }
            if (this.keyPassword == null) {
                this.keyPassword = this.keyStorePassword;
            }
        }
    }

    protected char[] getPassword() {
        return this.password.toCharArray();
    }

    protected void clearPassword(char[] password) {
        if (password != null) {
            Arrays.fill(password, '\u0000');
        }
    }

    protected Key generateSecretKey(byte[] salt) throws GeneralSecurityException {
        char[] password = this.getPassword();
        SecretKeyFactory factory = SecretKeyFactory.getInstance(PBKDF2_WITH_HMAC_SHA1);
        PBEKeySpec spec = new PBEKeySpec(password, salt, 10000, 256);
        this.clearPassword(password);
        SecretKey derived = factory.generateSecret(spec);
        spec.clearPassword();
        return new SecretKeySpec(derived.getEncoded(), AES);
    }

    protected Key getSecretKey() throws GeneralSecurityException, IOException {
        char[] kspw;
        KeyStore keyStore = KeyStore.getInstance(this.keyStoreType);
        char[] cArray = kspw = this.keyStorePassword == null ? null : this.keyStorePassword.toCharArray();
        if (this.keyStoreFile != null) {
            try (BufferedInputStream in = new BufferedInputStream(new FileInputStream(this.keyStoreFile));){
                keyStore.load(in, kspw);
            }
        } else {
            keyStore.load(null, kspw);
        }
        this.clearPassword(kspw);
        char[] kpw = this.keyPassword == null ? null : this.keyPassword.toCharArray();
        Key key = keyStore.getKey(this.keyAlias, kpw);
        this.clearPassword(kpw);
        return key;
    }

    @Override
    protected Binary getBinary(InputStream in) throws IOException {
        File tmp = File.createTempFile("bin_", ".tmp", this.tmpDir);
        Framework.trackFile((File)tmp, (Object)tmp);
        BufferedOutputStream out = new BufferedOutputStream(new FileOutputStream(tmp));
        IOUtils.copy((InputStream)in, (OutputStream)out);
        in.close();
        ((OutputStream)out).close();
        BufferedInputStream nin = new BufferedInputStream(new FileInputStream(tmp));
        String digest = this.storeAndDigest(nin);
        return new Binary(tmp, digest, this.blobProviderId);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Binary getBinary(String digest) {
        File tmp;
        File file = this.getFileForDigest(digest, false);
        if (file == null) {
            log.warn((Object)("Invalid digest format: " + digest));
            return null;
        }
        if (!file.exists()) {
            return null;
        }
        try {
            tmp = File.createTempFile("bin_", ".tmp", this.tmpDir);
            Framework.trackFile((File)tmp, (Object)tmp);
            BufferedOutputStream out = new BufferedOutputStream(new FileOutputStream(tmp));
            BufferedInputStream in = new BufferedInputStream(new FileInputStream(file));
            try {
                this.decrypt(in, out);
            }
            finally {
                ((InputStream)in).close();
                ((OutputStream)out).close();
            }
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        return new Binary(tmp, digest, this.blobProviderId);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected String storeAndDigest(InputStream in) throws IOException {
        File tmp = File.createTempFile("create_", ".tmp", this.tmpDir);
        BufferedOutputStream out = new BufferedOutputStream(new FileOutputStream(tmp));
        try {
            String digest;
            try {
                digest = this.storeAndDigest(in, out);
            }
            finally {
                in.close();
                ((OutputStream)out).close();
            }
            File file = this.getFileForDigest(digest, true);
            this.atomicMove(tmp, file);
            String string = digest;
            return string;
        }
        finally {
            tmp.delete();
        }
    }

    @Override
    public String storeAndDigest(InputStream in, OutputStream out) throws IOException {
        out.write(FILE_MAGIC);
        DataOutputStream data = new DataOutputStream(out);
        data.writeByte(1);
        try {
            Key secret;
            MessageDigest messageDigest = MessageDigest.getInstance(this.digestAlgorithm);
            if (this.usePBKDF2) {
                data.writeByte(2);
                byte[] salt = new byte[16];
                RANDOM.nextBytes(salt);
                secret = this.generateSecretKey(salt);
                data.writeInt(salt.length);
                data.write(salt);
            } else {
                data.writeByte(1);
                secret = this.getSecretKey();
            }
            Cipher cipher = Cipher.getInstance(AES_CBC_PKCS5_PADDING);
            cipher.init(1, secret);
            byte[] iv = cipher.getIV();
            data.writeInt(iv.length);
            data.write(iv);
            CipherAndDigestOutputStream cipherOut = new CipherAndDigestOutputStream(out, cipher, messageDigest);
            IOUtils.copy((InputStream)in, (OutputStream)cipherOut);
            cipherOut.close();
            byte[] digest = cipherOut.getDigest();
            return AESBinaryManager.toHexString(digest);
        }
        catch (GeneralSecurityException e) {
            throw new NuxeoException((Throwable)e);
        }
    }

    protected void decrypt(InputStream in, OutputStream out) throws IOException {
        byte[] magic = new byte[FILE_MAGIC.length];
        IOUtils.read((InputStream)in, (byte[])magic);
        if (!Arrays.equals(magic, FILE_MAGIC)) {
            throw new IOException("Invalid file (bad magic)");
        }
        DataInputStream data = new DataInputStream(in);
        byte magicvers = data.readByte();
        if (magicvers != 1) {
            throw new IOException("Invalid file (bad version)");
        }
        byte usepb = data.readByte();
        if (usepb == 2) {
            if (!this.usePBKDF2) {
                throw new NuxeoException("File requires PBKDF2 password");
            }
        } else if (usepb == 1) {
            if (this.usePBKDF2) {
                throw new NuxeoException("File requires keystore");
            }
        } else {
            throw new IOException("Invalid file (bad use)");
        }
        try {
            Key secret;
            if (this.usePBKDF2) {
                int saltLen = data.readInt();
                if (saltLen <= 0 || saltLen > 1024) {
                    throw new NuxeoException("Invalid salt length: " + saltLen);
                }
                byte[] salt = new byte[saltLen];
                data.read(salt, 0, saltLen);
                secret = this.generateSecretKey(salt);
            } else {
                secret = this.getSecretKey();
            }
            int ivLen = data.readInt();
            if (ivLen <= 0 || ivLen > 1024) {
                throw new NuxeoException("Invalid IV length: " + ivLen);
            }
            byte[] iv = new byte[ivLen];
            data.read(iv, 0, ivLen);
            Cipher cipher = Cipher.getInstance(AES_CBC_PKCS5_PADDING);
            cipher.init(2, secret, new IvParameterSpec(iv));
            try (CipherInputStream cipherIn = new CipherInputStream(in, cipher);){
                IOUtils.copy((InputStream)cipherIn, (OutputStream)out);
            }
            catch (IOException e) {
                Throwable cause = e.getCause();
                if (cause != null && cause instanceof BadPaddingException) {
                    throw new NuxeoException(cause.getMessage(), (Throwable)e);
                }
            }
        }
        catch (GeneralSecurityException e) {
            throw new NuxeoException((Throwable)e);
        }
    }

    public static class CipherAndDigestOutputStream
    extends FilterOutputStream {
        protected Cipher cipher;
        protected OutputStream out;
        protected MessageDigest messageDigest;
        protected byte[] digest;

        public CipherAndDigestOutputStream(OutputStream out, Cipher cipher, MessageDigest messageDigest) {
            super(out);
            this.out = out;
            this.cipher = cipher;
            this.messageDigest = messageDigest;
        }

        public byte[] getDigest() {
            return this.digest;
        }

        @Override
        public void write(int b) throws IOException {
            this.write(new byte[]{(byte)b}, 0, 1);
        }

        @Override
        public void write(byte[] b, int off, int len) throws IOException {
            this.messageDigest.update(b, off, len);
            byte[] bytes = this.cipher.update(b, off, len);
            if (bytes != null) {
                this.out.write(bytes);
                bytes = null;
            }
        }

        @Override
        public void flush() throws IOException {
            this.out.flush();
        }

        @Override
        public void close() throws IOException {
            this.digest = this.messageDigest.digest();
            try {
                byte[] bytes = this.cipher.doFinal();
                this.out.write(bytes);
                bytes = null;
            }
            catch (GeneralSecurityException e) {
                throw new NuxeoException((Throwable)e);
            }
            try {
                this.flush();
            }
            finally {
                this.out.close();
            }
        }
    }
}

