/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.core.versioning;

import java.io.Serializable;
import java.util.ArrayDeque;
import java.util.Deque;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuxeo.ecm.core.api.DocumentModel;
import org.nuxeo.ecm.core.api.VersioningOption;
import org.nuxeo.ecm.core.model.Document;
import org.nuxeo.ecm.core.versioning.DefaultVersioningRuleDescriptor;
import org.nuxeo.ecm.core.versioning.ExtendableVersioningService;
import org.nuxeo.ecm.core.versioning.StandardVersioningService;
import org.nuxeo.ecm.core.versioning.VersioningFilterDescriptor;
import org.nuxeo.ecm.core.versioning.VersioningPolicyDescriptor;
import org.nuxeo.ecm.core.versioning.VersioningRestrictionDescriptor;
import org.nuxeo.ecm.core.versioning.VersioningRuleDescriptor;
import org.nuxeo.ecm.core.versioning.VersioningService;
import org.nuxeo.ecm.core.versioning.VersioningServiceDescriptor;
import org.nuxeo.runtime.api.Framework;
import org.nuxeo.runtime.logging.DeprecationLogger;
import org.nuxeo.runtime.model.ComponentContext;
import org.nuxeo.runtime.model.ComponentInstance;
import org.nuxeo.runtime.model.DefaultComponent;
import org.nuxeo.runtime.model.SimpleContributionRegistry;

public class VersioningComponent
extends DefaultComponent
implements VersioningService {
    private static final Log log = LogFactory.getLog(VersioningComponent.class);
    public static final String VERSIONING_SERVICE_XP = "versioningService";
    public static final String VERSIONING_RULE_XP = "versioningRules";
    public static final String VERSIONING_POLICY_XP = "policies";
    public static final String VERSIONING_FILTER_XP = "filters";
    public static final String VERSIONING_RESTRICTION_XP = "restrictions";
    protected static final StandardVersioningService STANDARD_VERSIONING_SERVICE = new StandardVersioningService();
    protected Map<VersioningServiceDescriptor, VersioningService> versioningServices = new LinkedHashMap<VersioningServiceDescriptor, VersioningService>();
    @Deprecated
    protected VersioningRuleRegistry versioningRulesRegistry = new VersioningRuleRegistry();
    protected VersioningPolicyRegistry versioningPoliciesRegistry = new VersioningPolicyRegistry();
    protected VersioningFilterRegistry versioningFiltersRegistry = new VersioningFilterRegistry();
    protected VersioningRestrictionRegistry versioningRestrictionsRegistry = new VersioningRestrictionRegistry();
    @Deprecated
    protected Deque<DefaultVersioningRuleDescriptor> defaultVersioningRuleList = new ArrayDeque<DefaultVersioningRuleDescriptor>();
    public VersioningService service = STANDARD_VERSIONING_SERVICE;
    protected ComponentContext context;

    public void activate(ComponentContext context) {
        this.context = context;
    }

    public void deactivate(ComponentContext context) {
        this.context = null;
    }

    public void registerContribution(Object contrib, String point, ComponentInstance contributor) {
        switch (point) {
            case "versioningService": {
                this.registerVersioningService((VersioningServiceDescriptor)contrib);
                break;
            }
            case "versioningRules": {
                if (contrib instanceof VersioningRuleDescriptor) {
                    VersioningRuleDescriptor rule = (VersioningRuleDescriptor)contrib;
                    this.registerVersioningRule(rule);
                    String message = String.format("Versioning rule for '%s' on component %s should now be contributed to extension points '%s', '%s' and '%s': a compatibility registration was performed but it may not be accurate.", rule.getTypeName(), contributor.getName(), VERSIONING_POLICY_XP, VERSIONING_FILTER_XP, VERSIONING_RESTRICTION_XP);
                    DeprecationLogger.log((String)message, (String)"9.1");
                    Framework.getRuntime().getWarnings().add(message);
                    break;
                }
                if (contrib instanceof DefaultVersioningRuleDescriptor) {
                    this.registerDefaultVersioningRule((DefaultVersioningRuleDescriptor)contrib);
                    String message = String.format("Default versioning rule on component %s should now be contributed to extension points '%s' and '%s': a compatibility registration was performed but it may not be accurate.", contributor.getName(), VERSIONING_POLICY_XP, VERSIONING_RESTRICTION_XP);
                    DeprecationLogger.log((String)message, (String)"9.1");
                    Framework.getRuntime().getWarnings().add(message);
                    break;
                }
                throw new RuntimeException("Unknown contribution to " + point + ": " + contrib.getClass());
            }
            case "policies": {
                this.registerVersioningPolicy((VersioningPolicyDescriptor)contrib);
                break;
            }
            case "filters": {
                this.registerVersioningFilter((VersioningFilterDescriptor)contrib);
                break;
            }
            case "restrictions": {
                this.registerVersioningRestriction((VersioningRestrictionDescriptor)contrib);
                break;
            }
            default: {
                throw new RuntimeException("Unknown extension point: " + point);
            }
        }
    }

    public void unregisterContribution(Object contrib, String point, ComponentInstance contributor) {
        switch (point) {
            case "versioningService": {
                this.unregisterVersioningService((VersioningServiceDescriptor)contrib);
                break;
            }
            case "versioningRules": {
                if (contrib instanceof VersioningRuleDescriptor) {
                    this.unregisterVersioningRule((VersioningRuleDescriptor)contrib);
                    break;
                }
                if (!(contrib instanceof DefaultVersioningRuleDescriptor)) break;
                this.unregisterDefaultVersioningRule((DefaultVersioningRuleDescriptor)contrib);
                break;
            }
            case "policies": {
                this.unregisterVersioningPolicy((VersioningPolicyDescriptor)contrib);
                break;
            }
            case "filters": {
                this.unregisterVersioningFilter((VersioningFilterDescriptor)contrib);
                break;
            }
            case "restrictions": {
                this.unregisterVersioningRestriction((VersioningRestrictionDescriptor)contrib);
                break;
            }
        }
    }

    protected void registerVersioningService(VersioningServiceDescriptor contrib) {
        String klass = contrib.className;
        try {
            VersioningService vs = (VersioningService)this.context.getRuntimeContext().loadClass(klass).newInstance();
            this.versioningServices.put(contrib, vs);
        }
        catch (ReflectiveOperationException e) {
            throw new RuntimeException("Failed to instantiate: " + klass, e);
        }
        log.info((Object)("Registered versioning service: " + klass));
        this.recompute();
    }

    protected void unregisterVersioningService(VersioningServiceDescriptor contrib) {
        this.versioningServices.remove(contrib);
        log.info((Object)("Unregistered versioning service: " + contrib.className));
        this.recompute();
    }

    @Deprecated
    protected void registerVersioningRule(VersioningRuleDescriptor contrib) {
        this.versioningRulesRegistry.addContribution(contrib);
        log.info((Object)("Registered versioning rule: " + contrib.getTypeName()));
        this.recompute();
    }

    @Deprecated
    protected void unregisterVersioningRule(VersioningRuleDescriptor contrib) {
        this.versioningRulesRegistry.removeContribution(contrib);
        log.info((Object)("Unregistered versioning rule: " + contrib.getTypeName()));
        this.recompute();
    }

    @Deprecated
    protected void registerDefaultVersioningRule(DefaultVersioningRuleDescriptor contrib) {
        this.defaultVersioningRuleList.add(contrib);
        this.recompute();
    }

    @Deprecated
    protected void unregisterDefaultVersioningRule(DefaultVersioningRuleDescriptor contrib) {
        this.defaultVersioningRuleList.remove(contrib);
        this.recompute();
    }

    protected void registerVersioningPolicy(VersioningPolicyDescriptor contrib) {
        this.versioningPoliciesRegistry.addContribution(contrib);
        log.info((Object)("Registered versioning policy: " + contrib.getId()));
        this.recompute();
    }

    protected void unregisterVersioningPolicy(VersioningPolicyDescriptor contrib) {
        this.versioningPoliciesRegistry.removeContribution(contrib);
        log.info((Object)("Unregistered versioning policy: " + contrib.getId()));
        this.recompute();
    }

    protected void registerVersioningFilter(VersioningFilterDescriptor contrib) {
        this.versioningFiltersRegistry.addContribution(contrib);
        log.info((Object)("Registered versioning filter: " + contrib.getId()));
        this.recompute();
    }

    protected void unregisterVersioningFilter(VersioningFilterDescriptor contrib) {
        this.versioningFiltersRegistry.removeContribution(contrib);
        log.info((Object)("Unregistered versioning filter: " + contrib.getId()));
        this.recompute();
    }

    protected void registerVersioningRestriction(VersioningRestrictionDescriptor contrib) {
        this.versioningRestrictionsRegistry.addContribution(contrib);
        log.info((Object)("Registered versioning restriction: " + contrib.getType()));
        this.recompute();
    }

    protected void unregisterVersioningRestriction(VersioningRestrictionDescriptor contrib) {
        this.versioningRestrictionsRegistry.removeContribution(contrib);
        log.info((Object)("Unregistered versioning restriction: " + contrib.getType()));
        this.recompute();
    }

    protected void recompute() {
        VersioningService versioningService = STANDARD_VERSIONING_SERVICE;
        for (VersioningService vs : this.versioningServices.values()) {
            versioningService = vs;
        }
        if (versioningService instanceof ExtendableVersioningService) {
            ExtendableVersioningService evs = versioningService;
            evs.setVersioningPolicies(this.getVersioningPolicies());
            evs.setVersioningFilters(this.getVersioningFilters());
            evs.setVersioningRestrictions(this.getVersioningRestrictions());
            evs.setVersioningRules(this.getVersioningRules());
            evs.setDefaultVersioningRule(this.getDefaultVersioningRule());
        }
        this.service = versioningService;
    }

    @Deprecated
    protected Map<String, VersioningRuleDescriptor> getVersioningRules() {
        return this.versioningRulesRegistry.getVersioningRuleDescriptors();
    }

    @Deprecated
    protected DefaultVersioningRuleDescriptor getDefaultVersioningRule() {
        return this.defaultVersioningRuleList.peekLast();
    }

    protected Map<String, VersioningPolicyDescriptor> getVersioningPolicies() {
        return this.versioningPoliciesRegistry.getVersioningPolicyDescriptors();
    }

    protected Map<String, VersioningFilterDescriptor> getVersioningFilters() {
        return this.versioningFiltersRegistry.getVersioningFilterDescriptors();
    }

    protected Map<String, VersioningRestrictionDescriptor> getVersioningRestrictions() {
        return this.versioningRestrictionsRegistry.getVersioningRestrictionDescriptors();
    }

    @Override
    public String getVersionLabel(DocumentModel doc) {
        return this.service.getVersionLabel(doc);
    }

    @Override
    public void doPostCreate(Document doc, Map<String, Serializable> options) {
        this.service.doPostCreate(doc, options);
    }

    @Override
    public List<VersioningOption> getSaveOptions(DocumentModel docModel) {
        return this.service.getSaveOptions(docModel);
    }

    @Override
    public boolean isPreSaveDoingCheckOut(Document doc, boolean isDirty, VersioningOption option, Map<String, Serializable> options) {
        return this.service.isPreSaveDoingCheckOut(doc, isDirty, option, options);
    }

    @Override
    public VersioningOption doPreSave(Document doc, boolean isDirty, VersioningOption option, String checkinComment, Map<String, Serializable> options) {
        return this.service.doPreSave(doc, isDirty, option, checkinComment, options);
    }

    @Override
    public boolean isPostSaveDoingCheckIn(Document doc, VersioningOption option, Map<String, Serializable> options) {
        return this.service.isPostSaveDoingCheckIn(doc, option, options);
    }

    @Override
    public Document doPostSave(Document doc, VersioningOption option, String checkinComment, Map<String, Serializable> options) {
        return this.service.doPostSave(doc, option, checkinComment, options);
    }

    @Override
    public Document doCheckIn(Document doc, VersioningOption option, String checkinComment) {
        return this.service.doCheckIn(doc, option, checkinComment);
    }

    @Override
    public void doCheckOut(Document doc) {
        this.service.doCheckOut(doc);
    }

    @Override
    public void doAutomaticVersioning(DocumentModel previousDocument, DocumentModel currentDocument, boolean before) {
        this.service.doAutomaticVersioning(previousDocument, currentDocument, before);
    }

    @Deprecated
    protected static class VersioningRuleRegistry
    extends SimpleContributionRegistry<VersioningRuleDescriptor> {
        protected VersioningRuleRegistry() {
        }

        public String getContributionId(VersioningRuleDescriptor contrib) {
            return contrib.getTypeName();
        }

        public VersioningRuleDescriptor clone(VersioningRuleDescriptor orig) {
            return new VersioningRuleDescriptor(orig);
        }

        public void merge(VersioningRuleDescriptor src, VersioningRuleDescriptor dst) {
            dst.merge(src);
        }

        public boolean isSupportingMerge() {
            return true;
        }

        public void contributionUpdated(String id, VersioningRuleDescriptor contrib, VersioningRuleDescriptor newOrigContrib) {
            if (contrib.isEnabled()) {
                this.currentContribs.put(id, contrib);
            } else {
                this.currentContribs.remove(id);
            }
        }

        public void clear() {
            this.currentContribs.clear();
        }

        public Map<String, VersioningRuleDescriptor> getVersioningRuleDescriptors() {
            return this.currentContribs;
        }
    }

    protected static class VersioningRestrictionRegistry
    extends SimpleContributionRegistry<VersioningRestrictionDescriptor> {
        protected VersioningRestrictionRegistry() {
        }

        public String getContributionId(VersioningRestrictionDescriptor contrib) {
            return contrib.getType();
        }

        public Map<String, VersioningRestrictionDescriptor> getVersioningRestrictionDescriptors() {
            return this.currentContribs;
        }
    }

    protected static class VersioningFilterRegistry
    extends SimpleContributionRegistry<VersioningFilterDescriptor> {
        protected VersioningFilterRegistry() {
        }

        public String getContributionId(VersioningFilterDescriptor contrib) {
            return contrib.getId();
        }

        public Map<String, VersioningFilterDescriptor> getVersioningFilterDescriptors() {
            return this.currentContribs;
        }
    }

    protected static class VersioningPolicyRegistry
    extends SimpleContributionRegistry<VersioningPolicyDescriptor> {
        protected VersioningPolicyRegistry() {
        }

        public String getContributionId(VersioningPolicyDescriptor contrib) {
            return contrib.getId();
        }

        public Map<String, VersioningPolicyDescriptor> getVersioningPolicyDescriptors() {
            return this.currentContribs.entrySet().stream().sorted(Map.Entry.comparingByValue()).collect(Collectors.toMap(Map.Entry::getKey, Map.Entry::getValue, (e1, e2) -> e1, LinkedHashMap::new));
        }
    }
}

