/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.runtime.datasource;

import java.sql.SQLException;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.apache.commons.logging.LogFactory;
import org.nuxeo.common.xmap.annotation.XNode;
import org.nuxeo.common.xmap.annotation.XNodeList;
import org.nuxeo.common.xmap.annotation.XObject;
import org.nuxeo.runtime.datasource.DataSourceComponent;
import org.nuxeo.runtime.model.ContributionFragmentRegistry;
import org.tranql.connector.ExceptionSorter;

public class DatasourceExceptionSorter
implements ExceptionSorter {
    Configuration configuration;

    public boolean isExceptionFatal(Exception e) {
        if (!(e instanceof SQLException)) {
            return true;
        }
        SQLException se = (SQLException)e;
        String statuscode = se.getSQLState();
        Integer errorcode = se.getErrorCode();
        if (this.configuration == null) {
            this.configuration = DataSourceComponent.instance.sorterRegistry.lookup(se);
        }
        return this.configuration.isFatal(statuscode, errorcode);
    }

    public boolean rollbackOnFatalException() {
        return true;
    }

    public static class Registry
    extends ContributionFragmentRegistry<Configuration> {
        final Map<String, Configuration> actuals = new HashMap<String, Configuration>();

        public String getContributionId(Configuration contrib) {
            return contrib.id;
        }

        public void contributionUpdated(String id, Configuration contrib, Configuration newOrigContrib) {
            this.actuals.put(id, contrib);
        }

        public void contributionRemoved(String id, Configuration origContrib) {
            this.actuals.put(id, origContrib);
        }

        public Configuration clone(Configuration orig) {
            Configuration cloned = new Configuration();
            cloned.states.addAll(orig.states);
            cloned.codes.addAll(orig.codes);
            return cloned;
        }

        public void merge(Configuration src, Configuration dst) {
            if (src.override) {
                dst.states.clear();
                dst.codes.clear();
            }
            dst.states.addAll(src.states);
            dst.codes.addAll(src.codes);
        }

        public Configuration lookup(SQLException se) {
            for (StackTraceElement frame : se.getStackTrace()) {
                for (Configuration config : this.actuals.values()) {
                    if ("".equals(config.id) || !config.matches(frame.getClassName())) continue;
                    return config;
                }
            }
            return this.actuals.get("");
        }
    }

    @XObject(value="sorter")
    public static class Configuration {
        @XNode(value="@id")
        String id = "";
        @XNode(value="@override")
        boolean override = false;
        @XNode(value="@path")
        String pathname;
        final Set<String> codes = new HashSet<String>();
        final Set<String> states = new HashSet<String>();
        @XNodeList(value="vendor", type=HashSet.class, componentType=Integer.class)
        Set<Integer> vendors = new HashSet<Integer>();

        boolean matches(String classname) {
            return classname.startsWith(this.pathname);
        }

        @XNodeList(value="code", type=String[].class, componentType=String.class)
        public void setCodes(String ... values) {
            for (String value : values) {
                int length;
                Classcode classcode = Classcode.valueOf(value);
                if (classcode != null) {
                    value = classcode.value;
                }
                if ((length = value.length()) == 2) {
                    this.codes.add(value);
                    continue;
                }
                if (length == 5) {
                    this.states.add(value);
                    continue;
                }
                LogFactory.getLog(DatasourceExceptionSorter.class).error((Object)("invalid code " + value));
            }
        }

        boolean isFatal(String sqlstate, Integer vendor) {
            String code = sqlstate.substring(0, 2);
            return this.codes.contains(code) || this.states.contains(sqlstate) || this.vendors.contains(vendor);
        }
    }

    public static enum Classcode {
        NoError("00"),
        Warning("01"),
        NoData("02"),
        DynamicSQLError("07"),
        ConnectionException("08"),
        TriggeredActionException("09"),
        FeatureNotSupported("0A"),
        InvalidTransactionInitiation("0B"),
        InvalidTargetTypeSpecification("0D"),
        InvalidSchemaNameListSpecification("0E"),
        LocatorException("0F"),
        ResignalWhenHandlerNotActive("0K"),
        InvalidGrantor("0L"),
        InvalidSqlInvokedProcedureReference("0M"),
        MappingError("0N"),
        InvalidRoleSpecification("0P"),
        InvalidTransformGroupNameSpecification("0S"),
        TargetTableDisagreesWithCursorSpecification("0T"),
        AttemptToAssignNonUpdatableColumn("0U"),
        AttemptToAssignToOrderingColumn("0V"),
        ProhibitedStatementEncouteredDuringTriggerExecution("0W"),
        DiagnosticsException("0Z"),
        XQuery("10"),
        CaseNotFoundInCaseStatement("20"),
        CardinalityViolation("21"),
        DataException("22"),
        IntegrityConstraintViolation("23"),
        InvalidCursorState("24"),
        InvalidTransactionState("25"),
        InvalidSQLStatementName("26"),
        TriggeredDataChangeViolation("27"),
        InvalidAuthorizationSpeciciation("28"),
        DependentPrivilegeDescriptorsAlreadyExsist("2B"),
        InvalidConnectionName("2E"),
        InvalidCharacterSetName("2C"),
        InvalidTransactionTermination("2D"),
        SqlRoutineException("2F"),
        InvalidSessionCollationSpecication("2H"),
        InvalidSqlStatementIdentifier("30"),
        InvalidSqlDescriptorName("33"),
        InvalidCursorName("34"),
        InvalidConditionNumber("35"),
        CursorSensivityException("36"),
        SyntaxError("37"),
        ExternalRoutineException("38"),
        ExternalRoutineInvocationException("39"),
        SavepointException("3B"),
        InvalidCatalogName("3D"),
        AmbiguousCursorName("3C"),
        InvalidSchemaName("3F"),
        TransactionRollback("40"),
        SyntaxErrorOrAccessRuleViolation("42"),
        WithCheckOptionViolation("44"),
        JavaErrors("46"),
        InvalidApplicationState("51"),
        InvalidOperandOrInconsistentSpecification("53"),
        SqlOrProductLimitExcedeed("54"),
        ObjectNotInPrerequisiteState("55"),
        MiscellaneoudSqlOrProductError("56"),
        ResourceNotAvailableOrOperatorIntervention("57"),
        SystemError("58"),
        CommonUtilitiesAndTools("5U"),
        RemoteDatabaseAccess("HZ");

        public String value;

        private Classcode(String code) {
            this.value = code;
        }
    }
}

