/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.core.cache;

import java.io.Serializable;
import java.util.Set;
import org.nuxeo.ecm.core.cache.Cache;
import org.nuxeo.ecm.core.cache.CacheDescriptor;
import org.nuxeo.ecm.core.cache.CacheWrapper;

public class CacheAttributesChecker
extends CacheWrapper {
    protected CacheAttributesChecker(CacheDescriptor desc, Cache cache) {
        super(cache);
    }

    @Override
    public Serializable get(String key) {
        if (key == null) {
            return null;
        }
        return this.cache.get(key);
    }

    @Override
    public Set<String> keySet() {
        return this.cache.keySet();
    }

    @Override
    public void invalidate(String key) {
        if (key == null) {
            throw new IllegalArgumentException(String.format("Can't invalidate a null key for the cache '%s'!", this.cache.getName()));
        }
        this.cache.invalidate(key);
    }

    @Override
    public void invalidateAll() {
        this.cache.invalidateAll();
    }

    @Override
    public void put(String key, Serializable value) {
        if (key == null) {
            throw new IllegalArgumentException(String.format("Can't put a null key for the cache '%s'!", this.cache.getName()));
        }
        this.cache.put(key, value);
    }

    @Override
    public boolean hasEntry(String key) {
        if (key == null) {
            return false;
        }
        return this.cache.hasEntry(key);
    }

    @Override
    public long getSize() {
        return this.cache.getSize();
    }
}

