/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.core.cache;

import java.util.HashMap;
import java.util.Map;
import org.nuxeo.common.xmap.annotation.XNode;
import org.nuxeo.common.xmap.annotation.XNodeMap;
import org.nuxeo.common.xmap.annotation.XObject;
import org.nuxeo.ecm.core.api.NuxeoException;
import org.nuxeo.ecm.core.cache.Cache;
import org.nuxeo.ecm.core.cache.CacheAttributesChecker;
import org.nuxeo.ecm.core.cache.CacheMetrics;
import org.nuxeo.ecm.core.cache.CacheWrapper;
import org.nuxeo.ecm.core.cache.InMemoryCacheImpl;

@XObject(value="cache")
public class CacheDescriptor {
    @XNode(value="@name")
    public String name;
    @XNode(value="@remove")
    public boolean remove = false;
    @XNode(value="@class")
    protected Class<? extends Cache> implClass = InMemoryCacheImpl.class;
    @XNode(value="ttl")
    public int ttl = 1;
    @XNodeMap(value="option", key="@name", type=HashMap.class, componentType=String.class)
    public Map<String, String> options = new HashMap<String, String>();
    protected Cache cache;

    public CacheDescriptor() {
    }

    protected CacheDescriptor(String name, Class<? extends Cache> implClass, Integer ttl, Map<String, String> options) {
        this.name = name;
        this.implClass = implClass;
        this.ttl = ttl;
        this.options.putAll(options);
    }

    public CacheDescriptor(CacheDescriptor other) {
        this.name = other.name;
        this.implClass = other.implClass;
        this.ttl = other.ttl;
        this.options = new HashMap<String, String>(other.options);
    }

    public CacheDescriptor clone() {
        return new CacheDescriptor(this.name, this.implClass, this.ttl, this.options);
    }

    public Class<?> getImplClass() {
        return this.implClass;
    }

    public void setImplClass(Class<Cache> implClass) {
        this.implClass = implClass;
    }

    public String toString() {
        return this.name + ": " + this.implClass + ": " + this.ttl + ": " + this.options;
    }

    protected void invalidateAll() {
        this.cache.invalidateAll();
    }

    protected void start() {
        try {
            this.cache = this.implClass.getConstructor(CacheDescriptor.class).newInstance(this);
            this.cache = new CacheAttributesChecker(this, this.cache);
            this.cache = new CacheMetrics(this.cache);
        }
        catch (ReflectiveOperationException e) {
            throw new NuxeoException("Failed to instantiate class " + this.implClass, (Throwable)e);
        }
    }

    protected void stop() {
        if (this.cache == null) {
            return;
        }
        try {
            ((CacheWrapper)this.cache).stop();
        }
        finally {
            this.cache = null;
        }
    }
}

