/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.core.cache;

import com.codahale.metrics.Counter;
import com.codahale.metrics.Gauge;
import com.codahale.metrics.Metric;
import com.codahale.metrics.MetricRegistry;
import com.codahale.metrics.RatioGauge;
import com.codahale.metrics.SharedMetricRegistries;
import java.io.Serializable;
import org.nuxeo.ecm.core.cache.Cache;
import org.nuxeo.ecm.core.cache.CacheWrapper;
import org.nuxeo.runtime.metrics.MetricsService;

public class CacheMetrics
extends CacheWrapper {
    protected final MetricRegistry registry;
    protected final Counter read;
    protected final Counter read_hit;
    protected final Counter read_miss;
    protected final RatioGauge read_hit_ratio;
    protected final Counter write;
    protected final Counter invalidation;
    protected final Gauge<Long> size;
    protected final String READ_HIT_NAME = this.nameOf("read-hit-counter");
    protected final String READ_HIT_RATIO_NAME = this.nameOf("read-hit-ratio");
    protected final String READ_MISS_NAME = this.nameOf("read-miss-counter");
    protected final String READ_NAME = this.nameOf("read-counter");
    protected final String WRITE_NAME = this.nameOf("write-counter");
    protected final String INVALIDATE_ALL_NAME = this.nameOf("invalidate-all-counter");
    protected final String SIZE_NAME = this.nameOf("size");

    public CacheMetrics(final Cache cache) {
        super(cache);
        this.registry = SharedMetricRegistries.getOrCreate((String)MetricsService.class.getName());
        this.read = this.registry.counter(this.READ_NAME);
        this.read_hit = this.registry.counter(this.READ_HIT_NAME);
        this.read_miss = this.registry.counter(this.READ_MISS_NAME);
        this.read_hit_ratio = new RatioGauge(){

            protected RatioGauge.Ratio getRatio() {
                RatioGauge.Ratio ratio = RatioGauge.Ratio.of((double)CacheMetrics.this.read_hit.getCount(), (double)CacheMetrics.this.read.getCount());
                return ratio;
            }
        };
        this.registry.register(this.READ_HIT_RATIO_NAME, (Metric)this.read_hit_ratio);
        this.write = this.registry.counter(this.WRITE_NAME);
        this.invalidation = this.registry.counter(this.INVALIDATE_ALL_NAME);
        this.size = new Gauge<Long>(){

            public Long getValue() {
                return cache.getSize();
            }
        };
        this.registry.register(this.SIZE_NAME, (Metric)this.size);
    }

    protected String nameOf(String name) {
        return MetricRegistry.name((String)"nuxeo", (String[])new String[]{"cache", this.cache.getName(), name});
    }

    @Override
    protected void onStop() {
        this.registry.remove(this.READ_NAME);
        this.registry.remove(this.READ_HIT_NAME);
        this.registry.remove(this.READ_HIT_RATIO_NAME);
        this.registry.remove(this.READ_MISS_NAME);
        this.registry.remove(this.WRITE_NAME);
        this.registry.remove(this.INVALIDATE_ALL_NAME);
        this.registry.remove(this.SIZE_NAME);
    }

    @Override
    public Serializable get(String key) {
        Serializable value = this.cache.get(key);
        this.read.inc();
        if (value != null || this.cache.hasEntry(key)) {
            this.read_hit.inc();
        } else {
            this.read_miss.inc();
        }
        return value;
    }

    @Override
    public void put(String key, Serializable value) {
        try {
            super.put(key, value);
        }
        finally {
            this.write.inc();
        }
    }

    @Override
    public void invalidate(String key) {
        this.cache.invalidate(key);
    }

    @Override
    public void invalidateAll() {
        try {
            this.cache.invalidateAll();
        }
        finally {
            this.invalidation.inc();
        }
    }

    @Override
    public long getSize() {
        return this.cache.getSize();
    }
}

