/*
 * Decompiled with CFR 0.152.
 */
package com.thetransactioncompany.cors;

import com.thetransactioncompany.cors.Origin;
import com.thetransactioncompany.cors.OriginException;
import java.net.IDN;
import java.net.URI;
import java.net.URISyntaxException;

public class ValidatedOrigin
extends Origin {
    private String scheme;
    private String host;
    private int port = -1;

    public ValidatedOrigin(Origin origin) throws OriginException {
        super(origin.toString());
        URI uri;
        try {
            uri = new URI(origin.toString());
        }
        catch (URISyntaxException e) {
            throw new OriginException("Bad origin URI: " + e.getMessage());
        }
        this.scheme = uri.getScheme();
        this.host = uri.getHost();
        this.port = uri.getPort();
        if (this.scheme == null) {
            throw new OriginException("Bad origin URI: Missing scheme, such as http or https");
        }
        this.scheme = this.scheme.toLowerCase();
        this.host = IDN.toASCII(this.host, 3);
        this.host = this.host.toLowerCase();
    }

    public String getScheme() {
        return this.scheme;
    }

    public String getHost() {
        return this.host;
    }

    public int getPort() {
        return this.port;
    }

    public String getSuffix() {
        String s = this.host;
        if (this.port != -1) {
            s = s + ":" + this.port;
        }
        return s;
    }
}

