/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.platform.commandline.executor.service;

import java.io.Serializable;
import org.apache.commons.lang.builder.ToStringBuilder;
import org.apache.commons.lang.builder.ToStringStyle;
import org.apache.commons.lang3.SystemUtils;
import org.nuxeo.common.xmap.annotation.XNode;
import org.nuxeo.common.xmap.annotation.XObject;

@XObject(value="command")
public class CommandLineDescriptor
implements Serializable {
    private static final long serialVersionUID = 1L;
    @XNode(value="@name")
    protected String name;
    @XNode(value="@enabled")
    protected boolean enabled;
    protected boolean available;
    @XNode(value="commandLine")
    protected String command;
    @XNode(value="parameterString")
    protected String parameterString = "";
    @XNode(value="testParameterString")
    protected String testParameterString = "";
    @XNode(value="winParameterString")
    protected String winParameterString;
    @XNode(value="winTestParameterString")
    protected String winTestParameterString = "";
    @XNode(value="winCommand")
    protected String winCommand;
    @XNode(value="tester")
    protected String tester;
    @XNode(value="readOutput")
    protected boolean readOutput = true;
    @XNode(value="installationDirective")
    protected String installationDirective;
    protected String installErrorMessage;

    public String getInstallErrorMessage() {
        return this.installErrorMessage;
    }

    public void setInstallErrorMessage(String installErrorMessage) {
        this.installErrorMessage = installErrorMessage;
    }

    public String getName() {
        if (this.name == null) {
            return this.getCommand();
        }
        return this.name;
    }

    public boolean isEnabled() {
        return this.enabled;
    }

    public String getCommand() {
        if (SystemUtils.IS_OS_WINDOWS && this.winCommand != null) {
            return this.winCommand;
        }
        return this.command;
    }

    public String getInstallationDirective() {
        return this.installationDirective;
    }

    public String getTester() {
        return this.tester;
    }

    public boolean isAvailable() {
        return this.available;
    }

    public void setAvailable(boolean available) {
        this.available = available;
    }

    public boolean getReadOutput() {
        return this.readOutput;
    }

    public String getParametersString() {
        if (SystemUtils.IS_OS_WINDOWS && this.winParameterString != null) {
            return this.winParameterString;
        }
        return this.parameterString;
    }

    public String getTestParametersString() {
        if (SystemUtils.IS_OS_WINDOWS && this.winTestParameterString != null) {
            return this.winTestParameterString;
        }
        return this.testParameterString;
    }

    public String getExecutor() {
        return "ShellExecutor";
    }

    public String toString() {
        return ToStringBuilder.reflectionToString((Object)this, (ToStringStyle)ToStringStyle.SHORT_PREFIX_STYLE);
    }
}

