/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.core.event.impl;

import java.util.List;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.FutureTask;
import java.util.concurrent.RejectedExecutionException;
import java.util.concurrent.SynchronousQueue;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.concurrent.atomic.AtomicInteger;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuxeo.common.logging.SequenceTracer;
import org.nuxeo.ecm.core.event.EventBundle;
import org.nuxeo.ecm.core.event.EventStats;
import org.nuxeo.ecm.core.event.ReconnectedEventBundle;
import org.nuxeo.ecm.core.event.impl.EventListenerDescriptor;
import org.nuxeo.ecm.core.event.impl.ReconnectedEventBundleImpl;
import org.nuxeo.runtime.api.Framework;
import org.nuxeo.runtime.transaction.TransactionHelper;

public class PostCommitEventExecutor {
    private static final Log log = LogFactory.getLog(PostCommitEventExecutor.class);
    public static final String TIMEOUT_MS_PROP = "org.nuxeo.ecm.core.event.tx.PostCommitExecutor.timeoutMs";
    public static final int DEFAULT_TIMEOUT_MS = 300;
    public static final int DEFAULT_TIMEOUT_TEST_MS = 60000;
    private Integer defaultTimeoutMs;
    public static final String DEFAULT_BULK_TIMEOUT_S = "600";
    public static final String BULK_TIMEOUT_PROP = "org.nuxeo.ecm.core.event.tx.BulkExecutor.timeout";
    private static final long KEEP_ALIVE_TIME_SECOND = 10L;
    private static final int MAX_POOL_SIZE = 100;
    protected final ExecutorService executor;

    public PostCommitEventExecutor() {
        NamedThreadFactory threadFactory = new NamedThreadFactory("Nuxeo-Event-PostCommit-");
        this.executor = new ThreadPoolExecutor(0, 100, 10L, TimeUnit.SECONDS, new SynchronousQueue<Runnable>(), threadFactory);
        ((ThreadPoolExecutor)this.executor).allowCoreThreadTimeOut(true);
    }

    protected int getDefaultTimeoutMs() {
        if (this.defaultTimeoutMs == null) {
            this.defaultTimeoutMs = Framework.getProperty((String)TIMEOUT_MS_PROP) != null ? Integer.valueOf(Integer.parseInt(Framework.getProperty((String)TIMEOUT_MS_PROP))) : (Framework.isTestModeSet() ? Integer.valueOf(60000) : Integer.valueOf(300));
        }
        return this.defaultTimeoutMs;
    }

    public void shutdown(long timeoutMillis) throws InterruptedException {
        this.executor.shutdown();
        this.executor.awaitTermination(timeoutMillis, TimeUnit.MILLISECONDS);
        if (!this.executor.isTerminated()) {
            this.executor.shutdownNow();
        }
    }

    public void run(List<EventListenerDescriptor> listeners, EventBundle event) {
        this.run(listeners, event, this.getDefaultTimeoutMs(), false);
    }

    public void runBulk(List<EventListenerDescriptor> listeners, EventBundle event) {
        String timeoutSeconds = Framework.getProperty((String)BULK_TIMEOUT_PROP, (String)DEFAULT_BULK_TIMEOUT_S);
        this.run(listeners, event, Long.parseLong(timeoutSeconds) * 1000L, true);
    }

    public void run(List<EventListenerDescriptor> listeners, EventBundle bundle, long timeoutMillis, boolean bulk) {
        boolean some = false;
        for (EventListenerDescriptor listener : listeners) {
            if (!listener.acceptBundle(bundle)) continue;
            some = true;
            break;
        }
        if (!some) {
            if (log.isDebugEnabled()) {
                log.debug((Object)"Events postcommit execution has nothing to do");
            }
            return;
        }
        if (log.isDebugEnabled()) {
            log.debug((Object)String.format("Events postcommit execution starting with timeout %sms%s", timeoutMillis, bulk ? " in bulk mode" : ""));
        }
        Callable<Boolean> callable = !bulk ? new EventBundleRunner(listeners, bundle) : new EventBundleBulkRunner(listeners, bundle);
        FutureTask<Boolean> futureTask = new FutureTask<Boolean>(callable);
        try {
            this.executor.execute(futureTask);
        }
        catch (RejectedExecutionException e) {
            log.error((Object)"Events postcommit execution rejected", (Throwable)e);
            return;
        }
        try {
            Boolean ok = futureTask.get(timeoutMillis, TimeUnit.MILLISECONDS);
            if (Boolean.FALSE.equals(ok)) {
                log.error((Object)"Events postcommit bulk execution aborted due to previous error");
            }
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            futureTask.cancel(true);
        }
        catch (TimeoutException e) {
            if (!bulk) {
                log.info((Object)String.format("Events postcommit execution exceeded timeout of %sms, leaving thread running", timeoutMillis));
            } else {
                log.error((Object)String.format("Events postcommit bulk execution exceeded timeout of %sms, interrupting thread", timeoutMillis));
                futureTask.cancel(true);
            }
        }
        catch (ExecutionException e) {
            log.error((Object)"Events postcommit execution encountered unexpected exception", e.getCause());
        }
        if (log.isDebugEnabled()) {
            log.debug((Object)"Events postcommit execution finished");
        }
    }

    protected static class EventBundleBulkRunner
    implements Callable<Boolean> {
        protected final List<EventListenerDescriptor> listeners;
        protected final EventBundle bundle;
        protected final String callerThread;

        public EventBundleBulkRunner(List<EventListenerDescriptor> listeners, EventBundle bundle) {
            this.listeners = listeners;
            this.bundle = bundle;
            this.callerThread = SequenceTracer.getThreadName();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Unable to fully structure code
         */
        @Override
        public Boolean call() {
            block31: {
                SequenceTracer.startFrom((String)this.callerThread, (String)"BulkPostcommit", (String)"#ff410f");
                if (PostCommitEventExecutor.access$000().isDebugEnabled()) {
                    PostCommitEventExecutor.access$000().debug((Object)("Events postcommit bulk execution starting in thread: " + Thread.currentThread().getName()));
                }
                t0 = System.currentTimeMillis();
                ok = false;
                interrupt = false;
                reconnected = null;
                tx = TransactionHelper.startTransaction();
                reconnected = new ReconnectedEventBundleImpl(this.bundle, this.listeners.toString());
                for (EventListenerDescriptor listener : this.listeners) {
                    filtered = listener.filterBundle(reconnected);
                    if (filtered.isEmpty()) continue;
                    SequenceTracer.start((String)("run listener " + listener.getName()));
                    if (PostCommitEventExecutor.access$000().isDebugEnabled()) {
                        PostCommitEventExecutor.access$000().debug((Object)("Events postcommit bulk execution start for listener: " + listener.getName()));
                    }
                    t1 = System.currentTimeMillis();
                    try {
                        listener.asPostCommitListener().handleEvent(filtered);
                        if (!Thread.currentThread().isInterrupted()) ** GOTO lbl45
                        PostCommitEventExecutor.access$000().error((Object)("Events postcommit bulk execution interrupted for listener: " + listener.getName() + ", will rollback and abort bulk processing"));
                        interrupt = true;
                    }
                    catch (RuntimeException e) {
                        PostCommitEventExecutor.access$000().error((Object)("Events postcommit bulk execution encountered exception for listener: " + listener.getName()), (Throwable)e);
                        var13_13 = Boolean.FALSE;
                        try {
                            if (reconnected != null) {
                                reconnected.disconnect();
                            }
                        }
                        finally {
                            if (tx) {
                                if (!ok) {
                                    TransactionHelper.setTransactionRollbackOnly();
                                    PostCommitEventExecutor.access$000().error((Object)"Rolling back transaction");
                                }
                                TransactionHelper.commitOrRollbackTransaction();
                            }
                        }
                        elapsed = System.currentTimeMillis() - t0;
                        SequenceTracer.stop((String)("BulkPostcommit done " + elapsed + " ms"));
                        if (PostCommitEventExecutor.access$000().isDebugEnabled()) {
                            PostCommitEventExecutor.access$000().debug((Object)("Events postcommit bulk execution finished in " + elapsed + "ms"));
                        }
                        return var13_13;
                    }
lbl45:
                    // 2 sources

                    if (!interrupt) continue;
                    break;
                }
                ok = interrupt == false;
                break block31;
                {
                    finally {
                        elapsed = System.currentTimeMillis() - t1;
                        if (PostCommitEventExecutor.access$000().isDebugEnabled()) {
                            PostCommitEventExecutor.access$000().debug((Object)("Events postcommit bulk execution end for listener: " + listener.getName() + " in " + elapsed + "ms"));
                        }
                        SequenceTracer.stop((String)("listener done " + elapsed + " ms"));
                    }
                }
                finally {
                    try {
                        if (reconnected != null) {
                            reconnected.disconnect();
                        }
                    }
                    finally {
                        if (tx) {
                            if (!ok) {
                                TransactionHelper.setTransactionRollbackOnly();
                                PostCommitEventExecutor.access$000().error((Object)"Rolling back transaction");
                            }
                            TransactionHelper.commitOrRollbackTransaction();
                        }
                    }
                    elapsed = System.currentTimeMillis() - t0;
                    SequenceTracer.stop((String)("BulkPostcommit done " + elapsed + " ms"));
                    if (PostCommitEventExecutor.access$000().isDebugEnabled()) {
                        PostCommitEventExecutor.access$000().debug((Object)("Events postcommit bulk execution finished in " + elapsed + "ms"));
                    }
                }
            }
            return Boolean.TRUE;
        }
    }

    protected static class EventBundleRunner
    implements Callable<Boolean> {
        protected final List<EventListenerDescriptor> listeners;
        protected final EventBundle bundle;
        protected String callerThread;

        public EventBundleRunner(List<EventListenerDescriptor> listeners, EventBundle bundle) {
            this.listeners = listeners;
            this.bundle = bundle;
            this.callerThread = SequenceTracer.getThreadName();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public Boolean call() {
            if (log.isDebugEnabled()) {
                log.debug((Object)("Events postcommit execution starting in thread: " + Thread.currentThread().getName()));
            }
            SequenceTracer.startFrom((String)this.callerThread, (String)"Postcommit", (String)"#ff410f");
            long t0 = System.currentTimeMillis();
            EventStats stats = (EventStats)Framework.getLocalService(EventStats.class);
            for (EventListenerDescriptor listener : this.listeners) {
                EventBundle filtered = listener.filterBundle(this.bundle);
                if (filtered.isEmpty()) continue;
                if (log.isDebugEnabled()) {
                    log.debug((Object)("Events postcommit execution start for listener: " + listener.getName()));
                }
                SequenceTracer.start((String)("run listener " + listener.getName()));
                long t1 = System.currentTimeMillis();
                boolean ok = false;
                ReconnectedEventBundle reconnected = null;
                boolean tx = TransactionHelper.startTransaction();
                try {
                    reconnected = new ReconnectedEventBundleImpl(filtered, this.listeners.toString());
                    listener.asPostCommitListener().handleEvent(reconnected);
                    if (Thread.currentThread().isInterrupted()) {
                        log.error((Object)("Events postcommit execution interrupted for listener: " + listener.getName()));
                        SequenceTracer.destroy((String)"interrupted");
                        ok = false;
                        continue;
                    }
                    ok = true;
                }
                catch (RuntimeException e) {
                    log.error((Object)("Events postcommit execution encountered exception for listener: " + listener.getName()), (Throwable)e);
                }
                finally {
                    try {
                        if (reconnected == null) continue;
                        reconnected.disconnect();
                    }
                    finally {
                        if (tx) {
                            if (!ok) {
                                TransactionHelper.setTransactionRollbackOnly();
                                log.error((Object)"Rolling back transaction");
                            }
                            TransactionHelper.commitOrRollbackTransaction();
                        }
                        long elapsed = System.currentTimeMillis() - t1;
                        if (stats != null) {
                            stats.logAsyncExec(listener, elapsed);
                        }
                        if (log.isDebugEnabled()) {
                            log.debug((Object)("Events postcommit execution end for listener: " + listener.getName() + " in " + elapsed + "ms"));
                        }
                        SequenceTracer.stop((String)("listener done " + elapsed + " ms"));
                    }
                }
            }
            long elapsed = System.currentTimeMillis() - t0;
            if (log.isDebugEnabled()) {
                log.debug((Object)("Events postcommit execution finished in " + elapsed + "ms"));
            }
            SequenceTracer.stop((String)("postcommit done" + elapsed + " ms"));
            return Boolean.TRUE;
        }
    }

    private static class NamedThreadFactory
    implements ThreadFactory {
        private final AtomicInteger threadNumber = new AtomicInteger();
        private final ThreadGroup group;
        private final String prefix;

        public NamedThreadFactory(String prefix) {
            SecurityManager sm = System.getSecurityManager();
            this.group = sm == null ? Thread.currentThread().getThreadGroup() : sm.getThreadGroup();
            this.prefix = prefix;
        }

        @Override
        public Thread newThread(Runnable r) {
            String name = this.prefix + this.threadNumber.incrementAndGet();
            Thread thread = new Thread(this.group, r, name);
            thread.setPriority(5);
            return thread;
        }
    }
}

