/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.core.event.pipe;

import java.util.List;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuxeo.ecm.core.event.EventBundle;
import org.nuxeo.ecm.core.event.EventServiceAdmin;
import org.nuxeo.ecm.core.event.impl.AsyncEventExecutor;
import org.nuxeo.ecm.core.event.impl.EventListenerDescriptor;
import org.nuxeo.ecm.core.event.impl.EventListenerList;
import org.nuxeo.ecm.core.event.pipe.AbstractPipeConsumer;
import org.nuxeo.runtime.api.Framework;

public abstract class AbstractListenerPipeConsumer<T>
extends AbstractPipeConsumer<T> {
    private static final Log log = LogFactory.getLog(AbstractListenerPipeConsumer.class);
    protected volatile AsyncEventExecutor asyncExec;
    protected boolean stopping;

    @Override
    public void initConsumer(String name, Map<String, String> params) {
        super.initConsumer(name, params);
        this.asyncExec = new AsyncEventExecutor();
        if (Framework.getRuntime() == null) {
            throw new RuntimeException("Nuxeo Runtime not initialized");
        }
    }

    @Override
    public void shutdown() throws InterruptedException {
        this.stopping = true;
        this.waitForCompletion(1000L);
    }

    @Override
    protected boolean processEventBundles(List<EventBundle> bundles) {
        EventServiceAdmin eventService = (EventServiceAdmin)Framework.getService(EventServiceAdmin.class);
        EventListenerList listeners = eventService.getListenerList();
        List<EventListenerDescriptor> postCommitAsync = listeners.getEnabledAsyncPostCommitListenersDescriptors();
        for (EventBundle eventBundle : bundles) {
            this.asyncExec.run(postCommitAsync, eventBundle);
        }
        return true;
    }

    @Override
    public boolean waitForCompletion(long timeoutMillis) throws InterruptedException {
        return this.asyncExec.waitForCompletion(timeoutMillis);
    }
}

