/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.core.scheduler;

import java.io.IOException;
import java.util.Optional;
import org.apache.commons.logging.LogFactory;
import org.nuxeo.ecm.core.scheduler.SchedulerService;
import org.nuxeo.ecm.core.scheduler.SchedulerServiceImpl;
import org.nuxeo.runtime.api.Framework;
import org.nuxeo.runtime.services.event.Event;
import org.nuxeo.runtime.services.event.EventListener;
import org.quartz.SchedulerException;

public class ReloadListener
implements EventListener {
    public void handleEvent(Event event) {
        if ("before-reload".equals(event.getId())) {
            this.lookup().ifPresent(SchedulerServiceImpl::shutdownScheduler);
        } else if ("after-reload".equals(event.getId())) {
            this.lookup().ifPresent(scheduler -> {
                try {
                    scheduler.setupScheduler();
                }
                catch (IOException | SchedulerException cause) {
                    LogFactory.getLog(ReloadListener.class).error((Object)"Cannot reload scheduler", cause);
                }
            });
        }
    }

    Optional<SchedulerServiceImpl> lookup() {
        SchedulerService scheduler = (SchedulerService)Framework.getService(SchedulerService.class);
        if (scheduler instanceof SchedulerServiceImpl) {
            return Optional.of((SchedulerServiceImpl)scheduler);
        }
        return Optional.empty();
    }
}

