/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.core.work;

import com.codahale.metrics.Counter;
import com.codahale.metrics.MetricRegistry;
import com.codahale.metrics.SharedMetricRegistries;
import com.codahale.metrics.Timer;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.RejectedExecutionException;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.locks.Condition;
import java.util.concurrent.locks.ReentrantLock;
import javax.naming.NamingException;
import javax.transaction.RollbackException;
import javax.transaction.Synchronization;
import javax.transaction.SystemException;
import javax.transaction.Transaction;
import javax.transaction.TransactionManager;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuxeo.common.logging.SequenceTracer;
import org.nuxeo.ecm.core.work.NuxeoBlockingQueue;
import org.nuxeo.ecm.core.work.WorkHolder;
import org.nuxeo.ecm.core.work.WorkQueueRegistry;
import org.nuxeo.ecm.core.work.WorkQueuing;
import org.nuxeo.ecm.core.work.WorkQueuingRegistry;
import org.nuxeo.ecm.core.work.api.Work;
import org.nuxeo.ecm.core.work.api.WorkManager;
import org.nuxeo.ecm.core.work.api.WorkQueueDescriptor;
import org.nuxeo.ecm.core.work.api.WorkQueueMetrics;
import org.nuxeo.ecm.core.work.api.WorkQueuingDescriptor;
import org.nuxeo.ecm.core.work.api.WorkSchedulePath;
import org.nuxeo.runtime.RuntimeServiceEvent;
import org.nuxeo.runtime.RuntimeServiceListener;
import org.nuxeo.runtime.api.Framework;
import org.nuxeo.runtime.metrics.MetricsService;
import org.nuxeo.runtime.model.ComponentContext;
import org.nuxeo.runtime.model.ComponentInstance;
import org.nuxeo.runtime.model.DefaultComponent;
import org.nuxeo.runtime.transaction.TransactionHelper;

public class WorkManagerImpl
extends DefaultComponent
implements WorkManager {
    public static final String NAME = "org.nuxeo.ecm.core.work.service";
    private static final Log log = LogFactory.getLog(WorkManagerImpl.class);
    protected static final String QUEUES_EP = "queues";
    protected static final String IMPL_EP = "implementation";
    public static final String DEFAULT_QUEUE_ID = "default";
    public static final String DEFAULT_CATEGORY = "default";
    protected static final String THREAD_PREFIX = "Nuxeo-Work-";
    protected final MetricRegistry registry = SharedMetricRegistries.getOrCreate((String)MetricsService.class.getName());
    protected final WorkQueueRegistry workQueueConfig = new WorkQueueRegistry();
    protected final WorkQueuingRegistry workQueuingConfig = new WorkQueuingRegistry();
    protected final Map<String, WorkThreadPoolExecutor> executors = new HashMap<String, WorkThreadPoolExecutor>();
    protected WorkQueuing queuing;
    protected WorkCompletionSynchronizer completionSynchronizer;
    protected volatile boolean started = false;
    protected volatile boolean shutdownInProgress = false;

    public void activate(ComponentContext context) {
        Framework.addListener((RuntimeServiceListener)new ShutdownListener());
    }

    public void registerContribution(Object contribution, String extensionPoint, ComponentInstance contributor) {
        if (QUEUES_EP.equals(extensionPoint)) {
            this.registerWorkQueueDescriptor((WorkQueueDescriptor)contribution);
        } else if (IMPL_EP.equals(extensionPoint)) {
            this.registerWorkQueuingDescriptor((WorkQueuingDescriptor)contribution);
        } else {
            throw new RuntimeException("Unknown extension point: " + extensionPoint);
        }
    }

    public void unregisterContribution(Object contribution, String extensionPoint, ComponentInstance contributor) {
        if (QUEUES_EP.equals(extensionPoint)) {
            this.unregisterWorkQueueDescriptor((WorkQueueDescriptor)contribution);
        } else if (IMPL_EP.equals(extensionPoint)) {
            this.unregisterWorkQueuingDescriptor((WorkQueuingDescriptor)contribution);
        } else {
            throw new RuntimeException("Unknown extension point: " + extensionPoint);
        }
    }

    void registerWorkQueueDescriptor(WorkQueueDescriptor workQueueDescriptor) {
        String queueId = workQueueDescriptor.id;
        if ("*".equals(queueId)) {
            Boolean processing = workQueueDescriptor.processing;
            if (processing == null) {
                log.error((Object)"Ignoring work queue descriptor * with no processing/queuing");
                return;
            }
            String what = " processing=" + processing;
            what = what + (this.queuing == null ? "" : " queuing=" + this.queuing);
            log.info((Object)("Setting on all work queues:" + what));
            ArrayList<String> queueIds = new ArrayList<String>(this.workQueueConfig.getQueueIds());
            for (String id : queueIds) {
                WorkQueueDescriptor wqd = new WorkQueueDescriptor();
                wqd.id = id;
                wqd.processing = processing;
                this.registerWorkQueueDescriptor(wqd);
            }
            return;
        }
        this.workQueueConfig.addContribution(workQueueDescriptor);
        WorkQueueDescriptor wqd = this.workQueueConfig.get(queueId);
        log.info((Object)("Registered work queue " + queueId + " " + wqd.toString()));
    }

    void unregisterWorkQueueDescriptor(WorkQueueDescriptor workQueueDescriptor) {
        String id = workQueueDescriptor.id;
        if ("*".equals(id)) {
            return;
        }
        this.workQueueConfig.removeContribution(workQueueDescriptor);
        log.info((Object)("Unregistered work queue " + id));
    }

    void initializeQueue(WorkQueueDescriptor config) {
        if ("*".equals(config.id)) {
            throw new IllegalArgumentException("cannot initialize all queues");
        }
        if (this.queuing.getQueue(config.id) != null) {
            throw new IllegalStateException("work queue " + config.id + " is already initialized");
        }
        if (this.executors.containsKey(config.id)) {
            throw new IllegalStateException("work queue " + config.id + " already have an executor");
        }
        NuxeoBlockingQueue queue = this.queuing.init(config);
        NamedThreadFactory threadFactory = new NamedThreadFactory(THREAD_PREFIX + config.id + "-");
        int maxPoolSize = config.getMaxThreads();
        WorkThreadPoolExecutor executor = new WorkThreadPoolExecutor(maxPoolSize, maxPoolSize, 0L, TimeUnit.SECONDS, queue, threadFactory);
        executor.prestartAllCoreThreads();
        this.executors.put(config.id, executor);
        log.info((Object)("Initialized work queue " + config.id + " " + config.toEffectiveString()));
    }

    void activateQueue(WorkQueueDescriptor config) {
        if ("*".equals(config.id)) {
            throw new IllegalArgumentException("cannot activate all queues");
        }
        this.queuing.setActive(config.id, config.isProcessingEnabled());
        log.info((Object)("Activated work queue " + config.id + " " + config.toEffectiveString()));
    }

    void deactivateQueue(WorkQueueDescriptor config) {
        if ("*".equals(config.id)) {
            throw new IllegalArgumentException("cannot deactivate all queues");
        }
        this.queuing.setActive(config.id, false);
        log.info((Object)("Deactivated work queue " + config.id));
    }

    void registerWorkQueuingDescriptor(WorkQueuingDescriptor descr) {
        this.workQueuingConfig.addContribution(descr);
    }

    void unregisterWorkQueuingDescriptor(WorkQueuingDescriptor descr) {
        this.workQueuingConfig.removeContribution(descr);
    }

    protected WorkQueuing newWorkQueuing(Class<? extends WorkQueuing> klass) {
        try {
            return klass.getDeclaredConstructor(WorkQueuing.Listener.class).newInstance(WorkQueuing.Listener.lookupListener());
        }
        catch (ReflectiveOperationException | SecurityException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public boolean isQueuingEnabled(String queueId) {
        WorkQueueDescriptor wqd = this.getWorkQueueDescriptor(queueId);
        return wqd != null && wqd.isQueuingEnabled();
    }

    @Override
    public void enableProcessing(boolean value) {
        for (String queueId : this.workQueueConfig.getQueueIds()) {
            this.queuing.getQueue(queueId).setActive(value);
        }
    }

    @Override
    public void enableProcessing(String queueId, boolean value) throws InterruptedException {
        WorkQueueDescriptor config = this.workQueueConfig.get(queueId);
        if (config == null) {
            throw new IllegalArgumentException("no such queue " + queueId);
        }
        if (!value) {
            this.deactivateQueue(config);
        } else {
            this.activateQueue(config);
        }
    }

    @Override
    public boolean isProcessingEnabled() {
        for (String queueId : this.workQueueConfig.getQueueIds()) {
            if (!this.queuing.getQueue((String)queueId).active) continue;
            return true;
        }
        return false;
    }

    @Override
    public boolean isProcessingEnabled(String queueId) {
        if (queueId == null) {
            return this.isProcessingEnabled();
        }
        return this.queuing.getQueue((String)queueId).active;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<String> getWorkQueueIds() {
        WorkQueueRegistry workQueueRegistry = this.workQueueConfig;
        synchronized (workQueueRegistry) {
            return this.workQueueConfig.getQueueIds();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public WorkQueueDescriptor getWorkQueueDescriptor(String queueId) {
        WorkQueueRegistry workQueueRegistry = this.workQueueConfig;
        synchronized (workQueueRegistry) {
            return this.workQueueConfig.get(queueId);
        }
    }

    @Override
    public String getCategoryQueueId(String category) {
        String queueId;
        if (category == null) {
            category = "default";
        }
        if ((queueId = this.workQueueConfig.getQueueId(category)) == null) {
            queueId = "default";
        }
        return queueId;
    }

    public int getApplicationStartedOrder() {
        return -501;
    }

    public void applicationStarted(ComponentContext context) {
        this.init();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void init() {
        if (this.started) {
            return;
        }
        WorkManagerImpl workManagerImpl = this;
        synchronized (workManagerImpl) {
            if (this.started) {
                return;
            }
            this.queuing = this.newWorkQueuing(this.workQueuingConfig.klass);
            this.completionSynchronizer = new WorkCompletionSynchronizer();
            this.started = true;
            this.workQueueConfig.index();
            for (String id : this.workQueueConfig.getQueueIds()) {
                this.initializeQueue(this.workQueueConfig.get(id));
            }
            for (String id : this.workQueueConfig.getQueueIds()) {
                this.activateQueue(this.workQueueConfig.get(id));
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected WorkThreadPoolExecutor getExecutor(String queueId) {
        WorkQueueDescriptor workQueueDescriptor;
        if (!this.started) {
            if (Framework.isTestModeSet() && !Framework.getRuntime().isShuttingDown()) {
                LogFactory.getLog(WorkManagerImpl.class).warn((Object)"Lazy starting of work manager in test mode");
                this.init();
            } else {
                throw new IllegalStateException("Work manager not started, could not access to executors");
            }
        }
        WorkQueueRegistry workQueueRegistry = this.workQueueConfig;
        synchronized (workQueueRegistry) {
            workQueueDescriptor = this.workQueueConfig.get(queueId);
        }
        if (workQueueDescriptor == null) {
            throw new IllegalArgumentException("No such work queue: " + queueId);
        }
        return this.executors.get(queueId);
    }

    @Override
    public boolean shutdownQueue(String queueId, long timeout, TimeUnit unit) throws InterruptedException {
        WorkThreadPoolExecutor executor = this.getExecutor(queueId);
        return this.shutdownExecutors(Collections.singleton(executor), timeout, unit);
    }

    protected boolean shutdownExecutors(Collection<WorkThreadPoolExecutor> list, long timeout, TimeUnit unit) throws InterruptedException {
        for (WorkThreadPoolExecutor executor : list) {
            executor.shutdownAndSuspend();
        }
        timeout = TimeUnit.MILLISECONDS.convert(timeout, unit);
        for (WorkThreadPoolExecutor executor : list) {
            long t0 = System.currentTimeMillis();
            if (!executor.awaitTermination(timeout, TimeUnit.MILLISECONDS)) {
                return false;
            }
            timeout -= unit.convert(System.currentTimeMillis() - t0, TimeUnit.MILLISECONDS);
        }
        return true;
    }

    protected long remainingMillis(long t0, long delay) {
        long d = System.currentTimeMillis() - t0;
        if (d > delay) {
            return 0L;
        }
        return delay - d;
    }

    protected synchronized void removeExecutor(String queueId) {
        this.executors.remove(queueId);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean shutdown(long timeout, TimeUnit unit) throws InterruptedException {
        this.shutdownInProgress = true;
        try {
            boolean bl = this.shutdownExecutors(new ArrayList<WorkThreadPoolExecutor>(this.executors.values()), timeout, unit);
            return bl;
        }
        finally {
            this.shutdownInProgress = false;
            this.started = false;
        }
    }

    @Override
    public void schedule(Work work) {
        this.schedule(work, WorkManager.Scheduling.ENQUEUE, false);
    }

    @Override
    public void schedule(Work work, boolean afterCommit) {
        this.schedule(work, WorkManager.Scheduling.ENQUEUE, afterCommit);
    }

    @Override
    public void schedule(Work work, WorkManager.Scheduling scheduling) {
        this.schedule(work, scheduling, false);
    }

    @Override
    public void schedule(Work work, WorkManager.Scheduling scheduling, boolean afterCommit) {
        String workId = work.getId();
        String queueId = this.getCategoryQueueId(work.getCategory());
        if (!this.isQueuingEnabled(queueId)) {
            return;
        }
        if (afterCommit && this.scheduleAfterCommit(work, scheduling)) {
            return;
        }
        work.setWorkInstanceState(Work.State.SCHEDULED);
        WorkSchedulePath.newInstance(work);
        switch (scheduling) {
            case ENQUEUE: {
                break;
            }
            case CANCEL_SCHEDULED: {
                this.getExecutor(queueId).removeScheduled(workId);
                break;
            }
            case IF_NOT_SCHEDULED: 
            case IF_NOT_RUNNING_OR_SCHEDULED: {
                boolean disabled = Boolean.TRUE;
                if (disabled || !this.hasWorkInState(workId, scheduling.state)) break;
                if (log.isDebugEnabled()) {
                    log.debug((Object)("Canceling schedule because found: " + (Object)((Object)scheduling)));
                }
                return;
            }
        }
        this.queuing.workSchedule(queueId, work);
    }

    protected boolean scheduleAfterCommit(Work work, WorkManager.Scheduling scheduling) {
        TransactionManager transactionManager;
        try {
            transactionManager = TransactionHelper.lookupTransactionManager();
        }
        catch (NamingException e) {
            transactionManager = null;
        }
        if (transactionManager == null) {
            if (log.isDebugEnabled()) {
                log.debug((Object)("Not scheduling work after commit because of missing transaction manager: " + work));
            }
            return false;
        }
        try {
            Transaction transaction = transactionManager.getTransaction();
            if (transaction == null) {
                if (log.isDebugEnabled()) {
                    log.debug((Object)("Not scheduling work after commit because of missing transaction: " + work));
                }
                return false;
            }
            int status = transaction.getStatus();
            if (status == 0) {
                if (log.isDebugEnabled()) {
                    log.debug((Object)("Scheduling work after commit: " + work));
                }
                transaction.registerSynchronization((Synchronization)new WorkScheduling(work, scheduling));
                return true;
            }
            if (status == 3) {
                if (log.isDebugEnabled()) {
                    log.debug((Object)("Scheduling work immediately: " + work));
                }
                return false;
            }
            if (status == 1) {
                if (log.isDebugEnabled()) {
                    log.debug((Object)("Cancelling schedule because transaction marked rollback-only: " + work));
                }
                return true;
            }
            if (log.isDebugEnabled()) {
                log.debug((Object)("Not scheduling work after commit because transaction is in status " + status + ": " + work));
            }
            return false;
        }
        catch (RollbackException | SystemException e) {
            log.error((Object)"Cannot schedule after commit", e);
            return false;
        }
    }

    @Override
    public Work find(String workId, Work.State state) {
        return this.queuing.find(workId, state);
    }

    protected boolean hasWorkInState(String workId, Work.State state) {
        return this.queuing.isWorkInState(workId, state);
    }

    @Override
    public Work.State getWorkState(String workId) {
        return this.queuing.getWorkState(workId);
    }

    @Override
    public List<Work> listWork(String queueId, Work.State state) {
        return this.queuing.listWork(queueId, state);
    }

    @Override
    public List<String> listWorkIds(String queueId, Work.State state) {
        return this.queuing.listWorkIds(queueId, state);
    }

    @Override
    public WorkQueueMetrics getMetrics(String queueId) {
        return this.queuing.metrics(queueId);
    }

    @Override
    public int getQueueSize(String queueId, Work.State state) {
        WorkQueueMetrics metrics = this.getMetrics(queueId);
        if (state == null) {
            return metrics.scheduled.intValue() + metrics.running.intValue();
        }
        if (state == Work.State.SCHEDULED) {
            return metrics.scheduled.intValue();
        }
        if (state == Work.State.RUNNING) {
            return metrics.running.intValue();
        }
        throw new IllegalArgumentException(String.valueOf((Object)state));
    }

    @Override
    public boolean awaitCompletion(long duration, TimeUnit unit) throws InterruptedException {
        return this.awaitCompletion(null, duration, unit);
    }

    @Override
    public boolean awaitCompletion(String queueId, long duration, TimeUnit unit) throws InterruptedException {
        if (!this.isStarted()) {
            return true;
        }
        SequenceTracer.start((String)("awaitCompletion on " + (queueId == null ? "all queues" : queueId)));
        long durationInMs = TimeUnit.MILLISECONDS.convert(duration, unit);
        long deadline = this.getTimestampAfter(durationInMs);
        int pause = (int)Math.min(durationInMs, 500L);
        log.debug((Object)("awaitForCompletion " + durationInMs + " ms"));
        do {
            if (this.noScheduledOrRunningWork(queueId)) {
                this.completionSynchronizer.signalCompletedWork();
                SequenceTracer.stop((String)"done");
                return true;
            }
            this.completionSynchronizer.waitForCompletedWork(pause);
        } while (System.currentTimeMillis() < deadline);
        log.info((Object)("awaitCompletion timeout after " + durationInMs + " ms"));
        SequenceTracer.destroy((String)("timeout after " + durationInMs + " ms"));
        return false;
    }

    protected long getTimestampAfter(long durationInMs) {
        long ret = System.currentTimeMillis() + durationInMs;
        if (ret < 0L) {
            ret = Long.MAX_VALUE;
        }
        return ret;
    }

    protected boolean noScheduledOrRunningWork(String queueId) {
        if (queueId == null) {
            for (String id : this.getWorkQueueIds()) {
                if (this.noScheduledOrRunningWork(id)) continue;
                return false;
            }
            return true;
        }
        if (!this.isProcessingEnabled(queueId)) {
            return this.getExecutor((String)queueId).runningCount.getCount() == 0L;
        }
        if (this.getQueueSize(queueId, null) > 0) {
            if (log.isTraceEnabled()) {
                log.trace((Object)(queueId + " not empty, sched: " + this.getQueueSize(queueId, Work.State.SCHEDULED) + ", running: " + this.getQueueSize(queueId, Work.State.RUNNING)));
            }
            return false;
        }
        if (log.isTraceEnabled()) {
            log.trace((Object)(queueId + " is completed"));
        }
        return true;
    }

    @Override
    public boolean isStarted() {
        return this.started && !this.shutdownInProgress;
    }

    protected class WorkThreadPoolExecutor
    extends ThreadPoolExecutor {
        protected final String queueId;
        protected final ConcurrentLinkedQueue<Work> running;
        protected final Counter scheduledCount;
        protected final Counter runningCount;
        protected final Counter completedCount;
        protected final Timer workTimer;

        protected WorkThreadPoolExecutor(int corePoolSize, int maximumPoolSize, long keepAliveTime, TimeUnit unit, NuxeoBlockingQueue queue, ThreadFactory threadFactory) {
            super(corePoolSize, maximumPoolSize, keepAliveTime, unit, (BlockingQueue<Runnable>)queue, threadFactory);
            this.queueId = queue.queueId;
            this.running = new ConcurrentLinkedQueue();
            this.scheduledCount = WorkManagerImpl.this.registry.counter(MetricRegistry.name((String)"nuxeo", (String[])new String[]{"works", this.queueId, "scheduled", "count"}));
            this.runningCount = WorkManagerImpl.this.registry.counter(MetricRegistry.name((String)"nuxeo", (String[])new String[]{"works", this.queueId, "running"}));
            this.completedCount = WorkManagerImpl.this.registry.counter(MetricRegistry.name((String)"nuxeo", (String[])new String[]{"works", this.queueId, "completed"}));
            this.workTimer = WorkManagerImpl.this.registry.timer(MetricRegistry.name((String)"nuxeo", (String[])new String[]{"works", this.queueId, "total"}));
        }

        public int getScheduledOrRunningSize() {
            int ret = 0;
            for (String queueId : WorkManagerImpl.this.getWorkQueueIds()) {
                ret += WorkManagerImpl.this.getQueueSize(queueId, null);
            }
            return ret;
        }

        @Override
        public void execute(Runnable r) {
            throw new UnsupportedOperationException("use other api");
        }

        public void execute(Work work) {
            this.scheduledCount.inc();
            this.submit(work);
        }

        protected void submit(Work work) throws RuntimeException {
            WorkManagerImpl.this.queuing.workSchedule(this.queueId, work);
        }

        @Override
        protected void beforeExecute(Thread t, Runnable r) {
            Work work = WorkHolder.getWork(r);
            if (this.isShutdown()) {
                work.setWorkInstanceState(Work.State.SCHEDULED);
                WorkManagerImpl.this.queuing.workReschedule(this.queueId, work);
                throw new RejectedExecutionException(this.queueId + " was shutdown, rescheduled " + work);
            }
            work.setWorkInstanceState(Work.State.RUNNING);
            WorkManagerImpl.this.queuing.workRunning(this.queueId, work);
            this.running.add(work);
            this.runningCount.inc();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        protected void afterExecute(Runnable r, Throwable t) {
            Work work = WorkHolder.getWork(r);
            try {
                if (work.isSuspending()) {
                    log.trace((Object)(work + " is suspending, giving up"));
                    return;
                }
                if (this.isShutdown()) {
                    log.trace((Object)("rescheduling " + work.getId()), t);
                    work.setWorkInstanceState(Work.State.SCHEDULED);
                    WorkManagerImpl.this.queuing.workReschedule(this.queueId, work);
                    return;
                }
                work.setWorkInstanceState(Work.State.UNKNOWN);
                WorkManagerImpl.this.queuing.workCompleted(this.queueId, work);
            }
            finally {
                this.running.remove(work);
                this.runningCount.dec();
                this.completedCount.inc();
                this.workTimer.update(work.getCompletionTime() - work.getStartTime(), TimeUnit.MILLISECONDS);
                WorkManagerImpl.this.completionSynchronizer.signalCompletedWork();
            }
        }

        public void shutdownAndSuspend() throws InterruptedException {
            try {
                WorkManagerImpl.this.queuing.setActive(this.queueId, false);
                for (Work work : this.running) {
                    work.setWorkInstanceSuspending();
                    log.trace((Object)("suspending and rescheduling " + work.getId()));
                    work.setWorkInstanceState(Work.State.SCHEDULED);
                    WorkManagerImpl.this.queuing.workReschedule(this.queueId, work);
                }
                this.shutdownNow();
            }
            finally {
                WorkManagerImpl.this.executors.remove(this.queueId);
            }
        }

        public void removeScheduled(String workId) {
            WorkManagerImpl.this.queuing.removeScheduled(this.queueId, workId);
        }
    }

    private static class NamedThreadFactory
    implements ThreadFactory {
        private final AtomicInteger threadNumber = new AtomicInteger();
        private final ThreadGroup group;
        private final String prefix;

        public NamedThreadFactory(String prefix) {
            SecurityManager sm = System.getSecurityManager();
            this.group = sm == null ? Thread.currentThread().getThreadGroup() : sm.getThreadGroup();
            this.prefix = prefix;
        }

        @Override
        public Thread newThread(Runnable r) {
            String name = this.prefix + this.threadNumber.incrementAndGet();
            Thread thread = new Thread(this.group, r, name);
            thread.setPriority(5);
            thread.setUncaughtExceptionHandler((t, e) -> LogFactory.getLog(WorkManagerImpl.class).error((Object)("Uncaught error on thread " + t.getName()), e));
            return thread;
        }
    }

    public class WorkScheduling
    implements Synchronization {
        public final Work work;
        public final WorkManager.Scheduling scheduling;

        public WorkScheduling(Work work, WorkManager.Scheduling scheduling) {
            this.work = work;
            this.scheduling = scheduling;
        }

        public void beforeCompletion() {
        }

        public void afterCompletion(int status) {
            if (status == 3) {
                WorkManagerImpl.this.schedule(this.work, this.scheduling, false);
            } else if (status == 4) {
                this.work.setWorkInstanceState(Work.State.UNKNOWN);
            } else {
                throw new IllegalArgumentException("Unsupported transaction status " + status);
            }
        }
    }

    protected class ShutdownListener
    implements RuntimeServiceListener {
        protected ShutdownListener() {
        }

        public void handleEvent(RuntimeServiceEvent event) {
            if (2 != event.id) {
                return;
            }
            Framework.removeListener((RuntimeServiceListener)this);
            try {
                if (!WorkManagerImpl.this.shutdown(10L, TimeUnit.SECONDS)) {
                    log.error((Object)"Some processors are still active");
                }
            }
            catch (InterruptedException cause) {
                Thread.currentThread().interrupt();
                log.error((Object)"Interrupted during works manager shutdown, continuing runtime shutdown", (Throwable)cause);
            }
        }
    }

    protected class WorkCompletionSynchronizer {
        protected final ReentrantLock lock = new ReentrantLock();
        protected final Condition condition = this.lock.newCondition();

        protected WorkCompletionSynchronizer() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        protected boolean waitForCompletedWork(long timeMs) throws InterruptedException {
            this.lock.lock();
            try {
                boolean bl = this.condition.await(timeMs, TimeUnit.MILLISECONDS);
                return bl;
            }
            finally {
                this.lock.unlock();
            }
        }

        protected void signalCompletedWork() {
            this.lock.lock();
            try {
                this.condition.signalAll();
            }
            finally {
                this.lock.unlock();
            }
        }
    }
}

