/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.runtime.api;

import java.util.Hashtable;
import java.util.Map;
import org.nuxeo.runtime.api.ServiceProvider;

public class DefaultServiceProvider
implements ServiceProvider {
    private static ServiceProvider provider;
    protected final Map<Class<?>, ServiceRef> registry = new Hashtable();

    public static void setProvider(ServiceProvider provider) {
        DefaultServiceProvider.provider = provider;
    }

    public static ServiceProvider getProvider() {
        return provider;
    }

    @Override
    public <T> T getService(Class<T> serviceClass) {
        ServiceRef ref = this.registry.get(serviceClass);
        if (ref != null) {
            return (T)ref.getService();
        }
        return null;
    }

    public <T> void registerService(Class<T> serviceClass, Class<?> implClass) {
        this.registry.put(serviceClass, new ServiceRef(implClass));
    }

    public <T> void registerService(Class<T> serviceClass, Object impl) {
        this.registry.put(serviceClass, new ServiceRef(impl));
    }

    public static class ServiceRef {
        final Class<?> type;
        Object service;

        public ServiceRef(Object service) {
            this.service = service;
            this.type = service.getClass();
        }

        public ServiceRef(Class<?> type) {
            this.service = null;
            this.type = type;
        }

        public Class<?> getType() {
            return this.type;
        }

        public Object getService() {
            if (this.service == null) {
                try {
                    this.service = this.type.newInstance();
                }
                catch (ReflectiveOperationException e) {
                    throw new RuntimeException(e);
                }
            }
            return this.service;
        }
    }
}

