/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.runtime.deploy;

import java.util.ArrayList;
import java.util.List;
import org.nuxeo.runtime.deploy.ContributionManager;
import org.nuxeo.runtime.deploy.ExtensibleContribution;

public abstract class CompositeContribution
extends ExtensibleContribution {
    protected final List<CompositeContribution> contributionFragments = new ArrayList<CompositeContribution>();
    private boolean isContributionEnabled;

    @Override
    public void resolve(ContributionManager mgr) {
        super.resolve(mgr);
        if (this.baseContribution instanceof CompositeContribution) {
            ((CompositeContribution)this.baseContribution).addContributionFragment(this);
        }
    }

    @Override
    public void unresolve(ContributionManager mgr) {
        if (this.baseContribution instanceof CompositeContribution) {
            ((CompositeContribution)this.baseContribution).removeContributionFragment(this);
        }
        super.unresolve(mgr);
    }

    public boolean isContributionEnabled() {
        return this.isContributionEnabled;
    }

    private void setContributionEnabled(boolean isEnabled) {
        this.isContributionEnabled = isEnabled;
    }

    private void addContributionFragment(CompositeContribution fragment) {
        fragment.setContributionEnabled(true);
        int index = this.contributionFragments.indexOf(fragment);
        if (index > -1) {
            this.contributionFragments.set(index, fragment);
        } else {
            this.contributionFragments.add(fragment);
        }
    }

    private void removeContributionFragment(CompositeContribution fragment) {
        int index = this.contributionFragments.indexOf(fragment);
        if (index > -1) {
            this.contributionFragments.get(index).setContributionEnabled(false);
        }
    }

    public List<CompositeContribution> getContributionFragments() {
        return this.contributionFragments;
    }

    private CompositeContribution getRootComposite() {
        if (this.baseContribution instanceof CompositeContribution) {
            return ((CompositeContribution)this.baseContribution).getRootComposite();
        }
        return this;
    }

    @Override
    protected ExtensibleContribution getMergedContribution() {
        CompositeContribution root = this.getRootComposite();
        ExtensibleContribution mc = root.baseContribution != null ? root.baseContribution.getMergedContribution() : root.clone();
        for (CompositeContribution fragment : root.contributionFragments) {
            if (!fragment.isContributionEnabled()) continue;
            this.copyFragmentsOver(mc);
        }
        mc.contributionId = root.contributionId;
        mc.baseContributionId = root.baseContributionId;
        return mc;
    }

    private void copyFragmentsOver(ExtensibleContribution mc) {
        this.copyOver(mc);
        for (CompositeContribution fragment : this.contributionFragments) {
            if (!fragment.isContributionEnabled()) continue;
            fragment.copyFragmentsOver(mc);
        }
    }

    @Override
    public String toString() {
        if (this.baseContributionId == null) {
            return this.contributionId;
        }
        return this.contributionId + "@" + this.baseContributionId;
    }
}

