/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.runtime.model.impl;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuxeo.common.collections.ListenerList;
import org.nuxeo.runtime.ComponentEvent;
import org.nuxeo.runtime.ComponentListener;
import org.nuxeo.runtime.RuntimeService;
import org.nuxeo.runtime.api.Framework;
import org.nuxeo.runtime.model.ComponentInstance;
import org.nuxeo.runtime.model.ComponentManager;
import org.nuxeo.runtime.model.ComponentName;
import org.nuxeo.runtime.model.Extension;
import org.nuxeo.runtime.model.RegistrationInfo;
import org.nuxeo.runtime.model.impl.ComponentInstanceImpl;
import org.nuxeo.runtime.model.impl.ComponentRegistry;
import org.nuxeo.runtime.model.impl.ExtensionPointImpl;
import org.nuxeo.runtime.model.impl.RegistrationInfoImpl;
import org.nuxeo.runtime.model.impl.ShutdownTask;

public class ComponentManagerImpl
implements ComponentManager {
    private static final Log log = LogFactory.getLog(ComponentManagerImpl.class);
    protected final Map<ComponentName, Set<Extension>> pendingExtensions;
    private ListenerList listeners;
    private final Map<String, RegistrationInfoImpl> services;
    protected Set<String> blacklist;
    protected ComponentRegistry reg = new ComponentRegistry();

    public ComponentManagerImpl(RuntimeService runtime) {
        this.pendingExtensions = new HashMap<ComponentName, Set<Extension>>();
        this.listeners = new ListenerList();
        this.services = new ConcurrentHashMap<String, RegistrationInfoImpl>();
        this.blacklist = new HashSet<String>();
    }

    @Override
    public synchronized Collection<RegistrationInfo> getRegistrations() {
        return new ArrayList<RegistrationInfo>(this.reg.getComponents());
    }

    @Override
    public synchronized Map<ComponentName, Set<ComponentName>> getPendingRegistrations() {
        HashMap<ComponentName, Set<ComponentName>> pending = new HashMap<ComponentName, Set<ComponentName>>();
        for (Map.Entry<ComponentName, Set<ComponentName>> p : this.reg.getPendingComponents().entrySet()) {
            pending.put(p.getKey(), new LinkedHashSet(p.getValue()));
        }
        return pending;
    }

    @Override
    public synchronized Map<ComponentName, Set<Extension>> getMissingRegistrations() {
        HashMap<ComponentName, Set<Extension>> missing = new HashMap<ComponentName, Set<Extension>>();
        for (Set<Extension> p : this.pendingExtensions.values()) {
            for (Extension e : p) {
                missing.computeIfAbsent(e.getComponent().getName(), k -> new LinkedHashSet()).add(e);
            }
        }
        return missing;
    }

    public synchronized Collection<ComponentName> getNeededRegistrations() {
        return this.pendingExtensions.keySet();
    }

    public synchronized Collection<Extension> getPendingExtensions(ComponentName name) {
        return this.pendingExtensions.get(name);
    }

    @Override
    public synchronized RegistrationInfo getRegistrationInfo(ComponentName name) {
        return this.reg.getComponent(name);
    }

    @Override
    public synchronized boolean isRegistered(ComponentName name) {
        return this.reg.contains(name);
    }

    @Override
    public synchronized int size() {
        return this.reg.size();
    }

    @Override
    public synchronized ComponentInstance getComponent(ComponentName name) {
        RegistrationInfoImpl ri = this.reg.getComponent(name);
        return ri != null ? ri.getComponent() : null;
    }

    @Override
    public synchronized void shutdown() {
        ShutdownTask.shutdown(this);
        this.listeners = null;
        this.reg.destroy();
        this.reg = null;
    }

    @Override
    public Set<String> getBlacklist() {
        return Collections.unmodifiableSet(this.blacklist);
    }

    @Override
    public void setBlacklist(Set<String> blacklist) {
        this.blacklist = blacklist;
    }

    @Override
    public synchronized void register(RegistrationInfo regInfo) {
        RegistrationInfoImpl ri = (RegistrationInfoImpl)regInfo;
        ComponentName name = ri.getName();
        if (this.blacklist.contains(name.getName())) {
            log.warn((Object)("Component " + name.getName() + " was blacklisted. Ignoring."));
            return;
        }
        if (this.reg.contains(name)) {
            if (name.getName().startsWith("org.nuxeo.runtime.")) {
                return;
            }
            ComponentManagerImpl.handleError("Duplicate component name: " + name, null);
            return;
        }
        for (ComponentName n : ri.getAliases()) {
            if (!this.reg.contains(n)) continue;
            ComponentManagerImpl.handleError("Duplicate component name: " + n + " (alias for " + name + ")", null);
            return;
        }
        ri.attach(this);
        try {
            log.info((Object)("Registering component: " + name));
            if (!this.reg.addComponent(ri)) {
                log.info((Object)("Registration delayed for component: " + name + ". Waiting for: " + this.reg.getMissingDependencies(ri.getName())));
            }
        }
        catch (RuntimeException e) {
            ComponentManagerImpl.handleError("Failed to register component: " + name + " (" + e.toString() + ')', e);
            return;
        }
    }

    @Override
    public synchronized void unregister(RegistrationInfo regInfo) {
        this.unregister(regInfo.getName());
    }

    @Override
    public synchronized void unregister(ComponentName name) {
        try {
            log.info((Object)("Unregistering component: " + name));
            this.reg.removeComponent(name);
        }
        catch (RuntimeException e) {
            log.error((Object)("Failed to unregister component: " + name), (Throwable)e);
        }
    }

    @Override
    public void addComponentListener(ComponentListener listener) {
        this.listeners.add((Object)listener);
    }

    @Override
    public void removeComponentListener(ComponentListener listener) {
        this.listeners.remove((Object)listener);
    }

    @Override
    public ComponentInstance getComponentProvidingService(Class<?> serviceClass) {
        RegistrationInfoImpl ri = this.services.get(serviceClass.getName());
        if (ri == null) {
            return null;
        }
        if (ri.isResolved()) {
            ri.activate();
        }
        if (ri.isActivated()) {
            return ri.getComponent();
        }
        log.debug((Object)("The component exposing the service " + serviceClass + " is not resolved or not started"));
        return null;
    }

    @Override
    public <T> T getService(Class<T> serviceClass) {
        ComponentInstance comp = this.getComponentProvidingService(serviceClass);
        return comp != null ? (T)comp.getAdapter(serviceClass) : null;
    }

    @Override
    public Collection<ComponentName> getActivatingRegistrations() {
        return this.getRegistrations(4);
    }

    @Override
    public Collection<ComponentName> getStartFailureRegistrations() {
        return this.getRegistrations(6);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Collection<ComponentName> getRegistrations(int state) {
        RegistrationInfoImpl[] comps = null;
        ComponentManagerImpl componentManagerImpl = this;
        synchronized (componentManagerImpl) {
            comps = this.reg.getComponentsArray();
        }
        ArrayList<ComponentName> ret = new ArrayList<ComponentName>();
        for (RegistrationInfoImpl ri : comps) {
            if (ri.getState() != state) continue;
            ret.add(ri.getName());
        }
        return ret;
    }

    void sendEvent(ComponentEvent event) {
        Object[] listeners;
        log.debug((Object)("Dispatching event: " + event));
        for (Object listener : listeners = this.listeners.getListeners()) {
            ((ComponentListener)listener).handleEvent(event);
        }
    }

    public synchronized void registerExtension(Extension extension) {
        ComponentName name = extension.getTargetComponent();
        RegistrationInfoImpl ri = this.reg.getComponent(name);
        if (ri != null && ri.component != null) {
            if (log.isDebugEnabled()) {
                log.debug((Object)("Register contributed extension: " + extension));
            }
            ComponentManagerImpl.loadContributions(ri, extension);
            ri.component.registerExtension(extension);
            this.sendEvent(new ComponentEvent(9, ((ComponentInstanceImpl)extension.getComponent()).ri, extension));
        } else {
            Set<Extension> extensions;
            if (log.isDebugEnabled()) {
                log.debug((Object)("Enqueue contributed extension to pending queue: " + extension));
            }
            if ((extensions = this.pendingExtensions.get(name)) == null) {
                extensions = new LinkedHashSet<Extension>();
                this.pendingExtensions.put(name, extensions);
            }
            extensions.add(extension);
            this.sendEvent(new ComponentEvent(11, ((ComponentInstanceImpl)extension.getComponent()).ri, extension));
        }
    }

    public synchronized void unregisterExtension(Extension extension) {
        ComponentName name;
        RegistrationInfoImpl ri;
        if (log.isDebugEnabled()) {
            log.debug((Object)("Unregister contributed extension: " + extension));
        }
        if ((ri = this.reg.getComponent(name = extension.getTargetComponent())) != null) {
            ComponentInstance co = ri.getComponent();
            if (co != null) {
                co.unregisterExtension(extension);
            }
        } else {
            Set<Extension> extensions = this.pendingExtensions.get(name);
            if (extensions != null) {
                extensions.remove(name);
                if (extensions.isEmpty()) {
                    this.pendingExtensions.remove(name);
                }
            }
        }
        this.sendEvent(new ComponentEvent(10, ((ComponentInstanceImpl)extension.getComponent()).ri, extension));
    }

    public static void loadContributions(RegistrationInfoImpl ri, Extension xt) {
        ExtensionPointImpl xp = ri.getExtensionPoint(xt.getExtensionPoint());
        if (xp != null && xp.contributions != null) {
            try {
                Object[] contribs = xp.loadContributions(ri, xt);
                xt.setContributions(contribs);
            }
            catch (RuntimeException e) {
                ComponentManagerImpl.handleError("Failed to load contributions for component " + xt.getComponent().getName(), e);
            }
        }
    }

    public synchronized void registerServices(RegistrationInfoImpl ri) {
        if (ri.serviceDescriptor == null) {
            return;
        }
        for (String service : ri.serviceDescriptor.services) {
            log.info((Object)("Registering service: " + service));
            this.services.put(service, ri);
        }
    }

    public synchronized void unregisterServices(RegistrationInfoImpl ri) {
        if (ri.serviceDescriptor == null) {
            return;
        }
        for (String service : ri.serviceDescriptor.services) {
            this.services.remove(service);
        }
    }

    @Override
    public synchronized String[] getServices() {
        return this.services.keySet().toArray(new String[this.services.size()]);
    }

    protected static void handleError(String message, Exception e) {
        log.error((Object)message, (Throwable)e);
        Framework.getRuntime().getWarnings().add(message);
    }
}

