/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.core.schema;

import java.util.Collections;
import java.util.Map;
import java.util.Set;

public class PropertyDeprecationHandler {
    protected final Map<String, Map<String, String>> properties;

    public PropertyDeprecationHandler(Map<String, Map<String, String>> properties) {
        this.properties = properties;
    }

    public boolean hasMarkedProperties(String schema) {
        return this.properties.containsKey(schema);
    }

    public Set<String> getProperties(String schema) {
        Map<String, String> schemaProperties = this.properties.get(schema);
        if (schemaProperties == null) {
            return Collections.emptySet();
        }
        return Collections.unmodifiableSet(schemaProperties.keySet());
    }

    public boolean isMarked(String schema, String name) {
        Map<String, String> schemaProperties = this.properties.get(schema);
        return schemaProperties != null && schemaProperties.containsKey(name);
    }

    public String getFallback(String schema, String name) {
        Map<String, String> schemaProperties = this.properties.get(schema);
        if (schemaProperties != null) {
            return schemaProperties.get(name);
        }
        return null;
    }
}

