/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.core.schema;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.commons.io.FileUtils;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuxeo.common.Environment;
import org.nuxeo.ecm.core.schema.DocumentType;
import org.nuxeo.ecm.core.schema.DocumentTypeDescriptor;
import org.nuxeo.ecm.core.schema.DocumentTypeImpl;
import org.nuxeo.ecm.core.schema.FacetDescriptor;
import org.nuxeo.ecm.core.schema.Namespace;
import org.nuxeo.ecm.core.schema.PrefetchInfo;
import org.nuxeo.ecm.core.schema.PropertyDeprecationDescriptor;
import org.nuxeo.ecm.core.schema.PropertyDeprecationHandler;
import org.nuxeo.ecm.core.schema.ProxiesDescriptor;
import org.nuxeo.ecm.core.schema.SchemaBindingDescriptor;
import org.nuxeo.ecm.core.schema.SchemaDescriptor;
import org.nuxeo.ecm.core.schema.SchemaManager;
import org.nuxeo.ecm.core.schema.TypeConfiguration;
import org.nuxeo.ecm.core.schema.XSDLoader;
import org.nuxeo.ecm.core.schema.XSDTypes;
import org.nuxeo.ecm.core.schema.types.AnyType;
import org.nuxeo.ecm.core.schema.types.ComplexType;
import org.nuxeo.ecm.core.schema.types.CompositeType;
import org.nuxeo.ecm.core.schema.types.CompositeTypeImpl;
import org.nuxeo.ecm.core.schema.types.Field;
import org.nuxeo.ecm.core.schema.types.ListType;
import org.nuxeo.ecm.core.schema.types.QName;
import org.nuxeo.ecm.core.schema.types.Schema;
import org.nuxeo.ecm.core.schema.types.Type;
import org.nuxeo.ecm.core.schema.types.TypeException;
import org.xml.sax.SAXException;

public class SchemaManagerImpl
implements SchemaManager {
    private static final Log log = LogFactory.getLog(SchemaManagerImpl.class);
    protected volatile boolean dirty = true;
    protected Map<String, Type> types = new HashMap<String, Type>();
    protected List<TypeConfiguration> allConfigurations = new ArrayList<TypeConfiguration>();
    protected List<SchemaBindingDescriptor> allSchemas = new ArrayList<SchemaBindingDescriptor>();
    protected List<FacetDescriptor> allFacets = new ArrayList<FacetDescriptor>();
    protected List<DocumentTypeDescriptor> allDocumentTypes = new ArrayList<DocumentTypeDescriptor>();
    protected List<ProxiesDescriptor> allProxies = new ArrayList<ProxiesDescriptor>();
    protected PrefetchInfo prefetchInfo;
    protected boolean clearComplexPropertyBeforeSet;
    protected Map<String, Schema> schemas = new HashMap<String, Schema>();
    protected final Map<String, Schema> uriToSchema = new HashMap<String, Schema>();
    protected final Map<String, Schema> prefixToSchema = new HashMap<String, Schema>();
    protected Map<String, CompositeType> facets = new HashMap<String, CompositeType>();
    protected Set<String> noPerDocumentQueryFacets = new HashSet<String>();
    protected Map<String, DocumentTypeImpl> documentTypes = new HashMap<String, DocumentTypeImpl>();
    protected Map<String, Set<String>> documentTypesExtending = new HashMap<String, Set<String>>();
    protected Map<String, Set<String>> documentTypesForFacet = new HashMap<String, Set<String>>();
    protected List<Schema> proxySchemas = new ArrayList<Schema>();
    protected Set<String> proxySchemaNames = new HashSet<String>();
    private Map<String, Field> fields = new ConcurrentHashMap<String, Field>();
    private File schemaDir;
    public static final String SCHEMAS_DIR_NAME = "schemas";
    public static final boolean CLEAR_COMPLEX_PROP_BEFORE_SET_DEFAULT = true;
    protected List<Runnable> recomputeCallbacks;
    protected Map<String, Map<String, String>> deprecatedProperties = new HashMap<String, Map<String, String>>();
    protected Map<String, Map<String, String>> removedProperties = new HashMap<String, Map<String, String>>();

    public SchemaManagerImpl() {
        this.recomputeCallbacks = new ArrayList<Runnable>();
        this.schemaDir = new File(Environment.getDefault().getTemp(), SCHEMAS_DIR_NAME);
        this.schemaDir.mkdirs();
        this.clearSchemaDir();
        this.registerBuiltinTypes();
    }

    protected void clearSchemaDir() {
        try {
            FileUtils.cleanDirectory((File)this.schemaDir);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public File getSchemasDir() {
        return this.schemaDir;
    }

    protected void registerBuiltinTypes() {
        for (Type type : XSDTypes.getTypes()) {
            this.registerType(type);
        }
        this.registerType(AnyType.INSTANCE);
    }

    protected void registerType(Type type) {
        this.types.put(type.getName(), type);
    }

    protected Type getType(String name) {
        return this.types.get(name);
    }

    protected Collection<Type> getTypes() {
        return this.types.values();
    }

    public synchronized void registerConfiguration(TypeConfiguration config) {
        this.allConfigurations.add(config);
        this.dirty = true;
        if (StringUtils.isNotBlank((String)config.prefetchInfo)) {
            log.info((Object)("Registered global prefetch: " + config.prefetchInfo));
        }
        if (config.clearComplexPropertyBeforeSet != null) {
            log.info((Object)("Registered clearComplexPropertyBeforeSet: " + config.clearComplexPropertyBeforeSet));
        }
    }

    public synchronized void unregisterConfiguration(TypeConfiguration config) {
        if (this.allConfigurations.remove(config)) {
            this.dirty = true;
            if (StringUtils.isNotBlank((String)config.prefetchInfo)) {
                log.info((Object)("Unregistered global prefetch: " + config.prefetchInfo));
            }
            if (config.clearComplexPropertyBeforeSet != null) {
                log.info((Object)("Unregistered clearComplexPropertyBeforeSet: " + config.clearComplexPropertyBeforeSet));
            }
        } else {
            log.error((Object)("Unregistering unknown configuration: " + config));
        }
    }

    public synchronized void registerSchema(SchemaBindingDescriptor sd) {
        this.allSchemas.add(sd);
        this.dirty = true;
        log.info((Object)("Registered schema: " + sd.name));
    }

    public synchronized void unregisterSchema(SchemaBindingDescriptor sd) {
        if (this.allSchemas.remove(sd)) {
            this.dirty = true;
            log.info((Object)("Unregistered schema: " + sd.name));
        } else {
            log.error((Object)("Unregistering unknown schema: " + sd.name));
        }
    }

    public synchronized void registerFacet(FacetDescriptor fd) {
        this.allFacets.removeIf(f -> f.getName().equals(fd.getName()));
        this.allFacets.add(fd);
        this.dirty = true;
        log.info((Object)("Registered facet: " + fd.name));
    }

    public synchronized void unregisterFacet(FacetDescriptor fd) {
        if (this.allFacets.remove(fd)) {
            this.dirty = true;
            log.info((Object)("Unregistered facet: " + fd.name));
        } else {
            log.error((Object)("Unregistering unknown facet: " + fd.name));
        }
    }

    public synchronized void registerDocumentType(DocumentTypeDescriptor dtd) {
        this.allDocumentTypes.add(dtd);
        this.dirty = true;
        log.info((Object)("Registered document type: " + dtd.name));
    }

    public synchronized void unregisterDocumentType(DocumentTypeDescriptor dtd) {
        if (this.allDocumentTypes.remove(dtd)) {
            this.dirty = true;
            log.info((Object)("Unregistered document type: " + dtd.name));
        } else {
            log.error((Object)("Unregistering unknown document type: " + dtd.name));
        }
    }

    public DocumentTypeDescriptor getDocumentTypeDescriptor(String name) {
        DocumentTypeDescriptor last = null;
        for (DocumentTypeDescriptor dtd : this.allDocumentTypes) {
            if (!dtd.name.equals(name)) continue;
            last = dtd;
        }
        return last;
    }

    public FacetDescriptor getFacetDescriptor(String name) {
        return this.allFacets.stream().filter(f -> f.getName().equals(name)).reduce((a, b) -> b).orElse(null);
    }

    public void recomputeDynamicFacets() {
        this.recomputeFacets();
        this.dirty = false;
    }

    public synchronized void registerProxies(ProxiesDescriptor pd) {
        this.allProxies.add(pd);
        this.dirty = true;
        log.info((Object)("Registered proxies descriptor for schemas: " + pd.getSchemas()));
    }

    public synchronized void unregisterProxies(ProxiesDescriptor pd) {
        if (this.allProxies.remove(pd)) {
            this.dirty = true;
            log.info((Object)("Unregistered proxies descriptor for schemas: " + pd.getSchemas()));
        } else {
            log.error((Object)("Unregistering unknown proxies descriptor for schemas: " + pd.getSchemas()));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void checkDirty() {
        if (!this.dirty) {
            return;
        }
        SchemaManagerImpl schemaManagerImpl = this;
        synchronized (schemaManagerImpl) {
            if (!this.dirty) {
                return;
            }
            this.recompute();
            this.dirty = false;
            this.executeRecomputeCallbacks();
        }
    }

    protected void recompute() {
        this.recomputeConfiguration();
        this.recomputeSchemas();
        this.recomputeFacets();
        this.recomputeDocumentTypes();
        this.recomputeProxies();
        this.fields.clear();
    }

    protected void recomputeConfiguration() {
        this.prefetchInfo = null;
        this.clearComplexPropertyBeforeSet = true;
        for (TypeConfiguration tc : this.allConfigurations) {
            if (StringUtils.isNotBlank((String)tc.prefetchInfo)) {
                this.prefetchInfo = new PrefetchInfo(tc.prefetchInfo);
            }
            if (tc.clearComplexPropertyBeforeSet == null) continue;
            this.clearComplexPropertyBeforeSet = tc.clearComplexPropertyBeforeSet;
        }
    }

    protected void recomputeSchemas() {
        this.schemas.clear();
        this.uriToSchema.clear();
        this.prefixToSchema.clear();
        RuntimeException errors = new RuntimeException("Cannot load schemas");
        this.clearSchemaDir();
        LinkedHashMap<String, SchemaBindingDescriptor> resolvedSchemas = new LinkedHashMap<String, SchemaBindingDescriptor>();
        for (SchemaBindingDescriptor sd : this.allSchemas) {
            String name = sd.name;
            if (resolvedSchemas.containsKey(name)) {
                if (!sd.override) {
                    log.warn((Object)("Schema " + name + " is redefined but will not be overridden"));
                    continue;
                }
                log.debug((Object)("Reregistering schema: " + name + " from " + sd.file));
            } else {
                log.debug((Object)("Registering schema: " + name + " from " + sd.file));
            }
            resolvedSchemas.put(name, sd);
        }
        for (SchemaBindingDescriptor sd : resolvedSchemas.values()) {
            try {
                this.copySchema(sd);
            }
            catch (IOException error) {
                errors.addSuppressed(error);
            }
        }
        for (SchemaBindingDescriptor sd : resolvedSchemas.values()) {
            try {
                this.loadSchema(sd);
            }
            catch (IOException | TypeException | SAXException error) {
                errors.addSuppressed(error);
            }
        }
        if (errors.getSuppressed().length > 0) {
            throw errors;
        }
    }

    protected void copySchema(SchemaBindingDescriptor sd) throws IOException {
        if (sd.src == null || sd.src.length() == 0) {
            return;
        }
        URL url = sd.context.getLocalResource(sd.src);
        if (url == null) {
            url = sd.context.getResource(sd.src);
        }
        if (url == null) {
            log.error((Object)("XSD Schema not found: " + sd.src));
            return;
        }
        try (InputStream in = url.openStream();){
            sd.file = new File(this.schemaDir, sd.name + ".xsd");
            FileUtils.copyInputStreamToFile((InputStream)in, (File)sd.file);
        }
    }

    protected void loadSchema(SchemaBindingDescriptor sd) throws IOException, SAXException, TypeException {
        if (sd.file == null) {
            return;
        }
        XSDLoader schemaLoader = new XSDLoader(this, sd);
        schemaLoader.loadSchema(sd.name, sd.prefix, sd.file, sd.xsdRootElement, sd.isVersionWritable);
        log.info((Object)("Registered schema: " + sd.name + " from " + sd.file));
    }

    protected void registerSchema(Schema schema) {
        this.schemas.put(schema.getName(), schema);
        Namespace ns = schema.getNamespace();
        this.uriToSchema.put(ns.uri, schema);
        if (!StringUtils.isBlank((String)ns.prefix)) {
            this.prefixToSchema.put(ns.prefix, schema);
        }
    }

    @Override
    public Schema[] getSchemas() {
        this.checkDirty();
        return new ArrayList<Schema>(this.schemas.values()).toArray(new Schema[0]);
    }

    @Override
    public Schema getSchema(String name) {
        this.checkDirty();
        return this.schemas.get(name);
    }

    @Override
    public Schema getSchemaFromPrefix(String schemaPrefix) {
        this.checkDirty();
        return this.prefixToSchema.get(schemaPrefix);
    }

    @Override
    public Schema getSchemaFromURI(String schemaURI) {
        this.checkDirty();
        return this.uriToSchema.get(schemaURI);
    }

    protected void recomputeFacets() {
        this.facets.clear();
        this.noPerDocumentQueryFacets.clear();
        for (FacetDescriptor fd : this.allFacets) {
            this.recomputeFacet(fd);
        }
    }

    protected void recomputeFacet(FacetDescriptor fd) {
        Set<String> fdSchemas = SchemaDescriptor.getSchemaNames(fd.schemas);
        this.registerFacet(fd.name, fdSchemas);
        if (Boolean.FALSE.equals(fd.perDocumentQuery)) {
            this.noPerDocumentQueryFacets.add(fd.name);
        }
    }

    protected CompositeType registerFacet(String name, Set<String> schemaNames) {
        ArrayList<Schema> facetSchemas = new ArrayList<Schema>(schemaNames.size());
        for (String schemaName : schemaNames) {
            Schema schema = this.schemas.get(schemaName);
            if (schema == null) {
                log.error((Object)("Facet: " + name + " uses unknown schema: " + schemaName));
                continue;
            }
            facetSchemas.add(schema);
        }
        CompositeTypeImpl ct = new CompositeTypeImpl(null, "@facets", name, facetSchemas);
        this.facets.put(name, ct);
        return ct;
    }

    @Override
    public CompositeType[] getFacets() {
        this.checkDirty();
        return new ArrayList<CompositeType>(this.facets.values()).toArray(new CompositeType[this.facets.size()]);
    }

    @Override
    public CompositeType getFacet(String name) {
        this.checkDirty();
        return this.facets.get(name);
    }

    @Override
    public Set<String> getNoPerDocumentQueryFacets() {
        this.checkDirty();
        return Collections.unmodifiableSet(this.noPerDocumentQueryFacets);
    }

    protected void recomputeDocumentTypes() {
        LinkedHashMap<String, DocumentTypeDescriptor> dtds = new LinkedHashMap<String, DocumentTypeDescriptor>();
        for (DocumentTypeDescriptor documentTypeDescriptor : this.allDocumentTypes) {
            String name = documentTypeDescriptor.name;
            DocumentTypeDescriptor newDtd = documentTypeDescriptor;
            if (documentTypeDescriptor.append && dtds.containsKey(documentTypeDescriptor.name)) {
                newDtd = this.mergeDocumentTypeDescriptors(documentTypeDescriptor, (DocumentTypeDescriptor)dtds.get(name));
            }
            dtds.put(name, newDtd);
        }
        this.documentTypes.clear();
        this.documentTypesExtending.clear();
        this.registerDocumentType(new DocumentTypeImpl("Document"));
        for (String string : dtds.keySet()) {
            LinkedHashSet<String> stack = new LinkedHashSet<String>();
            this.recomputeDocumentType(string, stack, dtds);
        }
        this.documentTypesForFacet.clear();
        for (DocumentType documentType : this.documentTypes.values()) {
            for (String facet : documentType.getFacets()) {
                Set<String> set = this.documentTypesForFacet.get(facet);
                if (set == null) {
                    set = new HashSet<String>();
                    this.documentTypesForFacet.put(facet, set);
                }
                set.add(documentType.getName());
            }
        }
    }

    protected DocumentTypeDescriptor mergeDocumentTypeDescriptors(DocumentTypeDescriptor src, DocumentTypeDescriptor dst) {
        return dst.clone().merge(src);
    }

    protected DocumentType recomputeDocumentType(String name, Set<String> stack, Map<String, DocumentTypeDescriptor> dtds) {
        DocumentType parent;
        DocumentTypeImpl docType = this.documentTypes.get(name);
        if (docType != null) {
            return docType;
        }
        if (stack.contains(name)) {
            log.error((Object)("Document type: " + name + " used in parent inheritance loop: " + stack));
            return null;
        }
        DocumentTypeDescriptor dtd = dtds.get(name);
        if (dtd == null) {
            log.error((Object)("Document type: " + name + " does not exist, used as parent by type: " + stack));
            return null;
        }
        String parentName = dtd.superTypeName;
        if (parentName == null) {
            parent = null;
        } else {
            parent = this.documentTypes.get(parentName);
            if (parent == null) {
                stack.add(name);
                parent = this.recomputeDocumentType(parentName, stack, dtds);
                stack.remove(name);
            }
        }
        for (Type p = parent; p != null; p = p.getSuperType()) {
            Set<String> set = this.documentTypesExtending.get(p.getName());
            set.add(name);
        }
        return this.recomputeDocumentType(name, dtd, parent);
    }

    protected DocumentType recomputeDocumentType(String name, DocumentTypeDescriptor dtd, DocumentType parent) {
        HashSet<String> facetNames = new HashSet<String>();
        Set<String> schemaNames = SchemaDescriptor.getSchemaNames(dtd.schemas);
        facetNames.addAll(Arrays.asList(dtd.facets));
        HashSet<String> subtypes = new HashSet<String>(Arrays.asList(dtd.subtypes));
        HashSet<String> forbidden = new HashSet<String>(Arrays.asList(dtd.forbiddenSubtypes));
        if (parent != null) {
            facetNames.addAll(parent.getFacets());
            schemaNames.addAll(Arrays.asList(parent.getSchemaNames()));
        }
        for (String string : facetNames) {
            CompositeType ct = this.facets.get(string);
            if (ct == null) {
                log.warn((Object)("Undeclared facet: " + string + " used in document type: " + name));
                ct = this.registerFacet(string, Collections.emptySet());
            }
            schemaNames.addAll(Arrays.asList(ct.getSchemaNames()));
        }
        ArrayList<Schema> docTypeSchemas = new ArrayList<Schema>();
        for (String schemaName : schemaNames) {
            Schema schema = this.schemas.get(schemaName);
            if (schema == null) {
                log.error((Object)("Document type: " + name + " uses unknown schema: " + schemaName));
                continue;
            }
            docTypeSchemas.add(schema);
        }
        PrefetchInfo prefetchInfo = dtd.prefetch == null ? this.prefetchInfo : new PrefetchInfo(dtd.prefetch);
        DocumentTypeImpl docType = new DocumentTypeImpl(name, parent, docTypeSchemas, facetNames, prefetchInfo);
        docType.setSubtypes(subtypes);
        docType.setForbiddenSubtypes(forbidden);
        this.registerDocumentType(docType);
        return docType;
    }

    protected void registerDocumentType(DocumentTypeImpl docType) {
        String name = docType.getName();
        this.documentTypes.put(name, docType);
        this.documentTypesExtending.put(name, new HashSet<String>(Collections.singleton(name)));
    }

    @Override
    public DocumentType getDocumentType(String name) {
        this.checkDirty();
        return this.documentTypes.get(name);
    }

    @Override
    public Set<String> getDocumentTypeNamesForFacet(String facet) {
        this.checkDirty();
        return this.documentTypesForFacet.get(facet);
    }

    @Override
    public Set<String> getDocumentTypeNamesExtending(String docTypeName) {
        this.checkDirty();
        return this.documentTypesExtending.get(docTypeName);
    }

    @Override
    public DocumentType[] getDocumentTypes() {
        this.checkDirty();
        return new ArrayList<DocumentTypeImpl>(this.documentTypes.values()).toArray(new DocumentType[0]);
    }

    @Override
    public int getDocumentTypesCount() {
        this.checkDirty();
        return this.documentTypes.size();
    }

    @Override
    public boolean hasSuperType(String docType, String superType) {
        if (docType == null || superType == null) {
            return false;
        }
        Set<String> subTypes = this.getDocumentTypeNamesExtending(superType);
        return subTypes != null && subTypes.contains(docType);
    }

    @Override
    public Set<String> getAllowedSubTypes(String typeName) {
        DocumentType dt = this.getDocumentType(typeName);
        return dt == null ? null : dt.getAllowedSubtypes();
    }

    protected void recomputeProxies() {
        ArrayList<Schema> list = new ArrayList<Schema>();
        HashSet<String> nameSet = new HashSet<String>();
        for (ProxiesDescriptor pd : this.allProxies) {
            if (!pd.getType().equals("*")) {
                log.error((Object)("Proxy descriptor for specific type not supported: " + pd));
            }
            for (String schemaName : pd.getSchemas()) {
                if (nameSet.contains(schemaName)) continue;
                Schema schema = this.schemas.get(schemaName);
                if (schema == null) {
                    log.error((Object)("Proxy schema uses unknown schema: " + schemaName));
                    continue;
                }
                list.add(schema);
                nameSet.add(schemaName);
            }
        }
        this.proxySchemas = list;
        this.proxySchemaNames = nameSet;
    }

    @Override
    public List<Schema> getProxySchemas(String docType) {
        this.checkDirty();
        return new ArrayList<Schema>(this.proxySchemas);
    }

    @Override
    public boolean isProxySchema(String schema, String docType) {
        this.checkDirty();
        return this.proxySchemaNames.contains(schema);
    }

    @Override
    public Field getField(String xpath) {
        this.checkDirty();
        Field field = null;
        if (xpath != null && xpath.contains("/")) {
            String[] properties = xpath.split("/");
            Field resolvedField = this.getField(properties[0]);
            for (int x = 1; x < properties.length && resolvedField != null; ++x) {
                resolvedField = this.getField(resolvedField, properties[x], x == properties.length - 1);
            }
            if (resolvedField != null) {
                field = resolvedField;
            }
        } else {
            field = this.fields.get(xpath);
            if (field == null) {
                QName qname = QName.valueOf(xpath);
                String prefix = qname.getPrefix();
                Schema schema = this.getSchemaFromPrefix(prefix);
                if (schema == null) {
                    schema = this.getSchema(prefix);
                }
                if (schema != null && (field = schema.getField(qname.getLocalName())) != null) {
                    this.fields.put(xpath, field);
                }
            }
        }
        return field;
    }

    @Override
    public Field getField(Field parent, String subFieldName) {
        return this.getField(parent, subFieldName, true);
    }

    protected Field getField(Field parent, String subFieldName, boolean finalCall) {
        if (parent != null) {
            Type type = parent.getType();
            if (type.isListType()) {
                ListType listType = (ListType)type;
                if ("*".equals(subFieldName)) {
                    if (!finalCall) {
                        return parent;
                    }
                    return this.resolveSubField(listType, null, true);
                }
                try {
                    Integer.valueOf(subFieldName);
                    if (!finalCall) {
                        return parent;
                    }
                    return this.resolveSubField(listType, null, true);
                }
                catch (NumberFormatException e) {
                    return this.resolveSubField(listType, subFieldName, false);
                }
            }
            if (type.isComplexType()) {
                return ((ComplexType)type).getField(subFieldName);
            }
        }
        return null;
    }

    protected Field resolveSubField(ListType listType, String subName, boolean fallbackOnSubElement) {
        Type itemType = listType.getFieldType();
        if (itemType.isComplexType() && subName != null) {
            ComplexType complexType = (ComplexType)itemType;
            Field subField = complexType.getField(subName);
            return subField;
        }
        if (fallbackOnSubElement) {
            return listType.getField();
        }
        return null;
    }

    public void flushPendingsRegistration() {
        this.checkDirty();
    }

    public void registerRecomputeCallback(Runnable callback) {
        this.recomputeCallbacks.add(callback);
    }

    public void unregisterRecomputeCallback(Runnable callback) {
        this.recomputeCallbacks.remove(callback);
    }

    protected void executeRecomputeCallbacks() {
        this.recomputeCallbacks.forEach(Runnable::run);
    }

    public synchronized void registerPropertyDeprecation(PropertyDeprecationDescriptor descriptor) {
        Map<String, Map<String, String>> properties = descriptor.isDeprecated() ? this.deprecatedProperties : this.removedProperties;
        properties.computeIfAbsent(descriptor.getSchema(), key -> new HashMap()).put(descriptor.getName(), descriptor.getFallback());
        log.info((Object)("Registered property deprecation: " + descriptor));
    }

    public synchronized void unregisterPropertyDeprecation(PropertyDeprecationDescriptor descriptor) {
        Map<String, Map<String, String>> properties = descriptor.isDeprecated() ? this.deprecatedProperties : this.removedProperties;
        boolean removed = false;
        Map<String, String> schemaProperties = properties.get(descriptor.getSchema());
        if (schemaProperties != null) {
            removed = schemaProperties.remove(descriptor.getName(), descriptor.getFallback());
            if (schemaProperties.isEmpty()) {
                properties.remove(descriptor.getSchema());
            }
        }
        if (removed) {
            log.info((Object)("Unregistered property deprecation: " + descriptor));
        } else {
            log.error((Object)("Unregistering unknown property deprecation: " + descriptor));
        }
    }

    @Override
    public PropertyDeprecationHandler getDeprecatedProperties() {
        return new PropertyDeprecationHandler(this.deprecatedProperties);
    }

    @Override
    public PropertyDeprecationHandler getRemovedProperties() {
        return new PropertyDeprecationHandler(this.removedProperties);
    }

    @Override
    public boolean getClearComplexPropertyBeforeSet() {
        return this.clearComplexPropertyBeforeSet;
    }
}

