/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.core.schema.types.constraints;

import java.io.Serializable;
import java.text.DateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.Locale;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuxeo.ecm.core.schema.types.constraints.AbstractConstraint;
import org.nuxeo.ecm.core.schema.types.constraints.Constraint;
import org.nuxeo.ecm.core.schema.types.constraints.ConstraintUtils;

public class DateIntervalConstraint
extends AbstractConstraint {
    private static final long serialVersionUID = 3630463971175189087L;
    private static final Log log = LogFactory.getLog(DateIntervalConstraint.class);
    private static final String NAME = "DateIntervalConstraint";
    private static final String PNAME_MINIMUM = "Minimum";
    private static final String PNAME_MAXIMUM = "Maximum";
    private static final String PNAME_MIN_INC = "MinimumInclusive";
    private static final String PNAME_MAX_INC = "MaximumInclusive";
    private final Long minTime;
    private final Long maxTime;
    private final boolean includingMin;
    private final boolean includingMax;

    public DateIntervalConstraint(Object minDate, boolean includingMin, Object maxDate, boolean includingMax) {
        this.minTime = ConstraintUtils.objectToTimeMillis(minDate);
        this.includingMin = includingMin;
        this.maxTime = ConstraintUtils.objectToTimeMillis(maxDate);
        this.includingMax = includingMax;
        if (this.minTime != null && this.maxTime != null && this.minTime > this.maxTime) {
            log.warn((Object)("lower bound (" + minDate + ") is greater than upper bound (" + maxDate + "). No dates could be valid."));
        }
        if (this.minTime == null && minDate != null || this.maxTime == null && maxDate != null) {
            log.warn((Object)("some bound was ignored due to invalid date format (supported format is yyyy-MM-dd (min = " + minDate + " - max = " + maxDate + ")"));
        }
    }

    @Override
    public boolean validate(Object object) {
        if (object == null) {
            return true;
        }
        Long timeValue = ConstraintUtils.objectToTimeMillis(object);
        if (timeValue == null) {
            return false;
        }
        if (this.minTime != null) {
            if (timeValue < this.minTime) {
                return false;
            }
            if (!this.includingMin && timeValue.longValue() == this.minTime.longValue()) {
                return false;
            }
        }
        if (this.maxTime != null) {
            if (timeValue > this.maxTime) {
                return false;
            }
            if (!this.includingMax && timeValue.longValue() == this.maxTime.longValue()) {
                return false;
            }
        }
        return true;
    }

    @Override
    public Constraint.Description getDescription() {
        HashMap<String, Serializable> params = new HashMap<String, Serializable>();
        if (this.minTime != null) {
            params.put(PNAME_MINIMUM, new Date(this.minTime));
            params.put(PNAME_MIN_INC, Boolean.valueOf(this.includingMin));
        }
        if (this.maxTime != null) {
            params.put(PNAME_MAXIMUM, new Date(this.maxTime));
            params.put(PNAME_MAX_INC, Boolean.valueOf(this.includingMax));
        }
        return new Constraint.Description(NAME, params);
    }

    public Long getMinTime() {
        return this.minTime;
    }

    public Long getMaxTime() {
        return this.maxTime;
    }

    public boolean isIncludingMin() {
        return this.includingMin;
    }

    public boolean isIncludingMax() {
        return this.includingMax;
    }

    @Override
    public String getErrorMessage(Object invalidValue, Locale locale) {
        Object[] params;
        String min;
        Locale computedLocale = locale != null ? locale : Constraint.MESSAGES_DEFAULT_LANG;
        String subKey = (this.minTime != null ? (this.includingMin ? "minin" : "minex") : "") + (this.maxTime != null ? (this.includingMax ? "maxin" : "maxex") : "");
        DateFormat format = DateFormat.getDateInstance(2, computedLocale);
        if (this.minTime != null && this.maxTime != null) {
            min = format.format(new Date(this.minTime));
            String max = format.format(new Date(this.maxTime));
            params = new Object[]{min, max};
        } else if (this.minTime != null) {
            min = format.format(new Date(this.minTime));
            params = new Object[]{min};
        } else {
            String max = format.format(new Date(this.maxTime));
            params = new Object[]{max};
        }
        ArrayList<String> pathTokens = new ArrayList<String>();
        pathTokens.add("label.schema.constraint.violation");
        pathTokens.add(NAME);
        pathTokens.add(subKey);
        String key = StringUtils.join(pathTokens, (char)'.');
        String message = DateIntervalConstraint.getMessageString("messages", key, params, computedLocale);
        if (message != null && !message.trim().isEmpty() && !key.equals(message)) {
            return message;
        }
        return super.getErrorMessage(invalidValue, computedLocale);
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.includingMax ? 1231 : 1237);
        result = 31 * result + (this.includingMin ? 1231 : 1237);
        result = 31 * result + (this.maxTime == null ? 0 : this.maxTime.hashCode());
        result = 31 * result + (this.minTime == null ? 0 : this.minTime.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        DateIntervalConstraint other = (DateIntervalConstraint)obj;
        if (this.includingMax != other.includingMax) {
            return false;
        }
        if (this.includingMin != other.includingMin) {
            return false;
        }
        if (this.maxTime == null ? other.maxTime != null : !this.maxTime.equals(other.maxTime)) {
            return false;
        }
        return !(this.minTime == null ? other.minTime != null : !this.minTime.equals(other.minTime));
    }
}

