/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.automation.core.operations.document;

import java.io.IOException;
import org.nuxeo.ecm.automation.core.annotations.Context;
import org.nuxeo.ecm.automation.core.annotations.Operation;
import org.nuxeo.ecm.automation.core.annotations.OperationMethod;
import org.nuxeo.ecm.automation.core.annotations.Param;
import org.nuxeo.ecm.automation.core.collectors.DocumentModelCollector;
import org.nuxeo.ecm.automation.core.util.DocumentHelper;
import org.nuxeo.ecm.automation.core.util.Properties;
import org.nuxeo.ecm.core.api.CoreSession;
import org.nuxeo.ecm.core.api.DocumentModel;
import org.nuxeo.ecm.core.api.DocumentRef;

@Operation(id="Document.Create", category="Document", label="Create", description="Create a new document in the input folder. You can initialize the document properties using the 'properties' parameter. The properties are specified as <i>key=value</i> pairs separated by a new line. The key used for a property is the property xpath. To specify multi-line values, you can use a \\ character followed by a new line. <p>Example:<pre>dc:title=The Document Title<br>dc:description=foo bar</pre>. Returns the created document.")
public class CreateDocument {
    public static final String ID = "Document.Create";
    @Context
    protected CoreSession session;
    @Param(name="type")
    protected String type;
    @Param(name="name", required=false)
    protected String name;
    @Param(name="properties", required=false)
    protected Properties content;

    @OperationMethod(collector=DocumentModelCollector.class)
    public DocumentModel run(DocumentModel doc) throws IOException {
        if (this.name == null) {
            this.name = "Untitled";
        }
        DocumentModel newDoc = this.session.createDocumentModel(doc.getPathAsString(), this.name, this.type);
        if (this.content != null) {
            DocumentHelper.setProperties(this.session, newDoc, this.content);
        }
        return this.session.createDocument(newDoc);
    }

    @OperationMethod(collector=DocumentModelCollector.class)
    public DocumentModel run(DocumentRef doc) throws IOException {
        return this.run(this.session.getDocument(doc));
    }
}

