/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.automation.core.operations.document;

import org.nuxeo.ecm.automation.core.annotations.Context;
import org.nuxeo.ecm.automation.core.annotations.Operation;
import org.nuxeo.ecm.automation.core.annotations.OperationMethod;
import org.nuxeo.ecm.automation.core.annotations.Param;
import org.nuxeo.ecm.automation.core.collectors.DocumentModelCollector;
import org.nuxeo.ecm.core.api.CoreSession;
import org.nuxeo.ecm.core.api.DocumentModel;
import org.nuxeo.ecm.core.api.DocumentModelList;

@Operation(id="Document.RemoveProxies", category="Document", label="Remove Document Proxies", description="Will remove all proxies pointing on the input document. Useful for instance to unpublish a document. Notice: this operation will remove all proxies, including the ones pointing to the current document version (live proxies). Activating the save parameter forces the changes to be written in database immediately (at the cost of performance loss).", aliases={"Document.RemoveProxies"})
public class RemoveProxies {
    public static final String ID = "Document.RemoveProxies";
    @Context
    protected CoreSession session;
    @Param(name="save", required=false, values={"true"})
    protected boolean save = true;

    @OperationMethod(collector=DocumentModelCollector.class)
    public DocumentModel run(DocumentModel input) {
        DocumentModelList proxies = this.session.getProxies(input.getRef(), null);
        for (DocumentModel proxy : proxies) {
            this.session.removeDocument(proxy.getRef());
        }
        if (this.save) {
            this.session.save();
        }
        return input;
    }
}

