/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.automation.core.operations.login;

import org.nuxeo.ecm.automation.OperationContext;
import org.nuxeo.ecm.automation.OperationException;
import org.nuxeo.ecm.automation.core.annotations.Context;
import org.nuxeo.ecm.automation.core.annotations.Operation;
import org.nuxeo.ecm.automation.core.annotations.OperationMethod;
import org.nuxeo.ecm.core.api.DocumentModel;

@Operation(id="Auth.Logout", category="Users & Groups", label="Logout", description="Perform a logout. This should be used only after using the Login As operation to restore original login. This is a void operations - the input will be returned back as the output.")
public class Logout {
    public static final String ID = "Auth.Logout";
    @Context
    protected OperationContext ctx;

    @OperationMethod
    public void run() throws OperationException {
        this.ctx.getLoginStack().pop();
    }

    @OperationMethod
    public DocumentModel run(DocumentModel doc) throws OperationException {
        this.run();
        return this.ctx.getCoreSession().getDocument(doc.getRef());
    }
}

