/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.automation.core.operations.traces;

import org.nuxeo.ecm.automation.OperationContext;
import org.nuxeo.ecm.automation.core.annotations.Context;
import org.nuxeo.ecm.automation.core.annotations.Operation;
import org.nuxeo.ecm.automation.core.annotations.OperationMethod;
import org.nuxeo.ecm.automation.core.annotations.Param;
import org.nuxeo.ecm.core.api.NuxeoPrincipal;
import org.nuxeo.ecm.webengine.JsonFactoryManager;
import org.nuxeo.runtime.api.Framework;

@Operation(id="JsonStack.ToggleDisplay", category="Execution Context", label="Json Error Stack Display", description="Toggle stack display in json response for all rest api calls in Nuxeo", addToStudio=false, since="6.0")
public class JsonStackToggleDisplayOperation {
    public static final String ID = "JsonStack.ToggleDisplay";
    @Param(name="enableTrace", required=false)
    protected Boolean displayStack = null;
    @Context
    protected OperationContext ctx;

    protected boolean canManageStackDisplay() {
        NuxeoPrincipal principal = (NuxeoPrincipal)this.ctx.getPrincipal();
        return principal != null && principal.isAdministrator();
    }

    @OperationMethod
    public boolean run() {
        JsonFactoryManager jsonFactoryManager = (JsonFactoryManager)Framework.getService(JsonFactoryManager.class);
        if (this.canManageStackDisplay()) {
            if (this.displayStack == null) {
                jsonFactoryManager.toggleStackDisplay();
            } else if (this.displayStack.booleanValue() != jsonFactoryManager.isStackDisplay()) {
                jsonFactoryManager.toggleStackDisplay();
            }
        }
        return jsonFactoryManager.isStackDisplay();
    }
}

