/*
 * Decompiled with CFR 0.152.
 */
package net.openhft.affinity;

import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.LineNumberReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.lang.management.ManagementFactory;
import java.text.SimpleDateFormat;
import java.util.Date;
import org.jetbrains.annotations.NotNull;

enum LockCheck {

    static final String TMP = System.getProperty("java.io.tmpdir");
    public static final String TARGET = System.getProperty("project.build.directory", LockCheck.findTarget());
    private static final String OS = System.getProperty("os.name").toLowerCase();
    static final boolean IS_LINUX = OS.startsWith("linux");
    private static SimpleDateFormat df = new SimpleDateFormat("yyyy.MM.dd 'at' HH:mm:ss z");

    private static String findTarget() {
        for (File dir = new File(System.getProperty("user.dir")); dir != null; dir = dir.getParentFile()) {
            File target = new File(dir, "target");
            if (!target.exists()) continue;
            return target.getAbsolutePath();
        }
        return TMP + "/target";
    }

    static long getPID() {
        String processName = ManagementFactory.getRuntimeMXBean().getName();
        return Long.parseLong(processName.split("@")[0]);
    }

    public static boolean isCpuFree(int cpu) {
        if (!IS_LINUX) {
            return true;
        }
        File file = LockCheck.toFile(cpu);
        boolean exists = file.exists();
        if (!exists) {
            return true;
        }
        int currentProcess = 0;
        try {
            currentProcess = LockCheck.getProcessForCpu(file);
        }
        catch (IOException e) {
            e.printStackTrace();
            return true;
        }
        if (!LockCheck.isProcessRunning(currentProcess)) {
            file.delete();
            return true;
        }
        return false;
    }

    @NotNull
    private static File toFile(int core) {
        return new File(LockCheck.tmpDir(), "cpu-" + core + ".lock");
    }

    static void replacePid(int core, long processID) throws IOException {
        LockCheck.replacePid(LockCheck.toFile(core), processID);
    }

    private static void replacePid(File file, long processID) throws IOException {
        file.delete();
        LockCheck.storePid(processID, file);
    }

    static boolean isProcessRunning(long pid) {
        if (IS_LINUX) {
            return new File("/proc/" + pid).exists();
        }
        throw new UnsupportedOperationException("this is only supported on LINUX");
    }

    private static synchronized void storePid(long processID, File coreFile) throws IOException {
        try (BufferedWriter writer = new BufferedWriter(new OutputStreamWriter((OutputStream)new FileOutputStream(coreFile), "utf-8"));){
            String processIDStr = Long.toString(processID);
            writer.write(processIDStr + "\n" + df.format(new Date()));
        }
    }

    static int getProcessForCpu(int core) throws IOException {
        return LockCheck.getProcessForCpu(LockCheck.toFile(core));
    }

    private static int getProcessForCpu(@NotNull File coreFile) throws IOException {
        try (LineNumberReader reader = new LineNumberReader(new BufferedReader(new InputStreamReader((InputStream)new FileInputStream(coreFile), "utf-8")));){
            String s = reader.readLine().trim();
            int n = Integer.parseInt(s);
            return n;
        }
    }

    private static File tmpDir() {
        File tempDir = new File(System.getProperty("java.io.tmpdir"));
        if (!tempDir.exists()) {
            tempDir.mkdirs();
        }
        return tempDir;
    }

    static void updateCpu(int cpu) {
        if (!IS_LINUX) {
            return;
        }
        try {
            LockCheck.replacePid(LockCheck.toFile(cpu), LockCheck.getPID());
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }
}

