/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.core.query.sql.model;

import java.util.Iterator;
import java.util.List;
import org.nuxeo.ecm.core.query.sql.model.Expression;
import org.nuxeo.ecm.core.query.sql.model.IVisitor;
import org.nuxeo.ecm.core.query.sql.model.Operand;
import org.nuxeo.ecm.core.query.sql.model.Operator;
import org.nuxeo.ecm.core.query.sql.model.Predicate;

public class MultiExpression
extends Predicate {
    private static final long serialVersionUID = 1L;
    public final List<Operand> values;

    public MultiExpression(Operator operator, List<Operand> values) {
        super(null, operator, null);
        this.values = values;
    }

    public static MultiExpression fromExpressionList(Operator operator, List<Expression> list) {
        return new MultiExpression(operator, list);
    }

    @Override
    public void accept(IVisitor visitor) {
        visitor.visitMultiExpression(this);
    }

    @Override
    public String toString() {
        StringBuilder buf = new StringBuilder();
        buf.append(this.operator);
        buf.append('(');
        Iterator<Operand> it = this.values.iterator();
        while (it.hasNext()) {
            Operand operand = it.next();
            buf.append(operand.toString());
            if (!it.hasNext()) continue;
            buf.append(", ");
        }
        buf.append(')');
        return buf.toString();
    }

    @Override
    public boolean equals(Object other) {
        if (other == this) {
            return true;
        }
        if (other instanceof MultiExpression) {
            return this.equals((MultiExpression)other);
        }
        return false;
    }

    protected boolean equals(MultiExpression other) {
        return this.values.equals(other.values) && super.equals(other);
    }

    @Override
    public int hashCode() {
        return this.values.hashCode() + super.hashCode();
    }
}

