/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.webengine.model.impl;

import java.io.File;
import java.io.IOException;
import java.util.List;
import org.apache.commons.io.FileUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuxeo.ecm.webengine.loader.ClassProxy;
import org.nuxeo.ecm.webengine.loader.StaticClassProxy;
import org.nuxeo.ecm.webengine.loader.WebLoader;
import org.nuxeo.ecm.webengine.model.WebAdapter;
import org.nuxeo.ecm.webengine.model.WebObject;
import org.nuxeo.ecm.webengine.model.impl.AdapterDescriptor;
import org.nuxeo.ecm.webengine.model.impl.GroovyTypeLoader;
import org.nuxeo.ecm.webengine.model.impl.ModuleImpl;
import org.nuxeo.ecm.webengine.model.impl.TypeDescriptor;
import org.nuxeo.ecm.webengine.model.impl.TypeRegistry;

public class DefaultTypeLoader {
    public static final Log log = LogFactory.getLog(DefaultTypeLoader.class);
    public static final String WEB_TYPES_FILE = "META-INF/web-types";
    protected GroovyTypeLoader gLoader;
    protected final ModuleImpl module;
    protected final WebLoader loader;
    protected final TypeRegistry typeReg;
    protected final File root;

    public DefaultTypeLoader(ModuleImpl module, TypeRegistry typeReg, File root) {
        this.typeReg = typeReg;
        this.root = root;
        this.module = module;
        this.loader = module.getEngine().getWebLoader();
        if (module.hasNature("groovy")) {
            this.gLoader = new GroovyTypeLoader(module.getEngine(), typeReg, root);
        }
    }

    public ModuleImpl getModule() {
        return this.module;
    }

    public void load() {
        if (this.module.configuration.types != null) {
            this.loadTypes(this.module.configuration.types);
        } else {
            File file = new File(this.module.getRoot(), WEB_TYPES_FILE);
            if (file.isFile()) {
                try {
                    this.loadTypesFile(file);
                }
                catch (IOException | ClassNotFoundException e) {
                    log.error((Object)"Failed to load web types from file META-INF/web-types", (Throwable)e);
                }
            }
            if (this.gLoader != null) {
                this.gLoader.load();
            }
        }
    }

    public void flushCache() {
        if (this.gLoader != null) {
            this.gLoader.flushCache();
        }
    }

    protected void loadTypes(Class<?>[] types) {
        for (Class<?> type : types) {
            TypeDescriptor td = this.loadType(type);
            if (td == null) continue;
            this.typeReg.registerTypeDescriptor(td);
        }
    }

    protected void loadTypesFile(File file) throws IOException, ClassNotFoundException {
        List lines = FileUtils.readLines((File)file);
        for (String line : lines) {
            TypeDescriptor td;
            if ((line = line.trim()).length() == 0 || line.startsWith("#")) continue;
            int p = line.indexOf(124);
            if (p > -1) {
                line = line.substring(0, p);
            }
            if ((td = this.loadType(line)) == null) continue;
            this.typeReg.registerTypeDescriptor(td);
        }
    }

    protected TypeDescriptor loadType(String className) throws ClassNotFoundException {
        return this.loadType(this.loader.getClassProxy(className));
    }

    protected TypeDescriptor loadType(Class<?> clazz) {
        return this.loadType(new StaticClassProxy(clazz));
    }

    protected TypeDescriptor loadType(ClassProxy clazz) {
        WebObject type = clazz.get().getAnnotation(WebObject.class);
        if (type != null) {
            return TypeDescriptor.fromAnnotation(clazz, type);
        }
        WebAdapter ws = clazz.get().getAnnotation(WebAdapter.class);
        if (ws != null) {
            return AdapterDescriptor.fromAnnotation(clazz, ws);
        }
        return null;
    }
}

